/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import java.util.ArrayList;
import org.eclipse.wst.jsdt.core.ast.IAbstractFunctionDeclaration;
import org.eclipse.wst.jsdt.core.ast.IArgument;
import org.eclipse.wst.jsdt.core.ast.IAssignment;
import org.eclipse.wst.jsdt.core.ast.IFunctionDeclaration;
import org.eclipse.wst.jsdt.core.ast.IFunctionExpression;
import org.eclipse.wst.jsdt.core.ast.IJsDoc;
import org.eclipse.wst.jsdt.core.ast.IProgramElement;
import org.eclipse.wst.jsdt.core.compiler.CategorizedProblem;
import org.eclipse.wst.jsdt.core.infer.InferredMethod;
import org.eclipse.wst.jsdt.core.infer.InferredType;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.CompilationResult;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Argument;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Javadoc;
import org.eclipse.wst.jsdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.Statement;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CompilationUnitBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalFunctionBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.parser.Parser;
import org.eclipse.wst.jsdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.wst.jsdt.internal.compiler.problem.AbortCompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.problem.AbortMethod;
import org.eclipse.wst.jsdt.internal.compiler.problem.AbortType;
import org.eclipse.wst.jsdt.internal.compiler.problem.ProblemSeverities;

public abstract class AbstractMethodDeclaration
extends Statement
implements IAbstractFunctionDeclaration,
ProblemSeverities,
ReferenceContext {
    private MethodScope fScope;
    private MethodScope prevScope;
    public char[] selector;
    private boolean fIsAnonymous;
    public int declarationSourceStart;
    public int declarationSourceEnd;
    public int modifiers;
    public Argument[] arguments;
    public Statement[] statements;
    public int explicitDeclarations;
    protected MethodBinding binding;
    public boolean ignoreFurtherInvestigation = false;
    public boolean needFreeReturn = false;
    public boolean resolveChildStatments = true;
    public boolean hasResolvedChildStatements = false;
    public Javadoc javadoc;
    public int bodyStart;
    public int bodyEnd = -1;
    public CompilationResult compilationResult;
    public InferredType inferredType;
    public InferredMethod inferredMethod;
    public boolean errorInSignature = false;
    public int exprStackPtr;
    private boolean fhasBuiltLocals;
    private boolean fHasResolved;
    private IFunctionDeclaration fContainingFunction;

    AbstractMethodDeclaration(CompilationResult compilationResult) {
        this.compilationResult = compilationResult;
        this.prevScope = null;
        this.fhasBuiltLocals = false;
        this.fHasResolved = false;
        this.fContainingFunction = null;
    }

    @Override
    public void setArguments(IArgument[] args) {
        if (args instanceof Argument[]) {
            this.arguments = (Argument[])args;
        }
    }

    @Override
    public IArgument[] getArguments() {
        return this.arguments;
    }

    @Override
    public void abort(int abortLevel, CategorizedProblem problem) {
        switch (abortLevel) {
            case 2: {
                throw new AbortCompilation(this.compilationResult, problem);
            }
            case 4: {
                throw new AbortCompilationUnit(this.compilationResult, problem);
            }
            case 8: {
                throw new AbortType(this.compilationResult, problem);
            }
        }
        throw new AbortMethod(this.compilationResult, problem);
    }

    @Override
    public FlowInfo analyseCode(BlockScope classScope, FlowContext initializationContext, FlowInfo info) {
        return this.analyseCode((Scope)classScope, initializationContext, info);
    }

    public abstract FlowInfo analyseCode(Scope var1, FlowContext var2, FlowInfo var3);

    public void bindArguments() {
        if (this.arguments != null && (this.prevScope == null || this.prevScope != this.fScope)) {
            ReferenceBinding declaringClass;
            this.prevScope = this.fScope;
            if (this.binding == null) {
                int i = 0;
                int length = this.arguments.length;
                while (i < length) {
                    this.arguments[i].resolve(this.fScope);
                    ++i;
                }
                return;
            }
            if (this.arguments.length > 0 && this.binding.parameters.length == 0 && (declaringClass = this.binding.declaringClass) instanceof SourceTypeBinding) {
                SourceTypeBinding binding = (SourceTypeBinding)declaringClass;
                binding.resolveTypesFor(this.binding, this);
            }
            boolean used = this.binding.isAbstract();
            int i = 0;
            int length = this.arguments.length;
            while (i < length && i < this.binding.parameters.length) {
                Argument argument = this.arguments[i];
                argument.bind(this.fScope, this.binding.parameters[i], used);
                ++i;
            }
        }
    }

    @Override
    public CompilationResult compilationResult() {
        return this.compilationResult;
    }

    @Override
    public boolean hasErrors() {
        return this.ignoreFurtherInvestigation;
    }

    public boolean isAbstract() {
        if (this.binding != null) {
            return this.binding.isAbstract();
        }
        return (this.modifiers & 0x400) != 0;
    }

    public boolean isClinit() {
        return false;
    }

    public boolean isConstructor() {
        boolean isConstructor = false;
        if (this.inferredMethod != null) {
            isConstructor = this.inferredMethod.isConstructor;
        }
        return isConstructor;
    }

    public boolean isDefaultConstructor() {
        return false;
    }

    public boolean isInitializationMethod() {
        return false;
    }

    public boolean isMethod() {
        return false;
    }

    public boolean isStatic() {
        if (this.binding != null) {
            return this.binding.isStatic();
        }
        return (this.modifiers & 8) != 0;
    }

    public boolean isInferredJsDocType() {
        return (this.bits & 0x4000) != 0;
    }

    public abstract void parseStatements(Parser var1, CompilationUnitDeclaration var2);

    @Override
    public StringBuffer printStatement(int indent, StringBuffer output) {
        return this.print(indent, output);
    }

    @Override
    public StringBuffer print(int tab, StringBuffer output) {
        if (this.javadoc != null) {
            this.javadoc.print(tab, output);
        }
        AbstractMethodDeclaration.printIndent(tab, output);
        output.append("function ");
        if (this.selector != null) {
            output.append(this.selector);
        }
        output.append('(');
        if (this.arguments != null) {
            int i = 0;
            while (i < this.arguments.length) {
                if (i > 0) {
                    output.append(", ");
                }
                this.arguments[i].print(0, output);
                ++i;
            }
        }
        output.append(')');
        this.printBody(tab + 1, output);
        return output;
    }

    public StringBuffer printBody(int indent, StringBuffer output) {
        if (this.isAbstract() || (this.modifiers & 0x1000000) != 0) {
            return output.append(';');
        }
        output.append(" {");
        if (this.statements != null) {
            int i = 0;
            while (i < this.statements.length) {
                output.append('\n');
                this.statements[i].printStatement(indent, output);
                ++i;
            }
        }
        output.append('\n');
        AbstractMethodDeclaration.printIndent(indent == 0 ? 0 : indent - 1, output).append('}');
        return output;
    }

    public StringBuffer printReturnType(int indent, StringBuffer output) {
        return output;
    }

    public void resolve(Scope upperScope) {
        if (this.getScope() == null || this.fhasBuiltLocals) {
            MethodBinding methodBinding;
            this.fHasResolved = true;
            if (this.getScope() == null) {
                this.setScope(new MethodScope(upperScope, this, false));
            }
            CompilationUnitBinding compilationUnitBinding = upperScope.enclosingCompilationUnit();
            if (this.getName() != null && !this.hasBinding()) {
                boolean isLocal = upperScope.kind != 4;
                SourceTypeBinding declaringBinding = null;
                declaringBinding = this.getInferredMethod() != null && this.getInferredMethod().inType != null && this.getInferredMethod().inType.binding != null ? this.getInferredMethod().inType.binding : compilationUnitBinding;
                MethodBinding methodBinding2 = this.fScope.createMethod(this, this.getName(), declaringBinding, false, isLocal);
                this.setBinding(methodBinding2);
            }
            if (this.binding != null && (methodBinding = compilationUnitBinding.resolveTypesFor(this.binding, this)) != null && methodBinding.selector != null) {
                MethodScope enclosingMethodScope = upperScope.enclosingMethodScope();
                if (enclosingMethodScope != null) {
                    enclosingMethodScope.addLocalMethod(methodBinding);
                } else {
                    compilationUnitBinding.addMethod(methodBinding);
                    upperScope.environment().defaultPackage.addBinding(methodBinding, methodBinding.selector, 8);
                }
            }
        }
        if (this.binding == null) {
            this.ignoreFurtherInvestigation = true;
        }
        try {
            if (this.resolveChildStatments && !this.hasResolvedChildStatements) {
                this.hasResolvedChildStatements = true;
                this.bindArguments();
                this.resolveJavadoc();
                this.resolveStatements();
            }
        }
        catch (AbortMethod abortMethod) {
            this.ignoreFurtherInvestigation = true;
        }
    }

    public void resolveJavadoc() {
        if (this.binding == null) {
            return;
        }
        if (this.javadoc != null) {
            this.javadoc.resolve(this.fScope);
            return;
        }
        if (this.binding.declaringClass != null && !this.binding.declaringClass.isLocalType()) {
            this.fScope.problemReporter().javadocMissing(this.sourceStart, this.sourceEnd, this.binding.modifiers);
        }
    }

    public void resolveStatements() {
        if (this.statements != null) {
            ArrayList<Statement> nonFunctions = null;
            ArrayList<AbstractMethodDeclaration> functions = null;
            int i = 0;
            int length = this.statements.length;
            while (i < length) {
                Statement statement = this.statements[i];
                AbstractMethodDeclaration methodDecl = null;
                MethodScope scope = this.fScope;
                if (statement instanceof AbstractMethodDeclaration) {
                    methodDecl = (AbstractMethodDeclaration)statement;
                    if (functions == null) {
                        functions = new ArrayList<AbstractMethodDeclaration>();
                    }
                    functions.add(methodDecl);
                }
                if (methodDecl != null) {
                    methodDecl.resolveChildStatments = false;
                    methodDecl.resolve(scope);
                    methodDecl.resolveChildStatments = true;
                }
                if (!(statement instanceof AbstractMethodDeclaration)) {
                    if (nonFunctions == null) {
                        nonFunctions = new ArrayList<Statement>();
                    }
                    nonFunctions.add(this.statements[i]);
                }
                ++i;
            }
            if (nonFunctions != null) {
                int j = 0;
                while (j < nonFunctions.size()) {
                    Statement statement = (Statement)nonFunctions.get(j);
                    AbstractMethodDeclaration methodDecl = null;
                    BlockScope scope = this.fScope;
                    if (statement instanceof AbstractVariableDeclaration) {
                        AbstractVariableDeclaration variableDecl = (AbstractVariableDeclaration)statement;
                        if (variableDecl.initialization instanceof IFunctionExpression) {
                            methodDecl = ((IFunctionExpression)((Object)variableDecl.initialization)).getMethodDeclaration();
                        }
                    } else if (statement instanceof IAssignment) {
                        SingleNameReference nameRef;
                        Binding binding;
                        IAssignment assignment = (IAssignment)((Object)statement);
                        if (assignment.getExpression() instanceof IFunctionExpression) {
                            methodDecl = ((IFunctionExpression)assignment.getExpression()).getMethodDeclaration();
                        }
                        if (assignment.getLeftHandSide() instanceof SingleNameReference && ((binding = (nameRef = (SingleNameReference)assignment.getLeftHandSide()).findBinding(this.fScope)) instanceof ProblemBinding || !(binding instanceof LocalFunctionBinding) && !(binding instanceof LocalVariableBinding))) {
                            scope = this.fScope.compilationUnitScope();
                        }
                    }
                    if (methodDecl != null) {
                        methodDecl.resolveChildStatments = false;
                        methodDecl.resolve(scope);
                        methodDecl.resolveChildStatments = true;
                    }
                    statement.resolve(this.fScope);
                    ++j;
                }
            }
            if (functions != null) {
                int f = 0;
                while (f < functions.size()) {
                    ((Statement)functions.get(f)).resolve(this.fScope);
                    ++f;
                }
            }
        } else if ((this.bits & 8) != 0) {
            this.fScope.problemReporter().undocumentedEmptyBlock(this.bodyStart - 1, this.bodyEnd + 1);
        }
    }

    @Override
    public void tagAsHavingErrors() {
        this.ignoreFurtherInvestigation = true;
    }

    public void traverse(ASTVisitor visitor, Scope classScope) {
    }

    @Override
    public void resolve(BlockScope scope) {
        this.resolve((Scope)scope);
    }

    @Override
    public boolean isInferred() {
        return this.inferredMethod != null;
    }

    @Override
    public int getASTType() {
        return 1;
    }

    @Override
    public IJsDoc getJsDoc() {
        return this.javadoc;
    }

    @Override
    public IProgramElement[] getStatements() {
        return this.statements;
    }

    @Override
    public char[] getName() {
        char[] name = null;
        if (this.selector != null) {
            name = this.selector;
        } else if (this.inferredMethod != null && this.inferredMethod.name != null) {
            name = this.inferredMethod.name;
        }
        return name;
    }

    @Override
    public void setInferredType(InferredType type) {
        this.inferredType = type;
    }

    @Override
    public InferredMethod getInferredMethod() {
        return this.inferredMethod;
    }

    @Override
    public InferredType getInferredType() {
        return this.inferredType;
    }

    public MethodBinding getBinding() {
        return this.binding;
    }

    public void setBinding(MethodBinding binding) {
        this.binding = binding;
    }

    public boolean hasBinding() {
        return this.binding != null;
    }

    public void setSelector(char[] selector) {
        this.selector = selector;
    }

    public void setIsAnonymous(boolean isAnonymous) {
        this.fIsAnonymous = isAnonymous;
    }

    public boolean isAnonymous() {
        return this.fIsAnonymous || this.getName() == null;
    }

    public void setScope(MethodScope scope) {
        this.fScope = scope;
    }

    public MethodScope getScope() {
        return this.fScope;
    }

    public void setContainingFunction(IFunctionDeclaration containingFunction) {
        if (containingFunction != this) {
            this.fContainingFunction = containingFunction;
        }
    }

    public IFunctionDeclaration getContainingFunction() {
        return this.fContainingFunction;
    }

    public void buildLocals(Scope givenUpperScope) {
        if (!this.fhasBuiltLocals && !this.fHasResolved) {
            this.fhasBuiltLocals = true;
            Scope upperScope = givenUpperScope;
            IFunctionDeclaration containingFunc = this.getContainingFunction();
            if (containingFunc instanceof AbstractMethodDeclaration) {
                ((AbstractMethodDeclaration)((Object)containingFunc)).buildLocals(givenUpperScope);
                upperScope = ((AbstractMethodDeclaration)((Object)containingFunc)).getScope();
            }
            if (this.getScope() == null) {
                this.setScope(new MethodScope(upperScope, this, false));
            }
            this.traverse(new ASTVisitor(){

                @Override
                public boolean visit(Argument argument, BlockScope scope) {
                    if (scope != null && scope instanceof MethodScope) {
                        ((MethodScope)scope).addUnresolvedLocalVar(argument.getName(), argument);
                    }
                    return true;
                }

                @Override
                public boolean visit(LocalDeclaration localDeclaration, BlockScope scope) {
                    if (scope != null && scope instanceof MethodScope) {
                        ((MethodScope)scope).addUnresolvedLocalVar(localDeclaration.getName(), localDeclaration);
                    }
                    return true;
                }

                @Override
                public boolean visit(MethodDeclaration methodDeclaration, Scope scope) {
                    boolean isSelf;
                    boolean bl = isSelf = AbstractMethodDeclaration.this == methodDeclaration;
                    if (scope != null && scope instanceof MethodScope && !isSelf) {
                        ((MethodScope)scope).addUnresolvedLocalFunc(methodDeclaration.getName(), methodDeclaration);
                    }
                    return isSelf;
                }
            }, this.getScope());
        }
    }

    public static AbstractMethodDeclaration findMethodDeclaration(IProgramElement element) {
        AbstractMethodDeclaration methodDecl = null;
        if (element instanceof AbstractMethodDeclaration) {
            methodDecl = (AbstractMethodDeclaration)element;
        } else if (element instanceof AbstractVariableDeclaration) {
            AbstractVariableDeclaration variableDecl = (AbstractVariableDeclaration)element;
            if (variableDecl.initialization instanceof IFunctionExpression) {
                methodDecl = ((IFunctionExpression)((Object)variableDecl.initialization)).getMethodDeclaration();
            }
        } else if (element instanceof IAssignment) {
            IAssignment assignment = (IAssignment)element;
            if (assignment.getExpression() instanceof IFunctionExpression) {
                methodDecl = ((IFunctionExpression)assignment.getExpression()).getMethodDeclaration();
            }
        } else if (element instanceof IFunctionExpression) {
            methodDecl = ((IFunctionExpression)element).getMethodDeclaration();
        }
        return methodDecl;
    }
}

