/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.gef.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.wb.internal.core.utils.ui.MenuIntersector;
import org.eclipse.wb.internal.gef.core.ContextMenuProvider;

public abstract class MultiSelectionContextMenuProvider
extends ContextMenuProvider {
    public MultiSelectionContextMenuProvider(EditPartViewer viewer) {
        super(viewer);
    }

    @Override
    protected final void buildContextMenu() {
        List editParts = this.m_viewer.getSelectedEditParts();
        this.preprocessSelection(editParts);
        if (editParts.isEmpty()) {
            return;
        }
        if (editParts.size() == 1) {
            EditPart editPart = (EditPart)editParts.get(0);
            this.buildContextMenu(editPart, (IMenuManager)this);
            return;
        }
        ArrayList<IMenuManager> managers = new ArrayList<IMenuManager>();
        for (EditPart editPart : editParts) {
            MenuManager manager = new MenuManager();
            this.buildContextMenu(editPart, (IMenuManager)manager);
            managers.add((IMenuManager)manager);
        }
        MenuIntersector.merge((IMenuManager)this, managers);
    }

    protected void preprocessSelection(List<? extends EditPart> editParts) {
    }

    protected abstract void buildContextMenu(EditPart var1, IMenuManager var2);
}

