/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.controls;

import org.eclipse.draw2d.geometry.Interval;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.internal.core.DesignerPlugin;

public abstract class GhostWindow
extends Window {
    private static final int INITIAL_DISTANCE = 35;
    private static final int ALPHA_MULTIPLIER = 5;
    private static final int MAX_DISTANCE = 100;
    private static final double SQRT_OF_TWO = 1.4142;
    private GhostListener m_listener;

    protected GhostWindow(Shell parentShell) {
        super(parentShell);
    }

    public void create() {
        super.create();
        this.m_listener = new GhostListener(this.getShell());
        DesignerPlugin.getStandardDisplay().addFilter(5, (Listener)this.m_listener);
        this.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DesignerPlugin.getStandardDisplay().removeFilter(5, (Listener)GhostWindow.this.m_listener);
            }
        });
    }

    public int open() {
        Shell shell = this.getShell();
        if (shell == null || shell.isDisposed()) {
            this.create();
        }
        this.setup();
        this.getShell().setVisible(true);
        return 0;
    }

    private final void setup() {
        Point mouseLocation = DesignerPlugin.getStandardDisplay().getCursorLocation();
        this.getShell().setLocation(mouseLocation.x + 35, mouseLocation.y + 35);
        this.getShell().setAlpha(7);
        this.m_listener.setEnabled(true);
    }

    private static class GhostListener
    implements Listener {
        private final Shell m_shell;
        private final Display m_display;
        private boolean m_enabled = true;

        public GhostListener(Shell shell) {
            this.m_shell = shell;
            this.m_display = DesignerPlugin.getStandardDisplay();
        }

        public void handleEvent(Event event) {
            if (!this.m_enabled) {
                return;
            }
            Point mouseLocation = this.m_display.getCursorLocation();
            Point shellLocation = this.m_shell.getLocation();
            Point shellSize = this.m_shell.getSize();
            Interval shellWidth = new Interval(shellLocation.x, shellSize.x);
            Interval shellHeight = new Interval(shellLocation.y, shellSize.y);
            int distanceX = shellWidth.distance(mouseLocation.x);
            int distanceY = shellHeight.distance(mouseLocation.y);
            boolean inside = distanceX == 0 && distanceY == 0;
            int distance = (int)Math.sqrt(distanceX * distanceX + distanceY * distanceY);
            if (distance > 100) {
                this.m_enabled = false;
                this.m_shell.setAlpha(0);
                if (this.m_shell.getAlpha() == 255) {
                    this.m_shell.setVisible(false);
                }
                return;
            }
            if (inside) {
                if (this.m_shell.getAlpha() < 255) {
                    this.m_shell.setAlpha(255);
                }
            } else {
                int alpha = 255 - distance * 5;
                this.m_shell.setAlpha(alpha > 0 ? alpha : 0);
            }
        }

        public final void setEnabled(boolean enabled) {
            this.m_enabled = enabled;
        }
    }
}

