/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.core.filters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterPoolManager;
import org.eclipse.rse.core.filters.ISystemFilterPoolManagerProvider;
import org.eclipse.rse.core.filters.ISystemFilterString;
import org.eclipse.rse.core.model.ISystemContentsType;
import org.eclipse.rse.core.model.ISystemModifiableContainer;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.core.filters.SystemFilter;

public class SystemFilterSimple
extends SystemFilter
implements ISystemModifiableContainer {
    private String name = null;
    private String type = null;
    private boolean caseSensitive = false;
    private boolean promptable = false;
    private boolean isStale = true;
    private Object subsystem = null;
    private List filterStrings = new ArrayList(3);
    private HashMap cachedContents = new HashMap();

    public SystemFilterSimple(String name) {
        this.name = name;
    }

    public boolean isTransient() {
        return true;
    }

    public void clone(ISystemFilter targetFilter) {
        super.clone(targetFilter);
        targetFilter.setFilterStrings(this.getFilterStrings());
    }

    public void setFilterString(String filterString) {
        this.filterStrings.clear();
        this.filterStrings.add(filterString);
    }

    public String getFilterString() {
        String result = this.filterStrings.isEmpty() ? null : (String)this.filterStrings.get(0);
        return result;
    }

    public void setSubSystem(ISubSystem parent) {
        this.subsystem = parent;
    }

    public Object getSubSystem() {
        return this.subsystem;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setStringsCaseSensitive(boolean value) {
        this.caseSensitive = value;
    }

    public boolean isStringsCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean areStringsCaseSensitive() {
        return this.caseSensitive;
    }

    public void setPromptable(boolean promptable) {
        this.promptable = promptable;
    }

    public boolean isPromptable() {
        return this.promptable;
    }

    public String[] getFilterStrings() {
        String[] result = new String[this.filterStrings.size()];
        this.filterStrings.toArray(result);
        return result;
    }

    public int getFilterStringCount() {
        return this.filterStrings.size();
    }

    public void setFilterStrings(String[] newStrings) {
        this.filterStrings.clear();
        this.filterStrings.addAll(Arrays.asList(newStrings));
    }

    public ISystemFilterString addFilterString(String newString) {
        this.filterStrings.add(newString);
        return null;
    }

    public ISystemFilterString addFilterString(String newString, int position) {
        this.filterStrings.add(position, newString);
        return null;
    }

    public ISystemFilterString removeFilterString(String oldString) {
        this.filterStrings.remove(oldString);
        return null;
    }

    public ISystemFilterString removeFilterString(int position) {
        this.filterStrings.remove(position);
        return null;
    }

    public Object[] getChildren() {
        return this.getFilterStrings();
    }

    public boolean hasChildren() {
        return this.filterStrings.size() > 0;
    }

    public ISystemFilterString[] getSystemFilterStrings() {
        return null;
    }

    public void setSupportsNestedFilters(boolean value) {
    }

    public boolean supportsNestedFilters() {
        return false;
    }

    public boolean isNested() {
        return false;
    }

    public void updateFilterString(ISystemFilterString filterString, String newValue) {
    }

    public boolean removeFilterString(ISystemFilterString filterString) {
        return false;
    }

    public void moveSystemFilterString(int pos, ISystemFilterString filterString) {
    }

    public void setRelativeOrder(int value) {
    }

    public int getRelativeOrder() {
        return -1;
    }

    public void setDefault(boolean value) {
    }

    public boolean isDefault() {
        return false;
    }

    public void setParentFilter(ISystemFilter l) {
    }

    public ISystemFilter getParentFilter() {
        return null;
    }

    public String[] getSystemFilterNames() {
        return new String[0];
    }

    public ISystemFilter[] getNestedFilters() {
        return new ISystemFilter[0];
    }

    public ISystemFilter[] getSystemFilters() {
        return null;
    }

    public int getSystemFilterCount() {
        return 0;
    }

    public ISystemFilterString[] getStrings() {
        return new ISystemFilterString[0];
    }

    public ISystemFilter getSystemFilter(String aliasName) {
        return null;
    }

    public ISystemFilterPoolManagerProvider getProvider() {
        return null;
    }

    public ISystemFilterPoolManager getSystemFilterPoolManager() {
        return null;
    }

    public IFile getSaveFile() {
        return null;
    }

    public String getSaveFileName() {
        return null;
    }

    public void save() throws Exception {
    }

    public void setContents(ISystemContentsType type, Object[] cachedContents) {
        this.cachedContents.put(type, cachedContents);
        this.isStale = false;
    }

    public Object[] getContents(ISystemContentsType contentsType) {
        return (Object[])this.cachedContents.get(contentsType);
    }

    public boolean hasContents(ISystemContentsType contentsType) {
        return this.cachedContents.containsKey(contentsType);
    }

    public boolean isStale() {
        return this.isStale;
    }

    public void markStale(boolean isStale) {
        this.markStale(isStale, true);
    }

    public void markStale(boolean isStale, boolean clearCache) {
        this.isStale = isStale;
        if (clearCache) {
            this.cachedContents.clear();
        }
    }
}

