/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.jdt.internal.classpath;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.logger.proxy.Logger;

public final class ClasspathUtil {
    private ClasspathUtil() {
    }

    public static Set getResolvedClasspath(IJavaProject jproj, IPath entryToIgnore) {
        return ClasspathUtil.getResolvedClasspath(jproj, Collections.singleton(entryToIgnore));
    }

    public static Set getResolvedClasspath(IJavaProject jproj, Set entriesToIgnore) {
        HashSet<IPath> resolved = new HashSet<IPath>();
        try {
            IClasspathEntry[] entries = jproj.getRawClasspath();
            int i = 0;
            while (i < entries.length) {
                IClasspathEntry entry = entries[i];
                if (!entriesToIgnore.contains(entry.getPath())) {
                    switch (entry.getEntryKind()) {
                        case 1: 
                        case 2: {
                            resolved.add(entry.getPath());
                            break;
                        }
                        case 4: {
                            entry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry);
                            if (entry == null) break;
                            resolved.add(entry.getPath());
                            break;
                        }
                        case 5: {
                            IClasspathContainer container;
                            try {
                                container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)jproj);
                            }
                            catch (JavaModelException e) {
                                Logger.getLogger().logError((Throwable)e);
                                break;
                            }
                            if (container == null) break;
                            IClasspathEntry[] containerEntries = container.getClasspathEntries();
                            int j = 0;
                            while (j < containerEntries.length) {
                                resolved.add(containerEntries[j].getPath());
                                ++j;
                            }
                            break;
                        }
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            Logger.getLogger().logError((Throwable)e);
        }
        return resolved;
    }
}

