/*******************************************************************************
 * Copyright (c) 2000, 2026 IBM Corporation and others.
 *
 * This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.jdt.internal.ui.refactoring.nls.search;

import org.eclipse.swt.graphics.Image;

import org.eclipse.core.resources.IFile;

import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider.IStyledLabelProvider;
import org.eclipse.jface.viewers.StyledString;

import org.eclipse.search.ui.text.AbstractTextSearchViewPage;

import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;

import org.eclipse.jdt.ui.JavaElementLabels;

import org.eclipse.jdt.internal.ui.search.TextSearchLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;


class NLSSearchResultLabelProvider2 extends TextSearchLabelProvider implements IStyledLabelProvider {

	private AppearanceAwareLabelProvider fLabelProvider;

	public NLSSearchResultLabelProvider2(AbstractTextSearchViewPage page) {
		super(page);
		fLabelProvider= new AppearanceAwareLabelProvider(JavaElementLabels.ALL_POST_QUALIFIED, 0);
	}

	@Override
	public StyledString getStyledText(Object element) {
		return getColoredLabelWithCounts(element, internalGetText(element));
	}


	@Override
	public String getText(Object element) {
		return getLabelWithCounts(element, internalGetText(element).getString());
	}

	private StyledString internalGetText(Object element) {
		String description;
		StyledString elementLabel;

		if (element instanceof FileEntry) {
			FileEntry fileEntry= (FileEntry) element;
			description= fileEntry.getMessage();
			elementLabel= getPropertiesName(fileEntry.getPropertiesFile());
		} else if (element instanceof CompilationUnitEntry) {
			CompilationUnitEntry cuEntry= (CompilationUnitEntry) element;
			description= cuEntry.getMessage();
			elementLabel= JavaElementLabels.getStyledTextLabel(cuEntry.getCompilationUnit(), (JavaElementLabels.ALL_POST_QUALIFIED | JavaElementLabels.COLORIZE));
		} else {
			description= NLSSearchMessages.NLSSearchResultLabelProvider2_undefinedKeys;
			elementLabel= JavaElementLabels.getStyledTextLabel(element, (JavaElementLabels.ALL_POST_QUALIFIED | JavaElementLabels.COLORIZE));
		}
		return new StyledString(description).append(' ').append(elementLabel);
	}

	private StyledString getPropertiesName(IFile propertiesFile) {
		String path= BasicElementLabels.getPathLabel(propertiesFile.getFullPath().removeLastSegments(1), false);
		String propertiesName= BasicElementLabels.getResourceName(propertiesFile.getName());
		return new StyledString(propertiesName).append(JavaElementLabels.CONCAT_STRING + path, StyledString.QUALIFIER_STYLER);
	}

	@Override
	public Image getImage(Object element) {
		if (element instanceof FileEntry)
			element= ((FileEntry) element).getPropertiesFile();
		if (element instanceof CompilationUnitEntry)
			element= ((CompilationUnitEntry)element).getCompilationUnit();

		return fLabelProvider.getImage(element);
	}

	@Override
	public void dispose() {
		fLabelProvider.dispose();
		fLabelProvider= null;
		super.dispose();
	}
}
