/*
 * Copyright (c) 2007-2009, 2011, 2012, 2019 Eike Stepper (Loehne, Germany) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *    Eike Stepper - initial API and implementation
 *    Simon McDuff - maintenance
 */
package org.eclipse.emf.internal.cdo.util;

import org.eclipse.emf.internal.cdo.bundle.OM;

import org.eclipse.net4j.util.om.trace.ContextTracer;

import org.eclipse.emf.ecore.EPackage;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

/**
 * @author Eike Stepper
 */
public abstract class PackageClosure implements IPackageClosure
{
  private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_MODEL, PackageClosure.class);

  protected PackageClosure()
  {
  }

  @Override
  public Set<EPackage> calculate(Collection<EPackage> ePackages)
  {
    // Optimize no packages
    if (ePackages.isEmpty())
    {
      return EMPTY_CLOSURE;
    }

    Set<EPackage> visited = new HashSet<>();
    for (EPackage ePackage : ePackages)
    {
      doCollectContents(ePackage, visited);
    }

    return visited;
  }

  private void doCollectContents(EPackage ePackage, Set<EPackage> visited)
  {
    if (TRACER.isEnabled())
    {
      TRACER.trace("Package closure for " + ePackage.getNsURI()); //$NON-NLS-1$
    }

    handleEPackage(ePackage, visited);
    for (EPackage subPackage : ePackage.getESubpackages())
    {
      doCollectContents(subPackage, visited);
    }
  }

  protected abstract void handleEPackage(EPackage ePackage, Set<EPackage> visited);
}
