/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoManager;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.lob.CDOLobHandler;
import org.eclipse.emf.cdo.common.lob.CDOLobStore;
import org.eclipse.emf.cdo.common.lob.CDOLobUtil;
import org.eclipse.emf.cdo.common.model.CDOClassifierRef;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDOListFactory;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionData;
import org.eclipse.emf.cdo.common.revision.CDORevisionFactory;
import org.eclipse.emf.cdo.common.revision.CDORevisionHandler;
import org.eclipse.emf.cdo.server.CDOServerExporter;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageInfo;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.protocol.CDODataInputImpl;
import org.eclipse.emf.cdo.spi.common.revision.DetachedCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.net4j.util.HexUtil;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.io.AsyncOutputStream;
import org.eclipse.net4j.util.io.AsyncWriter;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.monitor.Monitor;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class CDOServerImporter {
    private static final boolean DEBUG_WITH_BROWSER = false;
    private InternalRepository repository;
    private String branchPath;
    private long timeStamp = -1L;
    private final CDOServerExporter.Statistics statistics = new CDOServerExporter.Statistics();

    public CDOServerImporter(IRepository repository) {
        this.repository = (InternalRepository)repository;
        this.init();
    }

    public final String getBranchPath() {
        return this.branchPath;
    }

    protected final void setBranchPath(String branchPath) {
        this.branchPath = branchPath;
    }

    public final long getTimeStamp() {
        return this.timeStamp;
    }

    protected final void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    private void init() {
        LifecycleUtil.checkInactive((Object)this.repository);
        this.repository.setSkipInitialization(true);
        this.repository.getStore().setDropAllDataOnActivate(true);
        LifecycleUtil.activate((Object)this.repository);
    }

    protected final InternalRepository getRepository() {
        return this.repository;
    }

    public CDOServerExporter.Statistics getStatistics() {
        return this.statistics;
    }

    public void importRepository(InputStream in) throws Exception {
        try {
            FlushHandler handler = new FlushHandler();
            this.importAll(in, handler);
            handler.flush();
        }
        finally {
            StoreThreadLocal.release();
            this.repository = null;
        }
    }

    protected abstract void importAll(InputStream var1, Handler var2) throws Exception;

    public static class Binary
    extends CDOServerImporter
    implements CDOServerExporter.BinaryConstants {
        private InternalCDOPackageRegistry packageRegistry;

        public Binary(IRepository repository) {
            super(repository);
        }

        @Override
        protected void importAll(InputStream stream, Handler handler) throws Exception {
            byte opcode;
            CDODataInput in = this.createDataInput(stream);
            block11: while (true) {
                opcode = in.readByte();
                switch (opcode) {
                    case 0: {
                        this.handleRepository(in, handler);
                        continue block11;
                    }
                    case 1: {
                        this.handlePackageUnit(in, handler);
                        continue block11;
                    }
                    case 2: {
                        this.handlePackageInfo(in, handler);
                        continue block11;
                    }
                    case 3: {
                        this.handleBranch(in, handler);
                        continue block11;
                    }
                    case 4: {
                        this.handleRevision(in, handler);
                        continue block11;
                    }
                    case 5: {
                        this.handleBlob(in, handler);
                        continue block11;
                    }
                    case 6: {
                        this.handleClob(in, handler);
                        continue block11;
                    }
                    case 7: {
                        this.handleCommit(in, handler);
                        continue block11;
                    }
                    case -1: {
                        return;
                    }
                }
                break;
            }
            throw new IOException("Illegal opcode: " + opcode);
        }

        private CDODataInput createDataInput(InputStream stream) {
            return new CDODataInputImpl((ExtendedDataInput)new ExtendedDataInputStream((InputStream)new BufferedInputStream(stream))){

                public CDOPackageRegistry getPackageRegistry() {
                    return this.getRepository().getPackageRegistry(false);
                }

                protected CDOBranchManager getBranchManager() {
                    return this.getRepository().getBranchManager();
                }

                protected CDOCommitInfoManager getCommitInfoManager() {
                    return this.getRepository().getCommitInfoManager();
                }

                protected CDORevisionFactory getRevisionFactory() {
                    return this.getRepository().getRevisionManager().getFactory();
                }

                protected CDOListFactory getListFactory() {
                    return CDOListFactory.DEFAULT;
                }

                protected CDOLobStore getLobStore() {
                    return null;
                }

                protected boolean isXCompression() {
                    return true;
                }
            };
        }

        private void handleRepository(CDODataInput in, Handler handler) throws IOException {
            String name = in.readString();
            String uuid = in.readString();
            CDOID root = in.readCDOID();
            long created = in.readLong();
            long committed = in.readLong();
            this.setBranchPath(in.readString());
            this.setTimeStamp(in.readXLong());
            handler.handleRepository(name, uuid, root, created, committed);
        }

        private void handlePackageUnit(CDODataInput in, Handler handler) throws IOException {
            String id = in.readString();
            CDOPackageUnit.Type type = (CDOPackageUnit.Type)in.readEnum(CDOPackageUnit.Type.class);
            long time = in.readXLong();
            String data = in.readString();
            if (!CDOModelUtil.isSystemPackageURI((String)id)) {
                handler.handlePackageUnit(id, type, time, data);
            }
        }

        private void handlePackageInfo(CDODataInput in, Handler handler) throws IOException {
            String packageURI = in.readString();
            if (!CDOModelUtil.isSystemPackageURI((String)packageURI)) {
                handler.handlePackageInfo(packageURI);
            }
        }

        private void handleBranch(CDODataInput in, Handler handler) throws IOException {
            if (this.packageRegistry == null) {
                this.packageRegistry = handler.handleModels();
            }
            int id = in.readXInt();
            String name = in.readString();
            long time = in.readXLong();
            int parentID = in.readXInt();
            handler.handleBranch(id, name, time, parentID);
        }

        private void handleRevision(CDODataInput in, Handler handler) throws IOException {
            CDORevision revision;
            if (in.readBoolean()) {
                CDOID id = in.readCDOID();
                CDOClassifierRef classifierRef = in.readCDOClassifierRef();
                EClass eClass = (EClass)classifierRef.resolve((EPackage.Registry)this.packageRegistry);
                CDOBranch branch = in.readCDOBranch();
                int version = in.readXInt();
                long created = in.readXLong();
                long revised = in.readXLong();
                revision = new DetachedCDORevision(eClass, id, branch, version, created, revised);
            } else {
                revision = in.readCDORevision();
            }
            handler.handleRevision(revision);
        }

        private void handleBlob(CDODataInput in, Handler handler) throws IOException {
            byte[] id = in.readByteArray();
            long size = in.readXLong();
            OutputStream blob = handler.handleBlob(id, size);
            try {
                while (--size >= 0L) {
                    byte b = in.readByte();
                    blob.write(b);
                }
            }
            finally {
                IOUtil.close((Closeable)blob);
            }
        }

        private void handleClob(CDODataInput in, Handler handler) throws IOException {
            byte[] id = in.readByteArray();
            long size = in.readXLong();
            Writer clob = handler.handleClob(id, size);
            try {
                while (--size >= 0L) {
                    char c = in.readChar();
                    clob.write(c);
                }
            }
            finally {
                IOUtil.close((Closeable)clob);
            }
        }

        private void handleCommit(CDODataInput in, Handler handler) throws IOException {
            long time = in.readXLong();
            long previous = in.readXLong();
            int branch = in.readXInt();
            String user = in.readString();
            String comment = in.readString();
            if (handler instanceof Handler2) {
                Handler2 handler2 = (Handler2)handler;
                if (in.readBoolean()) {
                    int mergeSourceBranch = in.readXInt();
                    long mergeSourceTime = in.readXLong();
                    handler2.handleCommitInfo(time, previous, branch, user, comment, mergeSourceBranch, mergeSourceTime);
                    return;
                }
            }
            handler.handleCommitInfo(time, previous, branch, user, comment);
        }
    }

    private final class FlushHandler
    implements Handler2 {
        private OMMonitor monitor = new Monitor();
        private IStoreAccessor.Raw accessor;
        private Map<String, String> models = new HashMap<String, String>();
        private LinkedList<InternalCDOPackageUnit> packageUnits = new LinkedList();
        private List<InternalCDOPackageInfo> packageInfos;
        private InternalCDOPackageRegistry packageRegistry;

        public FlushHandler() {
            this.packageRegistry = CDOServerImporter.this.getRepository().getPackageRegistry(false);
        }

        @Override
        public void handleRepository(String name, String uuid, CDOID root, long created, long committed) {
            CDOServerImporter.this.repository.getStore().setCreationTime(created);
            CDOServerImporter.this.repository.getStore().setLastCommitTime(committed);
            InternalCDOBranchManager branchManager = CDOServerImporter.this.repository.getBranchManager();
            CDOServerImporter.this.repository.initMainBranch(branchManager, created);
            LifecycleUtil.activate((Object)branchManager);
            CDOServerImporter.this.repository.initSystemPackages(true);
            CDOServerImporter.this.repository.setRootResourceID(root);
            this.accessor = (IStoreAccessor.Raw)CDOServerImporter.this.repository.getStore().getWriter(null);
            StoreThreadLocal.setAccessor(this.accessor);
        }

        @Override
        public InternalCDOPackageUnit handlePackageUnit(String id, CDOPackageUnit.Type type, long time, String data) {
            ++((CDOServerImporter)CDOServerImporter.this).statistics.packageUnits;
            this.collectPackageInfos();
            InternalCDOPackageUnit packageUnit = this.packageRegistry.createPackageUnit();
            packageUnit.setOriginalType(type);
            packageUnit.setTimeStamp(time);
            this.models.put(id, data);
            this.packageUnits.add(packageUnit);
            this.packageInfos = new ArrayList<InternalCDOPackageInfo>();
            return packageUnit;
        }

        @Override
        public InternalCDOPackageInfo handlePackageInfo(String packageURI) {
            ++((CDOServerImporter)CDOServerImporter.this).statistics.packageInfos;
            InternalCDOPackageInfo packageInfo = (InternalCDOPackageInfo)CDOModelUtil.createPackageInfo();
            packageInfo.setPackageURI(packageURI);
            this.packageInfos.add(packageInfo);
            return packageInfo;
        }

        @Override
        public InternalCDOPackageRegistry handleModels() {
            this.collectPackageInfos();
            InternalCDOPackageUnit[] array = this.packageUnits.toArray(new InternalCDOPackageUnit[this.packageUnits.size()]);
            this.packageUnits = null;
            final EMFUtil.ExtResourceSet resourceSet = EMFUtil.createExtResourceSet((InternalCDOPackageRegistry)this.packageRegistry, (boolean)false, (boolean)false);
            InternalCDOPackageRegistry.PackageLoader loader = new InternalCDOPackageRegistry.PackageLoader(){

                public EPackage[] loadPackages(CDOPackageUnit packageUnit) {
                    String id = packageUnit.getID();
                    String data = (String)FlushHandler.this.models.get(id);
                    EPackage ePackage = EMFUtil.createEPackage((String)id, (byte[])data.getBytes(), (boolean)false, (ResourceSet)resourceSet, (boolean)true);
                    return EMFUtil.getAllPackages((EPackage)ePackage);
                }
            };
            this.packageRegistry.putPackageUnits(array, CDOPackageUnit.State.PROXY);
            InternalCDOPackageUnit[] internalCDOPackageUnitArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDOPackageUnit packageUnit = internalCDOPackageUnitArray[n2];
                packageUnit.load(loader, false);
                ++n2;
            }
            resourceSet.setDelegating(true);
            EMFUtil.safeResolveAll((ResourceSet)resourceSet);
            this.accessor.rawStore(array, this.monitor);
            return this.packageRegistry;
        }

        @Override
        public InternalCDOBranch handleBranch(int id, String name, long time, int parentID) {
            ++((CDOServerImporter)CDOServerImporter.this).statistics.branches;
            InternalCDOBranchManager branchManager = CDOServerImporter.this.repository.getBranchManager();
            if (id == 0) {
                return branchManager.getMainBranch();
            }
            InternalCDOBranch parent = branchManager.getBranch(parentID);
            return branchManager.createBranch(id, name, parent, time);
        }

        public boolean handleRevision(CDORevision revision) {
            ++((CDOServerImporter)CDOServerImporter.this).statistics.revisions;
            this.accessor.rawStore((InternalCDORevision)revision, this.monitor);
            return true;
        }

        public OutputStream handleBlob(final byte[] id, final long size) throws IOException {
            ++((CDOServerImporter)CDOServerImporter.this).statistics.blobs;
            return new AsyncOutputStream(){

                protected void asyncWrite(InputStream in) throws IOException {
                    FlushHandler.this.accessor.rawStore(id, size, in);
                }
            };
        }

        public Writer handleClob(final byte[] id, final long size) throws IOException {
            ++((CDOServerImporter)CDOServerImporter.this).statistics.clobs;
            return new AsyncWriter(){

                protected void asyncWrite(Reader in) throws IOException {
                    FlushHandler.this.accessor.rawStore(id, size, in);
                }
            };
        }

        @Override
        public void handleCommitInfo(long time, long previous, int branchID, String user, String comment) {
            this.handleCommitInfo(time, previous, branchID, user, comment, 0, 0L);
        }

        @Override
        public void handleCommitInfo(long time, long previous, int branchID, String user, String comment, int mergeSourceBranchID, long mergeSourceTime) {
            ++((CDOServerImporter)CDOServerImporter.this).statistics.commits;
            InternalCDOBranch branch = CDOServerImporter.this.repository.getBranchManager().getBranch(branchID);
            if (mergeSourceBranchID != 0 && this.accessor instanceof IStoreAccessor.Raw2) {
                InternalCDOBranch mergeSourceBranch = CDOServerImporter.this.repository.getBranchManager().getBranch(mergeSourceBranchID);
                CDOBranchPoint mergeSource = mergeSourceBranch.getPoint(mergeSourceTime);
                IStoreAccessor.Raw2 raw2 = (IStoreAccessor.Raw2)this.accessor;
                raw2.rawStore((CDOBranch)branch, time, previous, user, comment, mergeSource, this.monitor);
            } else {
                this.accessor.rawStore((CDOBranch)branch, time, previous, user, comment, this.monitor);
            }
        }

        @Override
        public void flush() {
            this.accessor.rawCommit(1.0, this.monitor);
        }

        private void collectPackageInfos() {
            if (this.packageInfos != null) {
                InternalCDOPackageUnit packageUnit = this.packageUnits.getLast();
                packageUnit.setPackageInfos(this.packageInfos.toArray(new InternalCDOPackageInfo[this.packageInfos.size()]));
                this.packageInfos = null;
            }
        }
    }

    public static interface Handler
    extends CDORevisionHandler,
    CDOLobHandler {
        public void handleRepository(String var1, String var2, CDOID var3, long var4, long var6);

        public InternalCDOPackageUnit handlePackageUnit(String var1, CDOPackageUnit.Type var2, long var3, String var5);

        public InternalCDOPackageInfo handlePackageInfo(String var1);

        public InternalCDOPackageRegistry handleModels();

        public InternalCDOBranch handleBranch(int var1, String var2, long var3, int var5);

        public void handleCommitInfo(long var1, long var3, int var5, String var6, String var7);

        public void flush();
    }

    public static interface Handler2
    extends Handler {
        public void handleCommitInfo(long var1, long var3, int var5, String var6, String var7, int var8, long var9);
    }

    public static class XML
    extends CDOServerImporter
    implements CDOServerExporter.XMLConstants {
        public XML(IRepository repository) {
            super(repository);
        }

        @Override
        protected void importAll(InputStream in, Handler handler) throws Exception {
            XMLHandler xmlHandler = new XMLHandler(this, handler);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(in, (DefaultHandler)xmlHandler);
        }

        private static final class XMLHandler
        extends DefaultHandler {
            private final XML xml;
            private final Handler handler;
            private InternalCDOPackageRegistry packageRegistry;
            private InternalCDOBranch branch;
            private InternalCDORevision revision;
            private Character blobChar;
            private OutputStream blob;
            private Writer clob;

            private XMLHandler(XML xml, Handler handler) {
                this.xml = xml;
                this.handler = handler;
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                if ("repository".equals(qName)) {
                    String name = attributes.getValue("name");
                    String uuid = attributes.getValue("uuid");
                    CDOID root = this.id(attributes.getValue("root"));
                    long created = Long.parseLong(attributes.getValue("created"));
                    long committed = Long.parseLong(attributes.getValue("committed"));
                    String value = attributes.getValue("exportBranch");
                    if (value != null) {
                        this.xml.setBranchPath(value);
                    }
                    if ((value = attributes.getValue("exportTime")) != null) {
                        this.xml.setTimeStamp(Long.parseLong(value));
                    }
                    this.handler.handleRepository(name, uuid, root, created, committed);
                } else if ("packageUnit".equals(qName)) {
                    String id = attributes.getValue("id");
                    if (!CDOModelUtil.isSystemPackageURI((String)id)) {
                        CDOPackageUnit.Type type = CDOPackageUnit.Type.valueOf((String)attributes.getValue("type"));
                        long time = Long.parseLong(attributes.getValue("time"));
                        String data = attributes.getValue("data");
                        this.handler.handlePackageUnit(id, type, time, data);
                    }
                } else if ("packageInfo".equals(qName)) {
                    String packageURI = attributes.getValue("uri");
                    if (!CDOModelUtil.isSystemPackageURI((String)packageURI)) {
                        this.handler.handlePackageInfo(packageURI);
                    }
                } else if ("branch".equals(qName)) {
                    int id = Integer.parseInt(attributes.getValue("id"));
                    String name = attributes.getValue("name");
                    long time = Long.parseLong(attributes.getValue("time"));
                    String parent = attributes.getValue("parent");
                    int parentID = parent == null ? 0 : Integer.parseInt(parent);
                    this.branch = this.handler.handleBranch(id, name, time, parentID);
                } else if ("revision".equals(qName)) {
                    CDOClassifierRef classifierRef = new CDOClassifierRef(attributes.getValue("class"));
                    EClass eClass = (EClass)classifierRef.resolve((EPackage.Registry)this.packageRegistry);
                    CDOID id = this.id(attributes.getValue("id"));
                    int version = Integer.parseInt(attributes.getValue("version"));
                    long created = this.timeStamp(attributes.getValue("time"));
                    long revised = this.timeStamp(attributes.getValue("revised"));
                    boolean detached = "true".equals(attributes.getValue("detached"));
                    if (detached) {
                        this.revision = new DetachedCDORevision(eClass, id, (CDOBranch)this.branch, version, created, revised);
                    } else {
                        String featureID;
                        String containerID;
                        this.revision = (InternalCDORevision)CDORevisionFactory.DEFAULT.createRevision(eClass);
                        this.revision.setID(id);
                        this.revision.setBranchPoint(this.branch.getPoint(created));
                        this.revision.setVersion(version);
                        this.revision.setRevised(revised);
                        String resourceID = attributes.getValue("resource");
                        if (resourceID != null) {
                            this.revision.setResourceID(this.id(resourceID));
                        }
                        if ((containerID = attributes.getValue("container")) != null) {
                            this.revision.setContainerID((Object)this.id(containerID));
                        }
                        if ((featureID = attributes.getValue("feature")) != null) {
                            this.revision.setContainerFeatureID(Integer.parseInt(featureID));
                        }
                    }
                } else if ("feature".equals(qName)) {
                    String name = attributes.getValue("name");
                    EClass eClass = this.revision.getEClass();
                    EStructuralFeature feature = eClass.getEStructuralFeature(name);
                    if (feature == null) {
                        throw new IllegalStateException("Feature " + name + " not found in class " + eClass.getName());
                    }
                    String isSetString = attributes.getValue("isset");
                    if (isSetString != null) {
                        boolean isSet = Boolean.parseBoolean(isSetString);
                        if (isSet) {
                            this.revision.getOrCreateList(feature);
                        }
                    } else {
                        Object value = this.value(attributes);
                        if (feature.isMany()) {
                            if (value == CDORevisionData.NIL) {
                                value = null;
                            }
                            CDOList list = this.revision.getOrCreateList(feature);
                            list.add(value);
                        } else if (value != null) {
                            this.revision.setValue(feature, value);
                        }
                    }
                } else if ("blob".equals(qName)) {
                    try {
                        byte[] id = HexUtil.hexToBytes((String)attributes.getValue("id"));
                        long size = Long.parseLong(attributes.getValue("size"));
                        this.blob = this.handler.handleBlob(id, size);
                    }
                    catch (IOException ex) {
                        throw WrappedException.wrap((Exception)ex);
                    }
                } else if ("clob".equals(qName)) {
                    try {
                        byte[] id = HexUtil.hexToBytes((String)attributes.getValue("id"));
                        long size = Long.parseLong(attributes.getValue("size"));
                        this.clob = this.handler.handleClob(id, size);
                    }
                    catch (IOException ex) {
                        throw WrappedException.wrap((Exception)ex);
                    }
                } else if ("commit".equals(qName)) {
                    long time = Long.parseLong(attributes.getValue("time"));
                    String value = attributes.getValue("previous");
                    long previous = value == null ? 0L : Long.parseLong(value);
                    value = attributes.getValue("branch");
                    int branch = value == null ? 0 : Integer.parseInt(value);
                    String user = attributes.getValue("user");
                    String comment = attributes.getValue("comment");
                    if (this.handler instanceof Handler2) {
                        Handler2 handler2 = (Handler2)this.handler;
                        value = attributes.getValue("mergeSourceBranch");
                        if (value != null) {
                            int mergeSourceBranch = Integer.parseInt(value);
                            long mergeSourceTime = Long.parseLong(attributes.getValue("mergeSourceTime"));
                            handler2.handleCommitInfo(time, previous, branch, user, comment, mergeSourceBranch, mergeSourceTime);
                            return;
                        }
                    }
                    this.handler.handleCommitInfo(time, previous, branch, user, comment);
                }
            }

            @Override
            public void characters(char[] ch, int start, int length) throws SAXException {
                if (this.blob != null) {
                    try {
                        if (this.blobChar != null) {
                            char[] firstChars = new char[]{this.blobChar.charValue(), ch[start]};
                            this.blobChar = null;
                            byte[] firstByte = HexUtil.hexToBytes((String)new String(firstChars));
                            this.blob.write(firstByte, 0, 1);
                            ++start;
                            --length;
                        }
                        if ((length & 1) == 1) {
                            this.blobChar = Character.valueOf(ch[--length]);
                        }
                        if (start != 0 || length != ch.length) {
                            char[] tmp = new char[length];
                            System.arraycopy(ch, start, tmp, 0, length);
                            ch = tmp;
                        }
                        byte[] buf = HexUtil.hexToBytes((String)new String(ch));
                        this.blob.write(buf);
                    }
                    catch (IOException ex) {
                        throw WrappedException.wrap((Exception)ex);
                    }
                }
                if (this.clob != null) {
                    try {
                        this.clob.write(ch, start, length);
                    }
                    catch (IOException ex) {
                        throw WrappedException.wrap((Exception)ex);
                    }
                }
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                if ("models".equals(qName)) {
                    this.packageRegistry = this.handler.handleModels();
                } else if ("branch".equals(qName)) {
                    this.branch = null;
                } else if ("revision".equals(qName)) {
                    this.handler.handleRevision((CDORevision)this.revision);
                    this.revision = null;
                } else if ("blob".equals(qName)) {
                    IOUtil.close((Closeable)this.blob);
                    this.blob = null;
                } else if ("clob".equals(qName)) {
                    IOUtil.close((Closeable)this.clob);
                    this.clob = null;
                }
            }

            protected final CDOID id(String str) {
                return CDOIDUtil.read((String)str);
            }

            protected final long timeStamp(String str) {
                if (str == null) {
                    return 0L;
                }
                return Long.parseLong(str);
            }

            protected Object value(Attributes attributes) {
                byte[] id;
                String isNullString;
                String type = attributes.getValue("type");
                if (type == null && (isNullString = attributes.getValue("isnull")) != null) {
                    boolean isNull = Boolean.parseBoolean(isNullString);
                    if (isNull) {
                        return CDORevisionData.NIL;
                    }
                    throw new IllegalArgumentException("Invalid attribute: isnull=false");
                }
                if ("Blob".equals(type)) {
                    id = HexUtil.hexToBytes((String)attributes.getValue("id"));
                    long size = Long.parseLong(attributes.getValue("size"));
                    return CDOLobUtil.createBlob((byte[])id, (long)size);
                }
                if ("Clob".equals(type)) {
                    id = HexUtil.hexToBytes((String)attributes.getValue("id"));
                    long size = Long.parseLong(attributes.getValue("size"));
                    return CDOLobUtil.createClob((byte[])id, (long)size);
                }
                return this.value(attributes, type);
            }

            protected Object value(Attributes attributes, String type) {
                String str = attributes.getValue("value");
                if (str == null) {
                    return null;
                }
                if (type == null || String.class.getSimpleName().equals(type)) {
                    return str;
                }
                if (Object.class.getSimpleName().equals(type)) {
                    return this.id(str);
                }
                if (Boolean.class.getSimpleName().equals(type)) {
                    return Boolean.valueOf(str);
                }
                if (Character.class.getSimpleName().equals(type)) {
                    return Character.valueOf(str.charAt(0));
                }
                if (Byte.class.getSimpleName().equals(type)) {
                    return Byte.valueOf(str);
                }
                if (Short.class.getSimpleName().equals(type)) {
                    return Short.valueOf(str);
                }
                if (Integer.class.getSimpleName().equals(type)) {
                    return Integer.valueOf(str);
                }
                if (Long.class.getSimpleName().equals(type)) {
                    return Long.valueOf(str);
                }
                if (Float.class.getSimpleName().equals(type)) {
                    return Float.valueOf(str);
                }
                if (Double.class.getSimpleName().equals(type)) {
                    return Double.valueOf(str);
                }
                if (Date.class.getSimpleName().equals(type)) {
                    return new Date(Long.valueOf(str));
                }
                if (BigDecimal.class.getSimpleName().equals(type)) {
                    return new BigDecimal(str);
                }
                if (BigInteger.class.getSimpleName().equals(type)) {
                    return new BigInteger(str);
                }
                if ("ByteArray".equals(type)) {
                    return HexUtil.hexToBytes((String)str);
                }
                throw new IllegalArgumentException("Invalid type: " + type);
            }
        }
    }
}

