/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow;

import java.util.Iterator;
import java.util.List;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.CatchClause;
import org.eclipse.wst.jsdt.core.dom.EnhancedForStatement;
import org.eclipse.wst.jsdt.core.dom.ForInStatement;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.FlowAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.GenericSequentialFlowInfo;

public class InOutFlowAnalyzer
extends FlowAnalyzer {
    public InOutFlowAnalyzer(FlowContext context) {
        super(context);
    }

    public FlowInfo perform(ASTNode[] selectedNodes) {
        FlowContext context = this.getFlowContext();
        GenericSequentialFlowInfo result = this.createSequential();
        int i = 0;
        while (i < selectedNodes.length) {
            ASTNode node = selectedNodes[i];
            node.accept((ASTVisitor)this);
            result.merge(this.getFlowInfo(node), context);
            ++i;
        }
        return result;
    }

    @Override
    protected boolean traverseNode(ASTNode node) {
        return true;
    }

    @Override
    protected boolean createReturnFlowInfo(ReturnStatement node) {
        return true;
    }

    @Override
    public void endVisit(Block node) {
        super.endVisit(node);
        this.clearAccessMode(this.accessFlowInfo((ASTNode)node), node.statements());
    }

    @Override
    public void endVisit(CatchClause node) {
        super.endVisit(node);
        this.clearAccessMode(this.accessFlowInfo((ASTNode)node), node.getException());
    }

    @Override
    public void endVisit(EnhancedForStatement node) {
        super.endVisit(node);
        this.clearAccessMode(this.accessFlowInfo((ASTNode)node), node.getParameter());
    }

    @Override
    public void endVisit(ForStatement node) {
        super.endVisit(node);
        this.clearAccessMode(this.accessFlowInfo((ASTNode)node), node.initializers());
    }

    @Override
    public void endVisit(ForInStatement node) {
        super.endVisit(node);
        if (node.getIterationVariable() instanceof VariableDeclarationExpression) {
            this.clearAccessMode(this.accessFlowInfo((ASTNode)node), ((VariableDeclarationExpression)node.getIterationVariable()).fragments());
        }
    }

    @Override
    public void endVisit(FunctionDeclaration node) {
        super.endVisit(node);
        FlowInfo info = this.accessFlowInfo((ASTNode)node);
        Iterator iter = node.parameters().iterator();
        while (iter.hasNext()) {
            this.clearAccessMode(info, (SingleVariableDeclaration)iter.next());
        }
    }

    private void clearAccessMode(FlowInfo info, SingleVariableDeclaration decl) {
        IVariableBinding binding = decl.resolveBinding();
        if (binding != null && !binding.isField()) {
            info.clearAccessMode(binding, this.fFlowContext);
        }
    }

    private void clearAccessMode(FlowInfo info, VariableDeclarationStatement decl) {
        IVariableBinding binding = decl.resolveBinding();
        if (binding != null && !binding.isField()) {
            info.clearAccessMode(binding, this.fFlowContext);
        }
    }

    private void clearAccessMode(FlowInfo info, List nodes) {
        if (nodes == null || nodes.isEmpty() || info == null) {
            return;
        }
        for (Object node : nodes) {
            Iterator fragments = null;
            if (node instanceof VariableDeclarationStatement) {
                fragments = ((VariableDeclarationStatement)node).fragments().iterator();
            } else if (node instanceof VariableDeclarationExpression) {
                fragments = ((VariableDeclarationExpression)node).fragments().iterator();
            }
            if (fragments == null) continue;
            while (fragments.hasNext()) {
                this.clearAccessMode(info, (VariableDeclarationFragment)fragments.next());
            }
        }
    }

    private void clearAccessMode(FlowInfo info, VariableDeclarationFragment fragment) {
        IVariableBinding binding = fragment.resolveBinding();
        if (binding != null && !binding.isField()) {
            info.clearAccessMode(binding, this.fFlowContext);
        }
    }
}

