/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.transport;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.wst.jsdt.chromium.ConnectionLogger;
import org.eclipse.wst.jsdt.chromium.internal.transport.Connection;
import org.eclipse.wst.jsdt.chromium.internal.transport.Handshaker;
import org.eclipse.wst.jsdt.chromium.internal.transport.LineReader;
import org.eclipse.wst.jsdt.chromium.internal.transport.Message;
import org.eclipse.wst.jsdt.chromium.internal.transport.SocketWrapper;
import org.eclipse.wst.jsdt.chromium.util.SignalRelay;

public class SocketConnection
implements Connection {
    private static final Charset SOCKET_CHARSET = Charset.forName("UTF-8");
    private static final MessageItem EOS = new MessageItem(){

        @Override
        void report(Connection.NetListener listener) {
            LOGGER.log(Level.FINER, "<--EOS");
            listener.eosReceived();
        }

        @Override
        boolean isEos() {
            return true;
        }
    };
    private static final Logger LOGGER = Logger.getLogger(SocketConnection.class.getName());
    private static final int LAMEDUCK_DELAY_MS = 1000;
    private static final Connection.NetListener NULL_LISTENER = new Connection.NetListener(){

        @Override
        public void connectionClosed() {
        }

        @Override
        public void eosReceived() {
        }

        @Override
        public void messageReceived(Message message) {
        }
    };
    private AtomicBoolean isAttached = new AtomicBoolean(false);
    private SocketWrapper socket;
    private final ConnectionLogger connectionLogger;
    private final Handshaker handshaker;
    private volatile Connection.NetListener listener;
    private final BlockingQueue<MessageItem> inboundQueue = new LinkedBlockingQueue<MessageItem>();
    private boolean isInboundQueueClosed = false;
    private final BlockingQueue<Message> outboundQueue = new LinkedBlockingQueue<Message>();
    private final SocketAddress socketEndpoint;
    private WriterThread writerThread;
    private ReaderThread readerThread;
    private final int connectionTimeoutMs;
    private final SignalRelay<Boolean> shutdownRelay = SignalRelay.create(new SignalRelay.Callback<Boolean>(){

        @Override
        public void onSignal(Boolean lameduckMode, Exception cause) {
            this.shutdown(lameduckMode == Boolean.TRUE, cause);
        }

        private void shutdown(boolean lameduckMode, Exception cause) {
            if (!SocketConnection.this.isAttached.compareAndSet(true, false)) {
                return;
            }
            LOGGER.log(Level.INFO, "Shutdown requested", cause);
            if (lameduckMode) {
                Thread terminationThread = new Thread("ServiceThreadTerminator"){

                    @Override
                    public void run() {
                        this.interruptServiceThreads();
                    }
                };
                terminationThread.setDaemon(true);
                terminationThread.start();
                try {
                    terminationThread.join(1000L);
                }
                catch (InterruptedException interruptedException) {}
            } else {
                this.interruptServiceThreads();
            }
        }

        private void interruptServiceThreads() {
            this.interruptThread(SocketConnection.this.writerThread);
            this.interruptThread(SocketConnection.this.readerThread);
        }

        private void interruptThread(Thread thread) {
            try {
                if (thread != null) {
                    thread.interrupt();
                }
            }
            catch (SecurityException securityException) {}
        }
    });

    public SocketConnection(SocketAddress endpoint, int connectionTimeoutMs, ConnectionLogger connectionLogger, Handshaker handshaker) {
        this.socketEndpoint = endpoint;
        this.connectionTimeoutMs = connectionTimeoutMs;
        this.connectionLogger = connectionLogger;
        this.handshaker = handshaker;
    }

    void attach() throws IOException {
        this.socket = new SocketWrapper(this.socketEndpoint, this.connectionTimeoutMs, this.connectionLogger, SOCKET_CHARSET);
        try {
            this.shutdownRelay.bind(this.socket.getShutdownRelay(), null, null);
        }
        catch (SignalRelay.AlreadySignalledException e) {
            throw new IOException("Unexpected: socket is already closed", e);
        }
        this.isAttached.set(true);
        this.readerThread = new ReaderThread((SocketWrapper.LoggableInputStream)this.socket.getLoggableInput(), (SocketWrapper.LoggableOutputStream)this.socket.getLoggableOutput());
        this.writerThread = null;
        this.readerThread.setDaemon(true);
        this.readerThread.start();
    }

    void sendMessage(Message message) {
        try {
            this.outboundQueue.put(message);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runInDispatchThread(final Runnable callback) {
        MessageItem messageItem = new MessageItem(){

            @Override
            void report(Connection.NetListener listener) {
                callback.run();
            }

            @Override
            boolean isEos() {
                return false;
            }
        };
        try {
            BlockingQueue<MessageItem> blockingQueue = this.inboundQueue;
            synchronized (blockingQueue) {
                if (this.isInboundQueueClosed) {
                    throw new IllegalStateException("Connection is closed");
                }
                this.inboundQueue.put(messageItem);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isAttached() {
        return this.isAttached.get();
    }

    private void startWriterThread() {
        if (this.writerThread != null) {
            throw new IllegalStateException();
        }
        this.writerThread = new WriterThread((SocketWrapper.LoggableOutputStream)this.socket.getLoggableOutput());
        this.writerThread.setDaemon(true);
        this.writerThread.start();
    }

    private ResponseDispatcherThread startResponseDispatcherThread() {
        ResponseDispatcherThread dispatcherThread = new ResponseDispatcherThread();
        dispatcherThread.setDaemon(true);
        dispatcherThread.start();
        return dispatcherThread;
    }

    @Override
    public void close() {
        this.shutdownRelay.sendSignal(true, null);
    }

    @Override
    public boolean isConnected() {
        return this.isAttached();
    }

    @Override
    public void send(Message message) {
        this.checkAttached();
        this.sendMessage(message);
    }

    @Override
    public void setNetListener(Connection.NetListener netListener) {
        if (this.listener != null && netListener != this.listener) {
            throw new IllegalStateException("Cannot change NetListener");
        }
        this.listener = netListener != null ? netListener : NULL_LISTENER;
        SignalRelay<Void> listenerCloser = SignalRelay.create(new SignalRelay.Callback<Void>(){

            @Override
            public void onSignal(Void param, Exception cause) {
                SocketConnection.this.listener.connectionClosed();
            }
        });
        try {
            this.shutdownRelay.bind(listenerCloser, null, null);
        }
        catch (SignalRelay.AlreadySignalledException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void start() throws IOException {
        try {
            if (!this.isAttached()) {
                this.attach();
            }
        }
        catch (IOException e) {
            this.listener.connectionClosed();
            throw e;
        }
    }

    private void checkAttached() {
        if (!this.isAttached()) {
            throw new IllegalStateException("Connection not attached");
        }
    }

    private static abstract class InterruptibleThread
    extends Thread {
        protected volatile boolean isTerminated = false;

        InterruptibleThread(String name) {
            super(name);
        }

        @Override
        public synchronized void start() {
            this.isTerminated = false;
            super.start();
        }

        @Override
        public synchronized void interrupt() {
            this.isTerminated = true;
            super.interrupt();
        }
    }

    private static abstract class MessageItem {
        private MessageItem() {
        }

        abstract void report(Connection.NetListener var1);

        abstract boolean isEos();
    }

    private class ReaderThread
    extends InterruptibleThread {
        private final SocketWrapper.LoggableInputStream reader;
        private final SocketWrapper.LoggableOutputStream handshakeWriter;

        public ReaderThread(SocketWrapper.LoggableInputStream reader, SocketWrapper.LoggableOutputStream handshakeWriter) {
            super("ReaderThread");
            this.reader = reader;
            this.handshakeWriter = handshakeWriter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            IOException breakException;
            block20: {
                try {
                    try {
                        SocketConnection.this.startResponseDispatcherThread();
                        if (SocketConnection.this.connectionLogger != null) {
                            SocketConnection.this.connectionLogger.start();
                        }
                        LineReader lineReader = new LineReader(this.reader.getInputStream());
                        SocketConnection.this.handshaker.perform(lineReader, this.handshakeWriter.getOutputStream());
                        this.reader.markSeparatorForLog();
                        this.handshakeWriter.markSeparatorForLog();
                        SocketConnection.this.startWriterThread();
                        while (!this.isTerminated && SocketConnection.this.isAttached.get()) {
                            Message message;
                            try {
                                message = Message.fromBufferedReader(lineReader, SOCKET_CHARSET);
                            }
                            catch (Message.MalformedMessageException e) {
                                LOGGER.log(Level.SEVERE, "Malformed protocol message", e);
                                continue;
                            }
                            if (message == null) {
                                LOGGER.fine("End of stream");
                                break;
                            }
                            SocketConnection.this.inboundQueue.add(new RegularMessageItem(message));
                            this.reader.markSeparatorForLog();
                        }
                        breakException = null;
                    }
                    catch (IOException e) {
                        breakException = e;
                        BlockingQueue blockingQueue = SocketConnection.this.inboundQueue;
                        synchronized (blockingQueue) {
                            SocketConnection.this.inboundQueue.add(EOS);
                            SocketConnection.this.isInboundQueueClosed = true;
                            break block20;
                        }
                    }
                }
                catch (Throwable throwable) {
                    BlockingQueue blockingQueue = SocketConnection.this.inboundQueue;
                    synchronized (blockingQueue) {
                        SocketConnection.this.inboundQueue.add(EOS);
                        SocketConnection.this.isInboundQueueClosed = true;
                    }
                    throw throwable;
                }
                BlockingQueue blockingQueue = SocketConnection.this.inboundQueue;
                synchronized (blockingQueue) {
                    SocketConnection.this.inboundQueue.add(EOS);
                    SocketConnection.this.isInboundQueueClosed = true;
                }
            }
            if (!this.isInterrupted()) {
                SocketConnection.this.shutdownRelay.sendSignal(false, breakException);
            }
        }
    }

    private static class RegularMessageItem
    extends MessageItem {
        private final Message message;

        RegularMessageItem(Message message) {
            this.message = message;
        }

        @Override
        void report(Connection.NetListener listener) {
            LOGGER.log(Level.FINER, "<--{0}", this.message);
            listener.messageReceived(this.message);
        }

        @Override
        boolean isEos() {
            return false;
        }
    }

    private class ResponseDispatcherThread
    extends Thread {
        public ResponseDispatcherThread() {
            super("ResponseDispatcherThread");
        }

        @Override
        public void run() {
            try {
                MessageItem messageItem;
                do {
                    messageItem = (MessageItem)SocketConnection.this.inboundQueue.take();
                    try {
                        messageItem.report(SocketConnection.this.listener);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.SEVERE, "Exception in message listener", e);
                    }
                } while (!messageItem.isEos());
                if (SocketConnection.this.connectionLogger != null) {
                    SocketConnection.this.connectionLogger.handleEos();
                }
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private class WriterThread
    extends InterruptibleThread {
        private final SocketWrapper.LoggableOutputStream writer;

        public WriterThread(SocketWrapper.LoggableOutputStream writer) {
            super("WriterThread");
            this.writer = writer;
        }

        @Override
        public void run() {
            while (!this.isTerminated && SocketConnection.this.isAttached.get()) {
                try {
                    this.handleOutboundMessage((Message)SocketConnection.this.outboundQueue.take());
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        private void handleOutboundMessage(Message message) {
            try {
                LOGGER.log(Level.FINER, "-->{0}", message);
                message.sendThrough(this.writer.getOutputStream(), SOCKET_CHARSET);
                this.writer.getOutputStream().flush();
                this.writer.markSeparatorForLog();
            }
            catch (IOException e) {
                SocketConnection.this.shutdownRelay.sendSignal(false, e);
            }
        }
    }
}

