/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.ids;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.ids.AbstractSingletonScope;
import org.eclipse.ocl.pivot.ids.BindingsId;
import org.eclipse.ocl.pivot.ids.ElementId;
import org.eclipse.ocl.pivot.ids.EnumerationLiteralId;
import org.eclipse.ocl.pivot.ids.IdManager;
import org.eclipse.ocl.pivot.ids.OperationId;
import org.eclipse.ocl.pivot.ids.ParametersId;
import org.eclipse.ocl.pivot.ids.PropertyId;
import org.eclipse.ocl.pivot.ids.SingletonScope;
import org.eclipse.ocl.pivot.ids.SpecializedId;
import org.eclipse.ocl.pivot.ids.TemplateParameterId;
import org.eclipse.ocl.pivot.ids.TemplateableId;
import org.eclipse.ocl.pivot.internal.ids.AbstractElementId;

public abstract class AbstractTemplateableIdImpl<@NonNull T extends TemplateableId>
extends AbstractElementId
implements TemplateableId {
    protected final @NonNull Integer hashCode;
    private @Nullable SpecializedSingletonScope<T> specializations = null;
    protected final int templateParameters;

    protected AbstractTemplateableIdImpl(@NonNull Integer hashCode, int templateParameters) {
        this.hashCode = hashCode;
        this.templateParameters = templateParameters;
    }

    protected abstract @NonNull T createSpecializedId(@NonNull BindingsId var1);

    public @NonNull EnumerationLiteralId getEnumerationLiteralId(@NonNull String name) {
        throw new UnsupportedOperationException();
    }

    public @NonNull OperationId getOperationId(int templateParameters, @NonNull String name, @NonNull ParametersId parametersId) {
        throw new UnsupportedOperationException();
    }

    public @NonNull PropertyId getPropertyId(@NonNull String name) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull T getSpecializedId(@NonNull BindingsId templateBindings) {
        SpecializedSingletonScope<T> specializations2 = this.specializations;
        if (specializations2 == null) {
            AbstractTemplateableIdImpl abstractTemplateableIdImpl = this;
            synchronized (abstractTemplateableIdImpl) {
                specializations2 = this.specializations;
                if (specializations2 == null) {
                    specializations2 = new SpecializedSingletonScope();
                    this.specializations = specializations2;
                }
            }
        }
        return specializations2.getSingleton(this, templateBindings);
    }

    public @NonNull T getSpecializedId(ElementId ... templateBindings) {
        assert (templateBindings.length == this.templateParameters);
        return this.getSpecializedId(IdManager.getBindingsId(templateBindings));
    }

    @Deprecated
    public @NonNull TemplateParameterId getTemplateParameterId(int index) {
        return IdManager.getTemplateParameterId(index);
    }

    @Override
    public int getTemplateParameters() {
        return this.templateParameters;
    }

    @Override
    public final int hashCode() {
        return this.hashCode;
    }

    public static class SpecializedSingletonScope<@NonNull T extends TemplateableId>
    extends AbstractSingletonScope<T, BindingsId> {
        public @NonNull T getSingleton(@NonNull AbstractTemplateableIdImpl<T> generalizedId, @NonNull BindingsId bindingsId) {
            return (T)((TemplateableId)this.getSingletonFor(new SpecializedValue(generalizedId, bindingsId)));
        }
    }

    private static class SpecializedValue<@NonNull T extends TemplateableId>
    extends SingletonScope.AbstractKeyAndValue<T> {
        private final @NonNull AbstractTemplateableIdImpl<T> generalizedId;
        private final @NonNull BindingsId value;

        private SpecializedValue(@NonNull AbstractTemplateableIdImpl<T> generalizedId, @NonNull BindingsId value) {
            super(generalizedId.hashCode() + value.hashCode());
            this.generalizedId = generalizedId;
            this.value = value;
        }

        @Override
        public @NonNull T createSingleton() {
            return this.generalizedId.createSpecializedId(this.value);
        }

        @Override
        public boolean equals(@Nullable Object that) {
            if (that instanceof SpecializedId) {
                SpecializedId singleton = (SpecializedId)that;
                return singleton.getTemplateBindings().equals(this.value);
            }
            return false;
        }
    }
}

