/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.eventmanager.framework;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.ocl.examples.eventmanager.EventFilter;
import org.eclipse.ocl.examples.eventmanager.EventManager;
import org.eclipse.ocl.examples.eventmanager.EventManagerFactory;
import org.eclipse.ocl.examples.eventmanager.NotificationHelper;
import org.eclipse.ocl.examples.eventmanager.filters.AndFilter;
import org.eclipse.ocl.examples.eventmanager.filters.ClassFilter;
import org.eclipse.ocl.examples.eventmanager.filters.ClassFilterIncludingSubclasses;
import org.eclipse.ocl.examples.eventmanager.filters.ContainmentFilter;
import org.eclipse.ocl.examples.eventmanager.filters.EventTypeFilter;
import org.eclipse.ocl.examples.eventmanager.filters.NewValueClassFilter;
import org.eclipse.ocl.examples.eventmanager.filters.NewValueClassFilterIncludingSubclasses;
import org.eclipse.ocl.examples.eventmanager.filters.NotFilter;
import org.eclipse.ocl.examples.eventmanager.filters.OldValueClassFilter;
import org.eclipse.ocl.examples.eventmanager.filters.OldValueClassFilterIncludingSubclasses;
import org.eclipse.ocl.examples.eventmanager.filters.OrFilter;
import org.eclipse.ocl.examples.eventmanager.filters.StructuralFeatureFilter;
import org.eclipse.ocl.examples.eventmanager.framework.EventManagerTableBased;
import org.eclipse.ocl.examples.eventmanager.framework.LogicalOperationFilterImpl;
import org.eclipse.ocl.examples.eventmanager.util.Statistics;

public class EventManagerFactoryImpl
implements EventManagerFactory {
    private final WeakHashMap<ResourceSet, EventManager> setToManager = new WeakHashMap();

    public static EventManagerFactory init() {
        return new EventManagerFactoryImpl();
    }

    @Override
    public EventManager getEventManagerFor(ResourceSet set) {
        EventManager cached;
        EventManager eventManager = cached = this.setToManager.get(set) == null ? null : this.setToManager.get(set);
        if (cached != null) {
            return cached;
        }
        if (set != null) {
            EventManagerTableBased eventManager2 = new EventManagerTableBased(set);
            this.setToManager.put(set, eventManager2);
            return eventManager2;
        }
        return null;
    }

    @Override
    public EventManager createEventManager() {
        EventManagerTableBased eventManager = new EventManagerTableBased();
        return eventManager;
    }

    @Override
    public EventManager createEventManagerFor(ResourceSet set) {
        EventManagerTableBased eventManager = new EventManagerTableBased(set);
        return eventManager;
    }

    @Override
    public EventTypeFilter createEventTypeFilter(int eventType) {
        EventTypeFilter eventTypeFilter = new EventTypeFilter(eventType, false);
        return eventTypeFilter;
    }

    @Override
    public NotFilter createNotFilter(EventFilter filter) {
        NotFilter notFilter = new NotFilter(filter);
        return notFilter;
    }

    @Override
    public ClassFilter createClassFilter(EClass clazz) {
        ClassFilter classFilter = new ClassFilter(clazz, false);
        return classFilter;
    }

    @Override
    public ClassFilterIncludingSubclasses createClassFilterIncludingSubclasses(EClass clazz) {
        ClassFilterIncludingSubclasses classFilter = new ClassFilterIncludingSubclasses(clazz, false);
        return classFilter;
    }

    @Override
    public StructuralFeatureFilter createStructuralFeatureFilter(EStructuralFeature property) {
        StructuralFeatureFilter structuralFeatureFilter = new StructuralFeatureFilter(property, false);
        return structuralFeatureFilter;
    }

    @Override
    public OldValueClassFilterIncludingSubclasses createOldValueClassFilterIncludingSubclasses(EClass cls) {
        OldValueClassFilterIncludingSubclasses oldValueClassFilter = new OldValueClassFilterIncludingSubclasses(cls, false);
        return oldValueClassFilter;
    }

    @Override
    public OldValueClassFilter createOldValueClassFilter(EClass cls) {
        OldValueClassFilter oldValueClassFilter = new OldValueClassFilter(cls, false);
        return oldValueClassFilter;
    }

    @Override
    public NewValueClassFilterIncludingSubclasses createNewValueClassFilterIncludingSubclasses(EClass cls) {
        NewValueClassFilterIncludingSubclasses newValueClassFilter = new NewValueClassFilterIncludingSubclasses(cls, false);
        return newValueClassFilter;
    }

    @Override
    public NewValueClassFilter createNewValueClassFilter(EClass cls) {
        NewValueClassFilter newValueClassFilter = new NewValueClassFilter(cls, false);
        return newValueClassFilter;
    }

    @Override
    public ContainmentFilter createContainmentFilter() {
        ContainmentFilter containmentFilter = new ContainmentFilter(false);
        return containmentFilter;
    }

    @Override
    public AndFilter createAndFilterFor(EventFilter ... eventFilters) {
        AndFilter and = new AndFilter(eventFilters);
        return and;
    }

    @Override
    public OrFilter createOrFilterFor(EventFilter ... eventFilters) {
        OrFilter or = new OrFilter(eventFilters);
        return or;
    }

    @Override
    public EventFilter createFilterForElementInsertionOrDeletion(EClass cls) {
        NewValueClassFilterIncludingSubclasses nv = this.createNewValueClassFilterIncludingSubclasses(cls);
        OldValueClassFilterIncludingSubclasses ov = this.createOldValueClassFilterIncludingSubclasses(cls);
        return this.createAndFilterFor(this.createOrFilterFor(nv, ov), this.createContainmentFilter());
    }

    @Override
    public EventFilter createFilterForElementInsertion(EClass cls) {
        NewValueClassFilterIncludingSubclasses nv = this.createNewValueClassFilterIncludingSubclasses(cls);
        return this.createAndFilterFor(this.createOrFilterForEventTypes(3, 1, 5), nv, this.createContainmentFilter());
    }

    private LogicalOperationFilterImpl createOrFilterForEventTypes(int ... types) {
        OrFilter or = new OrFilter();
        int[] nArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            int t = nArray[n2];
            EventTypeFilter e1 = this.createEventTypeFilter(t);
            or.addOperand(e1);
            ++n2;
        }
        return or;
    }

    @Override
    public EventFilter createFilterForEAttribute(EClass eClass, EAttribute referredProperty) {
        StructuralFeatureFilter sf = null;
        sf = this.createStructuralFeatureFilter((EStructuralFeature)referredProperty);
        ClassFilterIncludingSubclasses cf = this.createClassFilterIncludingSubclasses(eClass);
        return this.createAndFilterFor(sf, cf);
    }

    @Override
    public EventFilter createFilterForEReference(EClass eClass, EReference referredProperty) {
        StructuralFeatureFilter sf = null;
        sf = this.createStructuralFeatureFilter((EStructuralFeature)referredProperty);
        ClassFilterIncludingSubclasses cf = this.createClassFilterIncludingSubclasses(eClass);
        return this.createAndFilterFor(sf, cf);
    }

    @Override
    public Collection<Notification> createNotificationForComposites(Notification event) {
        Statistics.getInstance().begin("createNotificationForComposites", event);
        HashSet<Notification> result = new HashSet<Notification>();
        Object f = event.getFeature();
        if (f != null && f instanceof EReference && ((EReference)f).isContainment()) {
            this.handleValues(event, result);
        } else if (f == null && event.getNotifier() instanceof Resource) {
            this.handleValues(event, result);
        }
        result.add(event);
        Statistics.getInstance().end("createNotificationForComposites", event);
        return result;
    }

    private void handleValues(Notification event, Set<Notification> result) {
        Object value;
        Object object = value = NotificationHelper.isAddEvent(event) ? event.getNewValue() : event.getOldValue();
        if (NotificationHelper.isManyEvent(event)) {
            assert (value instanceof Collection);
            Collection valueCol = (Collection)value;
            for (Object o : valueCol) {
                if (!(o instanceof EObject)) continue;
                this.addNotification((EObject)o, NotificationHelper.isAddEvent(event), result);
            }
        } else if (value instanceof EObject) {
            this.addNotification((EObject)value, NotificationHelper.isAddEvent(event), result);
        }
    }

    private void addNotification(EObject value, boolean add, Set<Notification> result) {
        for (EStructuralFeature ref : value.eClass().getEAllStructuralFeatures()) {
            EventManagerGeneratedNotification notification = null;
            try {
                Object valueOfRef = value.eGet(ref, false);
                if (valueOfRef == null || valueOfRef instanceof EObject && ((EObject)valueOfRef).eIsProxy()) continue;
                if (ref.isMany()) {
                    EList values = (EList)valueOfRef;
                    switch (values.size()) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            notification = new EventManagerGeneratedNotification(add ? 3 : 4, add ? null : values.get(0), !add ? null : values.get(0), (Notifier)value, ref);
                            break;
                        }
                        default: {
                            notification = new EventManagerGeneratedNotification(add ? 5 : 6, add ? null : values, !add ? null : values, (Notifier)value, ref);
                            break;
                        }
                    }
                } else {
                    notification = new EventManagerGeneratedNotification(1, add ? null : valueOfRef, !add ? null : valueOfRef, (Notifier)value, ref);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (notification == null) continue;
            if (ref instanceof EReference && ((EReference)ref).isContainment()) {
                this.handleValues((Notification)notification, result);
            }
            result.add((Notification)notification);
        }
    }

    @Override
    public void dispose() {
        this.setToManager.size();
    }

    private static class EventManagerGeneratedNotification
    extends NotificationImpl {
        private Object feature;
        private Notifier notifier;

        public Object getFeature() {
            return this.feature;
        }

        public Notifier getNotifier() {
            return this.notifier;
        }

        public EventManagerGeneratedNotification(int eventType, Object oldValue, Object newValue, Notifier noti, Object feature) {
            super(eventType, oldValue, newValue);
            this.feature = feature;
            this.notifier = noti;
        }
    }
}

