/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.concurrent;

public final class ConcurrentValue<T> {
    private Object notifier = new Notifier();
    private T value;

    public ConcurrentValue(T value) {
        this.value = value;
    }

    public T get() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(T newValue) {
        Object object = this.notifier;
        synchronized (object) {
            this.value = newValue;
            this.notifier.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reevaluate() {
        Object object = this.notifier;
        synchronized (object) {
            this.notifier.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire(Object accept) throws InterruptedException {
        if (accept == null) {
            throw new IllegalArgumentException("accept == null");
        }
        Object object = this.notifier;
        synchronized (object) {
            while (!accept.equals(this.value)) {
                this.notifier.wait();
            }
        }
    }

    private static final class Notifier {
        private Notifier() {
        }
    }
}

