/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.markdown.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.markdown.internal.LinkDefinition;

public class LinkDefinitionParser {
    private static final String ID_REGEX = " {0,3}(\\[([^]]+?)\\]\\:)";
    private static final String URL_REGEX = "\\s+(?=[<]?(([^>\\s]+)))(?:<\\3>|\\3)";
    private static final String TITLE_REGEX = "(?:\\s+[\"'\\(](.*?)[\"'\\)])?";
    public static final Pattern LINK_DEFINITION_PATTERN = Pattern.compile(" {0,3}(\\[([^]]+?)\\]\\:)\\s+(?=[<]?(([^>\\s]+)))(?:<\\3>|\\3)(?:\\s+[\"'\\(](.*?)[\"'\\)])?");
    private Map<String, LinkDefinition> linkDefinitions;

    public void parse(String markupContent) {
        this.linkDefinitions = new HashMap<String, LinkDefinition>();
        Matcher matcher = LINK_DEFINITION_PATTERN.matcher(markupContent);
        while (matcher.find()) {
            String id = matcher.group(2);
            String url = matcher.group(3);
            String title = matcher.group(5);
            int offset = matcher.start(1);
            int length = matcher.end() - offset;
            this.linkDefinitions.put(id.toLowerCase(), new LinkDefinition(id, url, title, offset, length));
        }
    }

    public LinkDefinition getLinkDefinition(String id) {
        return this.linkDefinitions.get(id.toLowerCase());
    }

    public Map<String, LinkDefinition> getLinkDefinitions() {
        return this.linkDefinitions;
    }
}

