/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal.browser;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.query.registry.QueryDescriptor;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.extension.Subject;
import org.eclipse.mat.snapshot.extension.Subjects;
import org.eclipse.mat.ui.internal.browser.QueryBrowserPopup;

public abstract class QueryBrowserProvider {
    protected QueryBrowserPopup.Element[] sortedElements;

    public abstract String getName();

    public abstract QueryBrowserPopup.Element[] getElements();

    public QueryBrowserPopup.Element[] getElementsSorted() {
        if (this.sortedElements == null) {
            this.sortedElements = this.getElements();
            Arrays.sort(this.sortedElements, new Comparator<QueryBrowserPopup.Element>(){

                @Override
                public int compare(QueryBrowserPopup.Element o1, QueryBrowserPopup.Element o2) {
                    return o1.getLabel().compareTo(o2.getLabel());
                }
            });
        }
        return this.sortedElements;
    }

    public static boolean unsuitableSubjects(QueryDescriptor query, IQueryContext queryContext) {
        boolean skip;
        String[] cls = QueryBrowserProvider.extractSubjects(query);
        if (cls != null) {
            ISnapshot snapshot = (ISnapshot)queryContext.get(ISnapshot.class, null);
            int count = 0;
            String[] stringArray = cls;
            int n = cls.length;
            int n2 = 0;
            while (n2 < n) {
                String cn = stringArray[n2];
                try {
                    Collection ss = snapshot.getClassesByName(cn, false);
                    if (ss != null && !ss.isEmpty()) {
                        count += ss.size();
                        break;
                    }
                }
                catch (SnapshotException snapshotException) {
                    // empty catch block
                }
                ++n2;
            }
            skip = count == 0;
        } else {
            skip = false;
        }
        return skip;
    }

    private static String[] extractSubjects(QueryDescriptor query) {
        Subject s;
        Subjects subjects = query.getCommandType().getAnnotation(Subjects.class);
        Object cls = subjects != null ? subjects.value() : ((s = query.getCommandType().getAnnotation(Subject.class)) != null ? new String[]{s.value()} : null);
        return cls;
    }
}

