/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.osgi.model.eclipse;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.mat.inspections.osgi.model.BundleDescriptor;
import org.eclipse.mat.inspections.osgi.model.eclipse.ConfigurationElement;

public class Extension {
    private int objectId;
    private String[] properties;
    private BundleDescriptor contributedBy;
    private Integer extensionId;
    private List<ConfigurationElement> configurationElements = new ArrayList<ConfigurationElement>();
    private static final byte LABEL = 0;
    private static final byte XPT_NAME = 1;
    private static final byte CONTRIBUTOR_ID = 2;

    public Extension(int objectId, Integer extensionId, String[] properties) {
        this.objectId = objectId;
        this.extensionId = extensionId;
        this.properties = (String[])properties.clone();
    }

    public int getObjectId() {
        return this.objectId;
    }

    public Integer getExtensionId() {
        return this.extensionId;
    }

    public String getName() {
        return this.properties[1];
    }

    public String getLabel() {
        return this.properties[0];
    }

    public String getContributorId() {
        return this.properties[2];
    }

    public void setContributedBy(BundleDescriptor contributedBy) {
        this.contributedBy = contributedBy;
    }

    public BundleDescriptor getContributedBy() {
        return this.contributedBy;
    }

    public List<ConfigurationElement> getConfigurationElements() {
        return this.configurationElements;
    }

    public void addConfigurationElement(ConfigurationElement configurationElement) {
        if (!this.configurationElements.contains(configurationElement)) {
            this.configurationElements.add(configurationElement);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.contributedBy == null ? 0 : this.contributedBy.hashCode());
        result = 31 * result + (this.extensionId == null ? 0 : this.extensionId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Extension other = (Extension)obj;
        if (this.contributedBy == null ? other.contributedBy != null : !this.contributedBy.equals(other.contributedBy)) {
            return false;
        }
        return !(this.extensionId == null ? other.extensionId != null : !this.extensionId.equals(other.extensionId));
    }
}

