/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis.consumption.ui.util;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;

public class PlatformUtils {
    public static final String PLATFORM_ROOT = "platform:/resource";
    public static final String WIN_FILE_PROTOCOL = "file:/";
    public static final String LNX_FILE_PROTOCOL = "file://";
    public static final String PLATFORM = "platform";
    public static final String RESOURCE = "/resource";

    private PlatformUtils() {
    }

    public static String getPlatformURL(IPath path) {
        String platformURL = URI.createPlatformResourceURI((String)path.toString()).toString();
        return platformURL;
    }

    public static URL getCommandPlatformURL(IPath path) {
        URL url = null;
        try {
            url = new URL(PLATFORM, null, RESOURCE + path.toString());
        }
        catch (MalformedURLException malformedURLException) {
            return url;
        }
        return url;
    }

    public static String getPathFromPlatform(String platformStr) {
        String pathStr = platformStr;
        String rootLocation = PLATFORM_ROOT;
        if (platformStr.startsWith(rootLocation)) {
            pathStr = platformStr.substring(rootLocation.length());
        }
        return pathStr;
    }

    public static String getPlatformFromPath(String pathStr) {
        String platformStr = pathStr;
        String rootLocation = PLATFORM_ROOT;
        platformStr = String.valueOf(rootLocation) + pathStr;
        return platformStr;
    }

    public static String getFileFromPlatform(String platformStr) {
        String fileStr = platformStr;
        String pathStr = PlatformUtils.getPathFromPlatform(platformStr);
        fileStr = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(pathStr)).getLocation().toString();
        return fileStr;
    }

    public static String getFileURLFromPlatform(String platformStr) {
        String fileStr = platformStr;
        String pathStr = PlatformUtils.getPathFromPlatform(platformStr);
        try {
            fileStr = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(pathStr)).getLocation().toFile().toURL().toString();
        }
        catch (MalformedURLException malformedURLException) {
            fileStr = PlatformUtils.getFileURLFromPath((IPath)new Path(pathStr));
        }
        return fileStr;
    }

    public static String getFileURLFromPath(IPath path) {
        String file = null;
        if (path != null) {
            file = !path.isAbsolute() ? ((file = ResourcesPlugin.getWorkspace().getRoot().getFile(path).getLocation().toString()).charAt(0) == '/' ? LNX_FILE_PROTOCOL + file : WIN_FILE_PROTOCOL + file) : path.toString();
            file = file != null && file.charAt(0) == '/' ? LNX_FILE_PROTOCOL + file : WIN_FILE_PROTOCOL + file;
        }
        return file == null ? null : file;
    }
}

