/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.ui.provider;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

class ImageDataSynthesizer {
    protected URL url;
    protected static final int tableOffset1 = 49;
    protected static final int tableOffset2 = 25;

    public ImageDataSynthesizer(URL url) {
        this.url = url;
    }

    protected int code(String code) {
        int result = 0;
        int i = 0;
        while (i < code.length()) {
            result += code.charAt(i) - 32;
            ++i;
        }
        return result;
    }

    public InputStream generateGIF(String key1, String key2) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            byte[] content = new byte[5000];
            int result = this.getContents(content, this.url);
            ColorInformation info1 = ColorInformation.getColor(this.code(key1));
            ColorInformation info2 = key2 == null ? null : ColorInformation.getColor(this.code(key2));
            int j = 0;
            while (j < result) {
                int index;
                if (j == 49 || j == 52 || j == 55 || j == 58) {
                    index = (j - 49) / 3;
                    if (!info1.rainbow || info1.which == index - 1) {
                        content[j] = info1.scale(info1.red, info1.factor[index]);
                    }
                } else if (j == 50 || j == 53 || j == 56 || j == 59) {
                    index = (j - 49 - 1) / 3;
                    if (!info1.rainbow || info1.which == index - 1) {
                        content[j] = info1.scale(info1.green, info1.factor[index]);
                    }
                } else if (j == 51 || j == 54 || j == 57 || j == 60) {
                    index = (j - 49 - 2) / 3;
                    if (!info1.rainbow || info1.which == index - 1) {
                        content[j] = info1.scale(info1.blue, info1.factor[index]);
                    }
                }
                if (info2 != null) {
                    if (j == 25 || j == 28 || j == 31 || j == 34) {
                        index = (j - 25) / 3;
                        if (!info2.rainbow || info2.which == index - 1) {
                            content[j] = info2.scale(info2.red, info2.factor[index]);
                        }
                    } else if (j == 26 || j == 29 || j == 32 || j == 35) {
                        index = (j - 25 - 1) / 3;
                        if (!info2.rainbow || info2.which == index - 1) {
                            content[j] = info2.scale(info2.green, info2.factor[index]);
                        }
                    } else if (j == 27 || j == 30 || j == 33 || j == 36) {
                        index = (j - 25 - 2) / 3;
                        if (!info2.rainbow || info2.which == index - 1) {
                            content[j] = info2.scale(info2.blue, info2.factor[index]);
                        }
                    }
                }
                ++j;
            }
            DataOutputStream writer = new DataOutputStream(outputStream);
            writer.write(content, 0, result);
            writer.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return new ByteArrayInputStream(outputStream.toByteArray());
    }

    protected int getContents(byte[] content, URL gifURL) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(gifURL.openStream());
        DataInputStream reader = new DataInputStream(bufferedInputStream);
        int result = reader.read(content, 0, content.length);
        reader.close();
        return result;
    }

    protected static class ColorInformation {
        protected static ColorInformation instance = new ColorInformation();
        protected static List<ColorInformation> entries = new ArrayList<ColorInformation>(1000);
        public int red = 192;
        public int green = 64;
        public int blue = 64;
        public int which = 2;
        public int change = 64;
        public double[] factor = new double[]{0.35, 0.1, -0.1, -0.3};
        public boolean rainbow;

        protected ColorInformation() {
        }

        public static ColorInformation getColor(int index) {
            index = Math.abs(index) % 61;
            while (entries.size() <= index) {
                instance.generateColor();
                ColorInformation entry = new ColorInformation();
                entry.red = ColorInformation.instance.red;
                entry.green = ColorInformation.instance.green;
                entry.blue = ColorInformation.instance.blue;
                entry.which = ColorInformation.instance.which;
                entry.factor = new double[]{ColorInformation.instance.factor[0], ColorInformation.instance.factor[1], ColorInformation.instance.factor[2], ColorInformation.instance.factor[3]};
                entry.rainbow = ColorInformation.instance.rainbow;
                entries.add(entry);
                instance.fixFactor();
            }
            return entries.get(index);
        }

        public byte scale(int value, double factor) {
            if (factor > 0.0) {
                return (byte)((double)value + (double)(255 - value) * factor);
            }
            return (byte)((double)value + (double)value * factor);
        }

        protected void generateColor() {
            switch (this.which) {
                case 0: {
                    this.red += this.change;
                    if (this.red <= 64) {
                        this.which = 1;
                        this.change = -this.change;
                        break;
                    }
                    if (this.red < 192) break;
                    this.which = 1;
                    this.change = -this.change;
                    break;
                }
                case 1: {
                    this.green += this.change;
                    if (this.green >= 192) {
                        this.which = 2;
                        this.change = -this.change;
                        break;
                    }
                    if (this.green > 64) break;
                    this.which = 2;
                    this.change = -this.change;
                    break;
                }
                case 2: {
                    this.blue += this.change;
                    if (this.blue >= 192) {
                        this.which = 0;
                        this.change = -this.change;
                        break;
                    }
                    if (this.blue > 64) break;
                    this.which = 0;
                    this.change = -this.change;
                }
            }
        }

        protected void fixFactor() {
            if (this.red == 192 && this.green == 64 && this.blue == 64) {
                int j = 0;
                while (j < this.factor.length) {
                    int n = j++;
                    this.factor[n] = this.factor[n] + 0.3;
                }
                if (this.factor[0] >= 1.0) {
                    this.rainbow = true;
                    j = 0;
                    while (j < this.factor.length) {
                        int n = j++;
                        this.factor[n] = this.factor[n] - 0.8;
                    }
                }
            }
        }
    }
}

