/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xcore.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.emf.codegen.ecore.genmodel.GenClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xcore.XAnnotation;
import org.eclipse.emf.ecore.xcore.XGenericType;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmEnumerationType;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XTypeLiteral;

public final class XcoreUtil {
    public static Iterable<INode> importableCrossReferences(EObject eObject) {
        return new XcoreCrossReferencer(eObject);
    }

    private XcoreUtil() {
    }

    private static class XcoreCrossReferencer
    implements Iterator<INode>,
    Iterable<INode> {
        private Iterator<INode> nodes;
        private INode node;

        public XcoreCrossReferencer(EObject eObject) {
            this.nodes = NodeModelUtils.findActualNodeFor((EObject)eObject).getAsTreeIterable().iterator();
            this.scan();
        }

        @Override
        public Iterator<INode> iterator() {
            return this;
        }

        private void scan() {
            this.node = null;
            while (this.nodes.hasNext()) {
                INode nextNode = this.nodes.next();
                EObject grammarElement = nextNode.getGrammarElement();
                if (!(grammarElement instanceof CrossReference)) continue;
                EObject semanticElement = nextNode.getSemanticElement();
                if (semanticElement instanceof JvmTypeReference) {
                    JvmType jvmType = ((JvmTypeReference)semanticElement).getType();
                    if (!(jvmType instanceof JvmGenericType) && !(jvmType instanceof JvmEnumerationType) && !(jvmType instanceof JvmAnnotationType)) continue;
                    this.node = nextNode;
                    break;
                }
                if (!(semanticElement instanceof XGenericType && ((XGenericType)semanticElement).getType() instanceof GenClassifier || semanticElement instanceof XAnnotation && ((XAnnotation)semanticElement).getSource() != null || semanticElement instanceof XConstructorCall || semanticElement instanceof XFeatureCall && ((XFeatureCall)semanticElement).isTypeLiteral()) && !(semanticElement instanceof XTypeLiteral)) continue;
                this.node = nextNode;
                break;
            }
        }

        @Override
        public boolean hasNext() {
            return this.node != null;
        }

        @Override
        public INode next() {
            if (this.node == null) {
                throw new NoSuchElementException();
            }
            INode result = this.node;
            this.scan();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

