/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.session.remote;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.eclipse.emf.cdo.session.remote.CDORemoteSession;
import org.eclipse.emf.cdo.session.remote.CDORemoteSessionEvent;
import org.eclipse.emf.cdo.session.remote.CDORemoteSessionManager;
import org.eclipse.emf.cdo.session.remote.CDORemoteSessionMessage;
import org.eclipse.emf.internal.cdo.session.remote.CDORemoteSessionImpl;
import org.eclipse.emf.internal.cdo.session.remote.CDORemoteTopicImpl;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.emf.spi.cdo.InternalCDORemoteSession;
import org.eclipse.emf.spi.cdo.InternalCDORemoteSessionManager;
import org.eclipse.emf.spi.cdo.InternalCDORemoteTopic;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.net4j.util.collection.ArrayIterator;
import org.eclipse.net4j.util.container.Container;
import org.eclipse.net4j.util.container.ContainerEvent;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IContainerDelta;
import org.eclipse.net4j.util.event.Event;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;

public class CDORemoteSessionManagerImpl
extends Container<CDORemoteSession>
implements InternalCDORemoteSessionManager {
    private static final InternalCDORemoteSession[] NO_REMOTE_SESSIONS = new InternalCDORemoteSession[0];
    private InternalCDOSession localSession;
    private boolean forceSubscription;
    private boolean subscribed;
    private final Map<Integer, InternalCDORemoteSession> remoteSessions = new HashMap<Integer, InternalCDORemoteSession>();
    private final Map<String, InternalCDORemoteTopic> remoteTopics = new HashMap<String, InternalCDORemoteTopic>();

    public ExecutorService getExecutorService() {
        return this.localSession == null ? null : this.localSession.getExecutorService();
    }

    @Override
    public InternalCDOSession getLocalSession() {
        return this.localSession;
    }

    @Override
    public void setLocalSession(InternalCDOSession localSession) {
        this.localSession = localSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalCDORemoteSession[] getRemoteSessions() {
        CDORemoteSessionManagerImpl cDORemoteSessionManagerImpl = this;
        synchronized (cDORemoteSessionManagerImpl) {
            if (this.localSession.isActive()) {
                if (this.subscribed) {
                    Collection<InternalCDORemoteSession> values = this.remoteSessions.values();
                    return values.toArray(new InternalCDORemoteSession[values.size()]);
                }
                List<CDORemoteSession> loadedRemoteSessions = this.localSession.getSessionProtocol().getRemoteSessions(this, false);
                return loadedRemoteSessions.toArray(new InternalCDORemoteSession[loadedRemoteSessions.size()]);
            }
            return NO_REMOTE_SESSIONS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalCDORemoteSession[] getRemoteSessions(String userID) {
        ArrayList<InternalCDORemoteSession> result = new ArrayList<InternalCDORemoteSession>();
        CDORemoteSessionManagerImpl cDORemoteSessionManagerImpl = this;
        synchronized (cDORemoteSessionManagerImpl) {
            InternalCDORemoteSession[] internalCDORemoteSessionArray = this.getRemoteSessions();
            int n = internalCDORemoteSessionArray.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDORemoteSession remoteSession = internalCDORemoteSessionArray[n2];
                if (Objects.equals(remoteSession.getUserID(), userID)) {
                    result.add(remoteSession);
                }
                ++n2;
            }
        }
        return result.toArray(new InternalCDORemoteSession[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalCDORemoteSession getRemoteSession(int sessionID) {
        CDORemoteSessionManagerImpl cDORemoteSessionManagerImpl = this;
        synchronized (cDORemoteSessionManagerImpl) {
            return this.remoteSessions.get(sessionID);
        }
    }

    public CDORemoteSession[] getElements() {
        return this.getRemoteSessions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSubscribed() {
        CDORemoteSessionManagerImpl cDORemoteSessionManagerImpl = this;
        synchronized (cDORemoteSessionManagerImpl) {
            return this.subscribed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isForceSubscription() {
        CDORemoteSessionManagerImpl cDORemoteSessionManagerImpl = this;
        synchronized (cDORemoteSessionManagerImpl) {
            return this.forceSubscription;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setForceSubscription(boolean forceSubscription) {
        IEvent[] events = null;
        CDORemoteSessionManagerImpl cDORemoteSessionManagerImpl = this;
        synchronized (cDORemoteSessionManagerImpl) {
            this.forceSubscription = forceSubscription;
            if (forceSubscription) {
                if (!this.subscribed) {
                    events = this.subscribe();
                }
            } else if (!this.hasListeners() && this.remoteTopics.isEmpty()) {
                events = this.unsubscribe();
            }
        }
        this.fireEvents(events);
    }

    @Override
    public Set<CDORemoteSession> sendMessage(CDORemoteSessionMessage message, CDORemoteSession ... recipients) {
        return this.sendMessage(message, (Iterator<CDORemoteSession>)new ArrayIterator((Object[])recipients));
    }

    @Override
    public Set<CDORemoteSession> sendMessage(CDORemoteSessionMessage message, Collection<CDORemoteSession> recipients) {
        return this.sendMessage(message, recipients.iterator());
    }

    private Set<CDORemoteSession> sendMessage(CDORemoteSessionMessage message, Iterator<CDORemoteSession> recipients) {
        ArrayList<CDORemoteSession> subscribedSessions = new ArrayList<CDORemoteSession>();
        while (recipients.hasNext()) {
            CDORemoteSession recipient = recipients.next();
            if (!recipient.isSubscribed()) continue;
            subscribedSessions.add(recipient);
        }
        if (subscribedSessions.isEmpty()) {
            return Collections.emptySet();
        }
        Set<Integer> sessionIDs = this.localSession.getSessionProtocol().sendRemoteMessage(message, null, subscribedSessions);
        HashSet<CDORemoteSession> result = new HashSet<CDORemoteSession>();
        for (CDORemoteSession recipient : subscribedSessions) {
            if (!sessionIDs.contains(recipient.getSessionID())) continue;
            result.add(recipient);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalCDORemoteTopic subscribeTopic(String id) {
        InternalCDORemoteTopic remoteTopic;
        IEvent[] events = null;
        CDORemoteSessionManagerImpl cDORemoteSessionManagerImpl = this;
        synchronized (cDORemoteSessionManagerImpl) {
            remoteTopic = this.remoteTopics.get(id);
            if (remoteTopic == null) {
                if (!this.subscribed) {
                    events = this.subscribe();
                }
                CDOSessionProtocol sessionProtocol = this.localSession.getSessionProtocol();
                Set<Integer> remoteSessionIDs = sessionProtocol.subscribeRemoteTopic(id, true);
                remoteTopic = new CDORemoteTopicImpl(this, id, remoteSessionIDs);
                LifecycleUtil.activate((Object)remoteTopic);
                this.remoteTopics.put(id, remoteTopic);
            }
        }
        this.fireEvents(events);
        return remoteTopic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unsubscribeTopic(InternalCDORemoteTopic remoteTopic) {
        String id = remoteTopic.getID();
        IEvent[] events = null;
        CDORemoteSessionManagerImpl cDORemoteSessionManagerImpl = this;
        synchronized (cDORemoteSessionManagerImpl) {
            if (this.remoteTopics.remove(id) != null) {
                this.localSession.getSessionProtocol().subscribeRemoteTopic(id, false);
                if (!this.forceSubscription && this.remoteTopics.isEmpty() && !this.hasListeners()) {
                    events = this.unsubscribe();
                }
                LifecycleUtil.deactivate((Object)remoteTopic);
            }
        }
        this.fireEvents(events);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalCDORemoteTopic[] getSubscribedTopics() {
        CDORemoteSessionManagerImpl cDORemoteSessionManagerImpl = this;
        synchronized (cDORemoteSessionManagerImpl) {
            return this.remoteTopics.values().toArray(new InternalCDORemoteTopic[this.remoteTopics.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalCDORemoteTopic getSubscribedTopic(String id) {
        CDORemoteSessionManagerImpl cDORemoteSessionManagerImpl = this;
        synchronized (cDORemoteSessionManagerImpl) {
            return this.remoteTopics.get(id);
        }
    }

    @Override
    public InternalCDORemoteSession createRemoteSession(int sessionID, String userID, boolean subscribed) {
        CDORemoteSessionImpl remoteSession = new CDORemoteSessionImpl(this, sessionID, userID);
        remoteSession.setSubscribed(subscribed);
        return remoteSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRemoteSessionOpened(int sessionID, String userID) {
        InternalCDORemoteSession remoteSession = this.createRemoteSession(sessionID, userID, false);
        CDORemoteSessionManagerImpl cDORemoteSessionManagerImpl = this;
        synchronized (cDORemoteSessionManagerImpl) {
            this.remoteSessions.put(sessionID, remoteSession);
        }
        this.fireElementAddedEvent(remoteSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRemoteSessionClosed(int sessionID) {
        InternalCDORemoteTopic[] internalCDORemoteTopicArray = this.getSubscribedTopics();
        int n = internalCDORemoteTopicArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDORemoteTopic remoteTopic = internalCDORemoteTopicArray[n2];
            remoteTopic.handleRemoteSessionSubscribed(sessionID, false);
            ++n2;
        }
        CDORemoteSession remoteSession = null;
        CDORemoteSessionManagerImpl cDORemoteSessionManagerImpl = this;
        synchronized (cDORemoteSessionManagerImpl) {
            remoteSession = this.remoteSessions.remove(sessionID);
        }
        if (remoteSession != null) {
            this.fireElementRemovedEvent(remoteSession);
        }
    }

    @Override
    @Deprecated
    public void handleRemoteSessionSubscribed(int sessionID, boolean subscribed) {
        this.handleRemoteSessionSubscribed(sessionID, null, subscribed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRemoteSessionSubscribed(int sessionID, String topicID, boolean subscribed) {
        if (topicID != null) {
            InternalCDORemoteTopic remoteTopic = this.getSubscribedTopic(topicID);
            if (remoteTopic != null) {
                remoteTopic.handleRemoteSessionSubscribed(sessionID, subscribed);
            }
        } else {
            SubscriptionChangedEventImpl event = null;
            CDORemoteSessionManagerImpl cDORemoteSessionManagerImpl = this;
            synchronized (cDORemoteSessionManagerImpl) {
                InternalCDORemoteSession remoteSession = this.remoteSessions.get(sessionID);
                if (remoteSession != null) {
                    remoteSession.setSubscribed(subscribed);
                    event = new SubscriptionChangedEventImpl(remoteSession, subscribed);
                }
            }
            if (event != null) {
                this.fireEvent(event);
            }
        }
    }

    @Override
    @Deprecated
    public void handleRemoteSessionMessage(int sessionID, CDORemoteSessionMessage message) {
        this.handleRemoteSessionMessage(sessionID, null, message);
    }

    @Override
    public void handleRemoteSessionMessage(int sessionID, String topicID, CDORemoteSessionMessage message) {
        InternalCDORemoteSession remoteSession = this.remoteSessions.get(sessionID);
        if (remoteSession != null) {
            if (topicID != null) {
                InternalCDORemoteTopic topic = this.getSubscribedTopic(topicID);
                if (topic != null) {
                    topic.handleRemoteSessionMessage(remoteSession, message);
                }
            } else {
                this.fireEvent(new MessageReceivedImpl(remoteSession, message));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void firstListenerAdded() {
        IEvent[] events = null;
        CDORemoteSessionManagerImpl cDORemoteSessionManagerImpl = this;
        synchronized (cDORemoteSessionManagerImpl) {
            if (!this.subscribed) {
                events = this.subscribe();
            }
        }
        this.fireEvents(events);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lastListenerRemoved() {
        IEvent[] events = null;
        CDORemoteSessionManagerImpl cDORemoteSessionManagerImpl = this;
        synchronized (cDORemoteSessionManagerImpl) {
            if (!this.forceSubscription && this.remoteTopics.isEmpty()) {
                events = this.unsubscribe();
            }
        }
        this.fireEvents(events);
    }

    private IEvent[] subscribe() {
        List<CDORemoteSession> result = this.localSession.getSessionProtocol().getRemoteSessions(this, true);
        ContainerEvent event = new ContainerEvent((IContainer)this);
        for (CDORemoteSession remoteSession : result) {
            this.remoteSessions.put(remoteSession.getSessionID(), (InternalCDORemoteSession)remoteSession);
            event.addDelta((Object)remoteSession, IContainerDelta.Kind.ADDED);
        }
        this.subscribed = true;
        IEvent[] events = new IEvent[]{new LocalSubscriptionChangedEventImpl(true), event.isEmpty() ? null : event};
        return events;
    }

    private IEvent[] unsubscribe() {
        if (this.localSession.isActive()) {
            this.localSession.getSessionProtocol().unsubscribeRemoteSessions();
        }
        ContainerEvent event = new ContainerEvent((IContainer)this);
        for (CDORemoteSession cDORemoteSession : this.remoteSessions.values()) {
            event.addDelta((Object)cDORemoteSession, IContainerDelta.Kind.REMOVED);
        }
        this.remoteSessions.clear();
        this.subscribed = false;
        IEvent[] iEventArray = new IEvent[]{new LocalSubscriptionChangedEventImpl(false), event.isEmpty() ? null : event};
        return iEventArray;
    }

    private void fireEvents(IEvent[] events) {
        if (events != null) {
            int i = 0;
            while (i < events.length) {
                IEvent event = events[i];
                if (event != null) {
                    this.fireEvent(event);
                }
                ++i;
            }
        }
    }

    private final class LocalSubscriptionChangedEventImpl
    extends Event
    implements CDORemoteSessionManager.LocalSubscriptionChangedEvent {
        private static final long serialVersionUID = 1L;
        private final boolean subscribed;

        public LocalSubscriptionChangedEventImpl(boolean subscribed) {
            super((INotifier)CDORemoteSessionManagerImpl.this);
            this.subscribed = subscribed;
        }

        @Override
        public CDORemoteSessionManager getSource() {
            return (CDORemoteSessionManager)super.getSource();
        }

        @Override
        public boolean isSubscribed() {
            return this.subscribed;
        }
    }

    private final class MessageReceivedImpl
    extends Event
    implements CDORemoteSessionEvent.MessageReceived {
        private static final long serialVersionUID = 1L;
        private final InternalCDORemoteSession remoteSession;
        private final CDORemoteSessionMessage message;

        public MessageReceivedImpl(InternalCDORemoteSession remoteSession, CDORemoteSessionMessage message) {
            super((INotifier)CDORemoteSessionManagerImpl.this);
            this.remoteSession = remoteSession;
            this.message = message;
        }

        @Override
        public CDORemoteSessionManager getSource() {
            return (CDORemoteSessionManager)super.getSource();
        }

        @Override
        public CDORemoteSession getRemoteSession() {
            return this.remoteSession;
        }

        @Override
        public CDORemoteSessionMessage getMessage() {
            return this.message;
        }
    }

    private final class SubscriptionChangedEventImpl
    extends Event
    implements CDORemoteSessionEvent.SubscriptionChanged {
        private static final long serialVersionUID = 1L;
        private final InternalCDORemoteSession remoteSession;
        private final boolean subscribed;

        public SubscriptionChangedEventImpl(InternalCDORemoteSession remoteSession, boolean subscribed) {
            super((INotifier)CDORemoteSessionManagerImpl.this);
            this.remoteSession = remoteSession;
            this.subscribed = subscribed;
        }

        @Override
        public CDORemoteSessionManager getSource() {
            return (CDORemoteSessionManager)super.getSource();
        }

        @Override
        public CDORemoteSession getRemoteSession() {
            return this.remoteSession;
        }

        @Override
        public boolean isSubscribed() {
            return this.subscribed;
        }
    }
}

