/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoHandler;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.lob.CDOLobHandler;
import org.eclipse.emf.cdo.common.revision.CDOAllRevisionsProvider;
import org.eclipse.emf.cdo.common.revision.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageInfo;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.DetachedCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.PointerCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.SyntheticCDORevision;
import org.eclipse.emf.cdo.spi.server.InternalLockManager;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.HexUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.concurrent.Worker;
import org.eclipse.net4j.util.container.ContainerEventAdapter;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.factory.Factory;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.net4j.util.io.IOUtil;

public class CDOServerBrowser
extends Worker {
    private static final String REQUEST_PREFIX = "GET ";
    private static final String REQUEST_SUFFIX = " HTTP/1.1";
    private static final String UTF_8 = StandardCharsets.UTF_8.name();
    private ThreadLocal<Map<String, String>> params = new InheritableThreadLocal<Map<String, String>>(){

        @Override
        protected Map<String, String> initialValue() {
            return new HashMap<String, String>();
        }
    };
    private int port = 7777;
    private ServerSocket serverSocket;
    private Map<String, InternalRepository> repositories;
    private List<Page> pages = new ArrayList<Page>();

    public CDOServerBrowser(Map<String, InternalRepository> repositories) {
        this.repositories = repositories;
        this.setDaemon(true);
    }

    public Map<String, InternalRepository> getRepositories() {
        return this.repositories;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    protected void work(Worker.WorkContext context) throws Exception {
        Socket socket = null;
        try {
            socket = this.serverSocket.accept();
            BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            BufferedOutputStream out = new BufferedOutputStream(socket.getOutputStream());
            PrintStream pout = new PrintStream(out);
            this.printHeader(pout);
            String line = in.readLine();
            if (line != null) {
                if (line.startsWith(REQUEST_PREFIX) && line.endsWith(REQUEST_SUFFIX)) {
                    String pageName;
                    Page page;
                    String request;
                    String resource = request = line.substring(REQUEST_PREFIX.length(), line.length() - REQUEST_SUFFIX.length()).trim();
                    String params = "";
                    int pos = request.indexOf(63);
                    if (pos != -1) {
                        resource = request.substring(0, pos);
                        params = request.substring(pos + 1);
                    }
                    this.initParams(params);
                    LinkedHashMap<String, String> styles = new LinkedHashMap<String, String>();
                    this.initStyles(styles);
                    Runnable body = () -> this.showMenu(pout);
                    if (!"/".equals(resource) && (page = this.getPage(pageName = resource.substring(1))) != null) {
                        page.modifyStyles(styles);
                        body = () -> this.showPage(pout, page);
                    }
                    pout.print("<html>\r\n");
                    pout.print("<head>\r\n");
                    pout.print("<style>\r\n");
                    styles.forEach((key, value) -> pout.print(" " + key + " { " + value + " }\r\n"));
                    pout.print("</style>\r\n");
                    pout.print("</head>\r\n");
                    pout.print("<body>\r\n");
                    body.run();
                    pout.print("</body>\r\n");
                    pout.print("</html>\r\n");
                }
                ((OutputStream)out).flush();
                return;
            }
        }
        catch (Exception ex) {
            if (this.isActive()) {
                ex.printStackTrace();
            }
        }
        finally {
            this.params.remove();
            if (socket != null) {
                socket.close();
            }
        }
    }

    protected void initParams(String params) {
        Map<String, String> map = this.params.get();
        String[] stringArray = params.split("&");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            if (param.length() != 0) {
                String[] keyValue = param.split("=");
                if (keyValue.length == 1) {
                    map.put(keyValue[0], "true");
                } else {
                    map.put(keyValue[0], keyValue[1]);
                }
            }
            ++n2;
        }
    }

    protected void initStyles(Map<String, String> styles) {
        styles.put("html *", "font-family:Arial,Helvetica,sans-serif;");
        styles.put("a", "text-decoration:none;color:inherit;");
        styles.put("a:hover,a:active", "background-color:lightgray;");
        styles.put("table.data", "border-collapse:collapse;");
        styles.put("table.data th", "border:1px solid;padding:3px;border-color:lightgray;");
        styles.put("table.data td", "border:1px solid;padding:3px;border-color:lightgray;");
    }

    protected void clearParams() {
        Map<String, String> map = this.params.get();
        map.clear();
    }

    public void removeParam(String key) {
        Map<String, String> map = this.params.get();
        map.remove(key);
    }

    public String getParam(String key) {
        Map<String, String> map = this.params.get();
        String value = map.get(key);
        if (value != null) {
            try {
                value = URLDecoder.decode(value, UTF_8);
            }
            catch (UnsupportedEncodingException ex) {
                ex.printStackTrace();
            }
        }
        return value;
    }

    public boolean isParam(String key) {
        Map<String, String> map = this.params.get();
        return "true".equalsIgnoreCase(map.get(key));
    }

    public String href(String label, String resource, String ... params) {
        return this.href((Pair<String, String>)Pair.create((Object)label, null), resource, params);
    }

    public String href(Pair<String, String> labelAndTooltip, String resource, String ... params) {
        String label = (String)labelAndTooltip.getElement1();
        String tooltip = (String)labelAndTooltip.getElement2();
        tooltip = tooltip != null ? " title=\"" + this.escape(tooltip) + "\"" : "";
        HashMap<String, String> map = new HashMap<String, String>(this.params.get());
        int i = 0;
        while (i < params.length) {
            String value;
            String key = params[i++];
            if ((value = params[i++]) == null) {
                map.remove(key);
                continue;
            }
            map.put(key, value);
        }
        ArrayList list = new ArrayList(map.keySet());
        Collections.sort(list);
        StringBuilder builder = new StringBuilder();
        for (String key : list) {
            String value = (String)map.get(key);
            if (value == null) continue;
            StringUtil.appendSeparator((StringBuilder)builder, (char)'&');
            builder.append(key);
            builder.append('=');
            builder.append(CDOServerBrowser.encodeParam(value));
        }
        return "<a href=\"/" + this.escape(resource) + "?" + this.escape(builder.toString()) + "\"" + tooltip + ">" + this.escape(label) + "</a>";
    }

    public String escape(String raw) {
        if (raw == null) {
            return "null";
        }
        return raw.replace("<", "&lt;");
    }

    protected void printHeader(PrintStream pout) {
        pout.print("HTTP/1.1 200 OK\r\n");
        pout.print("Content-Type: text/html\r\n");
        pout.print("Date: " + new Date() + "\r\n");
        pout.print("Server: DBBrowser 3.0\r\n");
        pout.print("\r\n");
    }

    protected void showMenu(PrintStream pout) {
        this.clearParams();
        pout.print("<h1>CDO Server Browser 4.0</h1><hr>\r\n");
        for (Page page : this.pages) {
            pout.println("<h3>&#x21E8;&nbsp;" + this.href(page.getLabel(), page.getName(), new String[0]) + "</h3>");
        }
    }

    protected void showPage(PrintStream pout, Page page) {
        String repo = this.getParam("repo");
        ArrayList<String> repoNames = new ArrayList<String>(this.getRepositoryNames());
        Collections.sort(repoNames);
        pout.print("<h3><a href=\"/\" title=\"Menu\">&#x21E7;</a>&nbsp;" + page.getLabel() + ":&nbsp;&nbsp;");
        for (String repoName : repoNames) {
            InternalRepository repository = this.getRepository(repoName);
            if (!page.canDisplay(repository)) continue;
            if (repo == null) {
                repo = repoName;
            }
            if (repoName.equals(repo)) {
                pout.print("<b>" + this.escape(repoName) + "</b>&nbsp;&nbsp;");
                continue;
            }
            pout.print(String.valueOf(this.href(repoName, page.getName(), "repo", repoName)) + "&nbsp;&nbsp;");
        }
        pout.print("</h3>\r\n");
        InternalRepository repository = this.getRepository(repo);
        if (repository != null) {
            pout.print("<p>\r\n");
            InternalSession session = repository.getSessionManager().openSession(null);
            StoreThreadLocal.setSession(session);
            try {
                page.display(this, repository, pout);
            }
            finally {
                StoreThreadLocal.release();
                session.close();
            }
        }
    }

    protected Set<String> getRepositoryNames() {
        return this.repositories.keySet();
    }

    protected InternalRepository getRepository(String name) {
        return this.repositories.get(name);
    }

    protected String getThreadName() {
        return "CDOServerBrowser";
    }

    protected void initPages(List<Page> pages) {
        pages.add(new PackagesPage());
        pages.add(new BranchesPage());
        pages.add(new LocksPage());
        pages.add(new RevisionsPage.FromCache());
        pages.add(new RevisionsPage.FromStore());
        pages.add(new LobsPage());
        pages.add(new HistoryPage());
        IManagedContainer container = this.getPagesContainer();
        for (String factoryType : container.getFactoryTypes("org.eclipse.emf.cdo.server.browserPages")) {
            try {
                Page page = (Page)container.getElement("org.eclipse.emf.cdo.server.browserPages", factoryType, null);
                pages.add(page);
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
            }
        }
    }

    protected Page getPage(String name) {
        for (Page page : this.pages) {
            if (!page.getName().equals(name)) continue;
            return page;
        }
        return null;
    }

    protected IManagedContainer getPagesContainer() {
        return IPluginContainer.INSTANCE;
    }

    protected void doActivate() throws Exception {
        this.initPages(this.pages);
        try {
            this.serverSocket = new ServerSocket(this.port);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not open socket on port " + this.port, ex);
        }
        super.doActivate();
    }

    protected void doDeactivate() throws Exception {
        this.serverSocket.close();
        super.doDeactivate();
    }

    private static String encodeParam(String value) {
        try {
            return URLEncoder.encode(value, UTF_8);
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
            return value;
        }
    }

    public static String formatTimeStamp(long timeStamp) {
        String str = CDOCommonUtil.formatTimeStamp((long)timeStamp);
        if (!"*".equals(str)) {
            str = String.valueOf(str) + " - " + timeStamp;
            str = str.replaceAll(" ", "&nbsp;");
        }
        return str;
    }

    public static abstract class AbstractPage
    implements Page {
        private String name;
        private String label;

        public AbstractPage(String name, String label) {
            this.name = name;
            this.label = label;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getLabel() {
            return this.label;
        }
    }

    public static class BranchesPage
    extends AbstractPage {
        public static final String NAME = "branches";

        public BranchesPage() {
            super(NAME, "Branches");
        }

        @Override
        public boolean canDisplay(InternalRepository repository) {
            return true;
        }

        @Override
        public void display(CDOServerBrowser browser, InternalRepository repository, PrintStream out) {
            out.println("<ul>");
            this.showBranch(out, (CDOBranch)repository.getBranchManager().getMainBranch());
            out.println("</ul>");
        }

        protected void showBranch(PrintStream out, CDOBranch branch) {
            String name = branch.getName();
            int id = branch.getID();
            String timeStamp = branch.isDeleted() ? "DELETED" : CDOCommonUtil.formatTimeStamp((long)branch.getTimeStamp());
            out.println("<li>" + name + " [" + id + ", " + timeStamp + "]");
            CDOBranch[] cDOBranchArray = branch.getBranches();
            int n = cDOBranchArray.length;
            int n2 = 0;
            while (n2 < n) {
                CDOBranch child = cDOBranchArray[n2];
                out.println("<ul>");
                this.showBranch(out, child);
                out.println("</ul>");
                ++n2;
            }
        }
    }

    public static class ContainerBased
    extends CDOServerBrowser {
        private IContainer<?> container;
        private IListener containerListener = new ContainerEventAdapter<Object>(){

            protected void onAdded(IContainer<Object> container, Object element) {
                this.addElement(element);
            }

            protected void onRemoved(IContainer<Object> container, Object element) {
                this.removeElement(element);
            }
        };

        public ContainerBased(IContainer<?> container) {
            super(new HashMap<String, InternalRepository>());
            this.container = container;
        }

        public ContainerBased() {
            this((IContainer<?>)IPluginContainer.INSTANCE);
        }

        public IContainer<?> getContainer() {
            return this.container;
        }

        @Override
        protected IManagedContainer getPagesContainer() {
            if (this.container instanceof IManagedContainer) {
                return (IManagedContainer)this.container;
            }
            return IPluginContainer.INSTANCE;
        }

        @Override
        protected void doActivate() throws Exception {
            super.doActivate();
            Object[] objectArray = this.container.getElements();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                this.addElement(element);
                ++n2;
            }
            this.container.addListener(this.containerListener);
        }

        @Override
        protected void doDeactivate() throws Exception {
            this.container.removeListener(this.containerListener);
            super.doDeactivate();
        }

        private void addElement(Object element) {
            if (element instanceof InternalRepository) {
                InternalRepository repository = (InternalRepository)element;
                this.getRepositories().put(repository.getName(), repository);
            }
        }

        private void removeElement(Object element) {
            if (element instanceof InternalRepository) {
                InternalRepository repository = (InternalRepository)element;
                this.getRepositories().remove(repository.getName());
            }
        }

        public static class Factory
        extends org.eclipse.net4j.util.factory.Factory {
            public static final String PRODUCT_GROUP = "org.eclipse.emf.cdo.server.browsers";
            public static final String TYPE = "default";
            private IContainer<?> container;

            public Factory() {
                this((IContainer<?>)IPluginContainer.INSTANCE);
            }

            public Factory(IContainer<?> container) {
                super(PRODUCT_GROUP, TYPE);
                this.container = container;
            }

            public ContainerBased create(String description) throws ProductCreationException {
                ContainerBased browser = new ContainerBased(this.container);
                try {
                    int port = 0;
                    if (!StringUtil.isEmpty((String)description)) {
                        int digits = 0;
                        int i = 0;
                        while (i < description.length()) {
                            if (!Character.isDigit(description.charAt(i))) break;
                            ++digits;
                            ++i;
                        }
                        if (digits != 0) {
                            port = Integer.parseInt(description.substring(0, digits));
                        }
                    }
                    if (port == 0) {
                        port = IOUtil.getFreePort();
                    }
                    browser.setPort(port);
                }
                catch (Exception ex) {
                    OM.LOG.warn((Throwable)ex);
                }
                return browser;
            }
        }
    }

    public static class HistoryPage
    extends AbstractPage {
        public static final String NAME = "history";

        public HistoryPage() {
            super(NAME, "Commit Infos");
        }

        @Override
        public boolean canDisplay(InternalRepository repository) {
            return true;
        }

        @Override
        public void display(final CDOServerBrowser browser, InternalRepository repository, final PrintStream out) {
            out.print("<table border=\"0\">\r\n");
            out.print("<tr>\r\n");
            out.print("<td valign=\"top\">\r\n");
            IStoreAccessor accessor = repository.getStore().getReader(null);
            StoreThreadLocal.setAccessor(accessor);
            final String param = browser.getParam("time");
            out.print("<table class=\"data\">\r\n");
            out.print("<tr>\r\n");
            out.print("<td valign=\"top\">Time</td>\r\n");
            out.print("<td valign=\"top\">Branch</td>\r\n");
            out.print("<td valign=\"top\">User</td>\r\n");
            out.print("<td valign=\"top\">Comment</td>\r\n");
            if (repository.getCommitInfoStorage() == CDOCommonRepository.CommitInfoStorage.WITH_MERGE_SOURCE) {
                out.print("<td valign=\"top\">Merge</td>\r\n");
            }
            out.print("</tr>\r\n");
            final CDOCommitInfo[] details = new CDOCommitInfo[1];
            try {
                final boolean auditing = repository.isSupportingAudits();
                repository.getCommitInfoManager().getCommitInfos(null, 0L, 0L, new CDOCommitInfoHandler(){

                    public void handleCommitInfo(CDOCommitInfo commitInfo) {
                        if (this.showCommitInfo(out, commitInfo, browser, param, auditing)) {
                            details[0] = commitInfo;
                        }
                    }
                });
                out.print("</table>\r\n");
                out.print("</td>\r\n");
                out.print("<td>&nbsp;&nbsp;&nbsp;</td>\r\n");
                out.print("<td valign=\"top\">\r\n");
                if (auditing) {
                    CDOCommitInfo commitInfo = details[0];
                    if (commitInfo != null) {
                        out.print("<h3>Commit Info " + commitInfo.getTimeStamp() + "</h3>\r\n");
                        this.showCommitData(out, commitInfo, browser);
                    }
                } else {
                    out.print("<h3>No audit data available in this repository.</h3>\r\n");
                }
                out.print("</td>\r\n");
                out.print("</tr>\r\n");
                out.print("</table>\r\n");
            }
            finally {
                StoreThreadLocal.release();
            }
        }

        protected boolean showCommitInfo(PrintStream out, CDOCommitInfo commitInfo, CDOServerBrowser browser, String param, boolean auditing) {
            String formatted;
            String timeStamp = String.valueOf(commitInfo.getTimeStamp());
            boolean selected = timeStamp.equals(param);
            String label = formatted = CDOServerBrowser.formatTimeStamp(commitInfo.getTimeStamp());
            if (!selected && auditing) {
                label = browser.href(formatted, this.getName(), "time", timeStamp);
            }
            out.print("<tr>\r\n");
            out.print("<td valign=\"top\">\r\n");
            out.print(label);
            out.print("</td>\r\n");
            CDOBranch branch = commitInfo.getBranch();
            out.print("<td valign=\"top\">\r\n");
            out.print(String.valueOf(branch.getName()) + "[" + branch.getID() + "]");
            out.print("</td>\r\n");
            String userID = commitInfo.getUserID();
            out.print("<td valign=\"top\">\r\n");
            out.print(StringUtil.isEmpty((String)userID) ? "&nbsp;" : browser.escape(userID));
            out.print("</td>\r\n");
            String comment = commitInfo.getComment();
            out.print("<td valign=\"top\">\r\n");
            out.print(StringUtil.isEmpty((String)comment) ? "&nbsp;" : browser.escape(comment));
            out.print("</td>\r\n");
            CDOCommonRepository repository = commitInfo.getCommitInfoManager().getRepository();
            if (repository.getCommitInfoStorage() == CDOCommonRepository.CommitInfoStorage.WITH_MERGE_SOURCE) {
                out.print("<td valign=\"top\">\r\n");
                CDOBranchPoint mergeSource = commitInfo.getMergeSource();
                if (mergeSource == null) {
                    out.print("&nbsp;");
                } else {
                    String mergeSourceLabel = String.valueOf(browser.escape(mergeSource.getBranch().getPathName())) + "&nbsp;-&nbsp;" + CDOServerBrowser.formatTimeStamp(mergeSource.getTimeStamp());
                    out.print(browser.href(mergeSourceLabel, this.getName(), "time", String.valueOf(mergeSource.getTimeStamp())));
                }
                out.print("</td>\r\n");
            }
            out.print("</tr>\r\n");
            return selected;
        }

        protected void showCommitData(PrintStream out, CDOCommitInfo commitInfo, CDOServerBrowser browser) {
            out.print("<h4>New Objects:</h4>\r\n");
            out.print("<ul>\r\n");
            for (CDOIDAndVersion key : commitInfo.getNewObjects()) {
                CDORevision newObject = (CDORevision)key;
                out.print("<li>" + browser.href(newObject.toString(), "srevisions", "revision", CDORevisionUtil.formatRevisionKey((CDORevisionKey)newObject)) + "<br>\r\n");
            }
            out.print("</ul>\r\n");
            out.print("<h4>Changed Objects:</h4>\r\n");
            out.print("<ul>\r\n");
            for (CDOIDAndVersion key : commitInfo.getChangedObjects()) {
                CDORevisionDelta changedObject = (CDORevisionDelta)key;
                out.print("<li>" + changedObject.toString() + "<br>\r\n");
            }
            out.print("</ul>\r\n");
            out.print("<h4>Detached Objects:</h4>\r\n");
            out.print("<ul>\r\n");
            for (CDOIDAndVersion key : commitInfo.getDetachedObjects()) {
                out.print("<li>" + key.toString() + "<br>\r\n");
            }
            out.print("</ul>\r\n");
        }
    }

    public static class LobsPage
    extends AbstractPage {
        public static final String NAME = "lobs";

        public LobsPage() {
            super(NAME, "Large Objects");
        }

        @Override
        public boolean canDisplay(InternalRepository repository) {
            return true;
        }

        @Override
        public void display(final CDOServerBrowser browser, InternalRepository repository, final PrintStream out) {
            out.print("<table border=\"0\">\r\n");
            out.print("<tr>\r\n");
            out.print("<td valign=\"top\">\r\n");
            final String param = browser.getParam("id");
            final Object[] details = new Object[3];
            try {
                repository.handleLobs(0L, 0L, new CDOLobHandler(){

                    public OutputStream handleBlob(byte[] id, long size) {
                        if (this.showLob(out, "Blob", id, size, browser, param)) {
                            ByteArrayOutputStream result = new ByteArrayOutputStream();
                            details[0] = result;
                            details[1] = param;
                            details[2] = size;
                            return result;
                        }
                        return null;
                    }

                    public Writer handleClob(byte[] id, long size) {
                        if (this.showLob(out, "Clob", id, size, browser, param)) {
                            CharArrayWriter result = new CharArrayWriter();
                            details[0] = result;
                            details[1] = param;
                            details[2] = size;
                            return result;
                        }
                        return null;
                    }
                });
            }
            catch (IOException ex) {
                throw WrappedException.wrap((Exception)ex);
            }
            out.print("</td>\r\n");
            if (details[0] != null) {
                out.print("<td>&nbsp;&nbsp;&nbsp;</td>\r\n");
                out.print("<td valign=\"top\">\r\n");
                if (details[0] instanceof ByteArrayOutputStream) {
                    ByteArrayOutputStream baos = (ByteArrayOutputStream)details[0];
                    String hex = HexUtil.bytesToHex((byte[])baos.toByteArray());
                    out.println("<h3>Blob " + details[1] + " (" + details[2] + ")</h3>");
                    out.println("<pre>\r\n");
                    int i = 0;
                    while (i < hex.length()) {
                        out.print(hex.charAt(i));
                        if ((i + 1) % 32 == 0) {
                            out.print("\r\n");
                        } else if ((i + 1) % 16 == 0) {
                            out.print("  ");
                        } else if ((i + 1) % 2 == 0) {
                            out.print(" ");
                        }
                        ++i;
                    }
                    out.println("</pre>\r\n");
                } else {
                    CharArrayWriter caw = (CharArrayWriter)details[0];
                    out.println("<h3>Clob " + details[1] + " (" + details[2] + ")</h3>");
                    out.println("<pre>" + caw + "</pre>");
                }
                out.print("</td>\r\n");
            }
            out.print("</tr>\r\n");
            out.print("</table>\r\n");
        }

        protected boolean showLob(PrintStream out, String type, byte[] id, long size, CDOServerBrowser browser, String param) {
            String hex = HexUtil.bytesToHex((byte[])id);
            boolean selected = hex.equals(param);
            String label = selected ? hex : browser.href(hex, this.getName(), "id", hex);
            out.println(String.valueOf(type) + " " + label + " (" + size + ")");
            return selected;
        }
    }

    public static class LocksPage
    extends AbstractPage {
        public static final String NAME = "locks";

        public LocksPage() {
            super(NAME, "Locks");
        }

        @Override
        public boolean canDisplay(InternalRepository repository) {
            return true;
        }

        @Override
        public void display(CDOServerBrowser browser, InternalRepository repository, PrintStream out) {
            out.println("<table class=\"data\">");
            out.println("<tr><th>Locked Object</th><th>Read Lock Owners</th><th>Write Lock Owner</th><th>Write Option Owner</th></tr>");
            InternalLockManager lockingManager = repository.getLockingManager();
            lockingManager.getLockStates(lockState -> {
                out.print("<tr>");
                out.print("<td>" + LocksPage.format(lockState.getLockedObject()) + "</td>");
                out.print("<td>" + LocksPage.format(lockState.getReadLockOwners()) + "</td>");
                out.print("<td>" + LocksPage.format(lockState.getWriteLockOwner()) + "</td>");
                out.print("<td>" + LocksPage.format(lockState.getWriteOptionOwner()) + "</td>");
                out.print("</tr>");
            });
            out.println("</table>");
        }

        private static String format(Object object) {
            if (object == null) {
                return "&nbsp;";
            }
            if (object instanceof Collection) {
                Collection elements = (Collection)object;
                StringBuilder builder = new StringBuilder();
                for (Object element : elements) {
                    StringUtil.appendSeparator((StringBuilder)builder, (String)"<br>");
                    builder.append(LocksPage.format(element));
                }
                return builder.toString();
            }
            if (object instanceof IView) {
                IView view = (IView)object;
                String value = view.isReadOnly() ? "View" : "Transaction";
                value = String.valueOf(value) + "[" + view.getSessionID() + ":" + view.getViewID();
                if (view.isDurableView()) {
                    value = "Durable" + value + ":" + view.getDurableLockingID();
                }
                value = String.valueOf(value) + "]";
                return value;
            }
            String value = String.valueOf(object);
            return value.replace(" ", "&nbsp;");
        }
    }

    public static class PackagesPage
    extends AbstractPage {
        public static final String NAME = "packages";

        public PackagesPage() {
            super(NAME, "Packages and Classes");
        }

        @Override
        public boolean canDisplay(InternalRepository repository) {
            return true;
        }

        @Override
        public void display(CDOServerBrowser browser, InternalRepository repository, PrintStream out) {
            String param = browser.getParam("classifier");
            InternalCDOPackageRegistry packageRegistry = repository.getPackageRegistry(false);
            InternalCDOPackageUnit[] internalCDOPackageUnitArray = packageRegistry.getPackageUnits();
            int n = internalCDOPackageUnitArray.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDOPackageUnit unit = internalCDOPackageUnitArray[n2];
                param = this.showPackage(unit.getTopLevelPackageInfo(), packageRegistry, browser, param, out, "&nbsp;&nbsp;");
                ++n2;
            }
        }

        protected String showPackage(InternalCDOPackageInfo info, InternalCDOPackageRegistry packageRegistry, CDOServerBrowser browser, String param, PrintStream out, String prefix) {
            EPackage ePackage = info.getEPackage();
            out.println("<h4>" + prefix + ePackage.getName() + "&nbsp;&nbsp;[" + ePackage.getNsURI() + "]</h4>\r\n");
            for (EClassifier classifier : ePackage.getEClassifiers()) {
                String name = classifier.getName();
                if (param == null) {
                    param = name;
                }
                String type = "";
                String label = name.equals(param) ? name : browser.href(name, this.getName(), "classifier", name);
                String extra = "";
                if (classifier instanceof EEnum) {
                    type = "&#x1F154;";
                    extra = "&nbsp;&nbsp;[" + ((EEnum)classifier).getELiterals().stream().map(literal -> String.valueOf(literal.getName()) + "(" + literal.getValue() + ")").collect(Collectors.joining(", ")) + "]";
                } else if (classifier instanceof EDataType) {
                    type = "&#x1F153;";
                    extra = "&nbsp;&nbsp;[" + classifier.getInstanceClassName() + "]";
                } else {
                    type = "&#x1F152;";
                    label = "<b>" + label + "</b>";
                }
                out.print(String.valueOf(prefix) + "&nbsp;&nbsp;" + type + "&nbsp;" + label + extra + "<br>\r\n");
            }
            for (EPackage sub : ePackage.getESubpackages()) {
                InternalCDOPackageInfo subInfo = packageRegistry.getPackageInfo(sub);
                param = this.showPackage(subInfo, packageRegistry, browser, param, out, String.valueOf(prefix) + "&nbsp;&nbsp;");
            }
            return param;
        }
    }

    public static interface Page {
        public static final String PRODUCT_GROUP = "org.eclipse.emf.cdo.server.browserPages";

        public String getName();

        public String getLabel();

        public boolean canDisplay(InternalRepository var1);

        public void display(CDOServerBrowser var1, InternalRepository var2, PrintStream var3);

        default public void modifyStyles(Map<String, String> styles) {
        }
    }

    public static abstract class RevisionsPage
    extends AbstractPage {
        public RevisionsPage(String name, String label) {
            super(name, label);
        }

        @Override
        public void display(final CDOServerBrowser browser, InternalRepository repository, PrintStream out) {
            Map<CDOBranch, List<CDORevision>> allRevisions = this.getAllRevisions(repository);
            Map<CDOID, List<CDORevision>> ids = this.getAllIDs(allRevisions);
            out.print("<table border=\"0\">\r\n");
            out.print("<tr>\r\n");
            out.print("<td valign=\"top\">\r\n");
            out.print("<table border=\"0\"><tr><td>\r\n");
            final String[] revision = new String[]{browser.getParam("revision")};
            new CDORevisionUtil.AllRevisionsDumper.Stream.Html(allRevisions, out){
                private StringBuilder versionsBuilder;
                private CDORevision lastRevision;

                protected void dumpStart(List<CDOBranch> branches) {
                    this.out().println("<table class=\"data\">");
                }

                protected void dumpEnd(List<CDOBranch> branches) {
                    this.dumpLastRevision();
                    super.dumpEnd(branches);
                }

                protected void dumpBranch(CDOBranch branch) {
                    this.dumpLastRevision();
                    super.dumpBranch(branch);
                }

                protected void dumpRevision(CDORevision rev) {
                    CDOID id = rev.getID();
                    if (this.lastRevision != null && !id.equals(this.lastRevision.getID())) {
                        this.dumpLastRevision();
                    }
                    if (this.versionsBuilder == null) {
                        this.versionsBuilder = new StringBuilder();
                    } else {
                        this.versionsBuilder.append(" ");
                    }
                    String key = CDORevisionUtil.formatRevisionKey((CDORevisionKey)rev);
                    if (revision[0] == null) {
                        revision[0] = key;
                    }
                    String version = String.valueOf(this.getVersionPrefix(rev)) + rev.getVersion();
                    if (key.equals(revision[0])) {
                        this.versionsBuilder.append("<b>" + version + "</b>");
                    } else {
                        this.versionsBuilder.append(browser.href(version, this.getName(), "revision", key));
                    }
                    this.lastRevision = rev;
                }

                protected void dumpLastRevision() {
                    if (this.versionsBuilder != null) {
                        PrintStream out = this.out();
                        out.println("<tr>");
                        out.println("<td valign=\"top\">&nbsp;&nbsp;&nbsp;&nbsp;");
                        out.println(this.getCDOIDLabel(this.lastRevision));
                        out.println("&nbsp;&nbsp;&nbsp;&nbsp;</td>");
                        out.println("<td>");
                        out.println(this.versionsBuilder.toString());
                        out.println("</td>");
                        out.println("</tr>");
                        this.lastRevision = null;
                        this.versionsBuilder = null;
                    }
                }
            }.dump();
            out.print("</td></tr></table></td>\r\n");
            out.print("<td>&nbsp;&nbsp;&nbsp;</td>\r\n");
            if (revision[0] != null) {
                out.print("<td valign=\"top\">\r\n");
                this.showRevision(out, browser, allRevisions, ids, revision[0], repository);
                out.print("</td>\r\n");
            }
            out.print("</tr>\r\n");
            out.print("</table>\r\n");
        }

        protected void showRevision(PrintStream pout, CDOServerBrowser browser, Map<CDOBranch, List<CDORevision>> allRevisions, Map<CDOID, List<CDORevision>> ids, String key, InternalRepository repository) {
            CDORevisionKey revisionKey = CDORevisionUtil.parseRevisionKey((String)key, (CDOBranchManager)repository.getBranchManager());
            for (CDORevision revision : allRevisions.get(revisionKey.getBranch())) {
                if (revision.getVersion() != revisionKey.getVersion() || !revision.getID().equals(revisionKey.getID())) continue;
                this.showRevision(pout, browser, ids, (InternalCDORevision)revision);
                return;
            }
        }

        protected void showRevision(PrintStream pout, CDOServerBrowser browser, Map<CDOID, List<CDORevision>> ids, InternalCDORevision revision) {
            String className = revision.getEClass().toString();
            className = className.substring(className.indexOf(32));
            className = StringUtil.replace((String)className, (String[])new String[]{"(", ")", ","}, (String[])new String[]{"<br>", "", "<br>"});
            className = className.substring("<br>".length() + 1);
            String created = CDOServerBrowser.formatTimeStamp(revision.getTimeStamp());
            String commitInfo = browser.href(created, "history", "time", String.valueOf(revision.getTimeStamp()));
            pout.print("<table class=\"data\">\r\n");
            this.showKeyValue(pout, true, "type", "<b>" + revision.getClass().getSimpleName() + "</b>");
            this.showKeyValue(pout, true, "class", className);
            this.showKeyValue(pout, true, "id", this.getRevisionValue(revision.getID(), browser, ids, revision));
            this.showKeyValue(pout, true, "branch", String.valueOf(revision.getBranch().getName()) + "[" + revision.getBranch().getID() + "]");
            this.showKeyValue(pout, true, "version", revision.getVersion());
            this.showKeyValue(pout, true, "created", commitInfo);
            this.showKeyValue(pout, true, "revised", CDOServerBrowser.formatTimeStamp(revision.getRevised()));
            if (revision instanceof SyntheticCDORevision) {
                if (revision instanceof PointerCDORevision) {
                    PointerCDORevision pointer = (PointerCDORevision)revision;
                    CDOBranchVersion target = pointer.getTarget();
                    CDOBranch branch = target.getBranch();
                    int version = target.getVersion();
                    String label = this.getVersionLabel("v", version, branch);
                    CDORevisionKey targetKey = CDORevisionUtil.createRevisionKey((CDOID)pointer.getID(), (CDOBranch)branch, (int)version);
                    String value = CDORevisionUtil.formatRevisionKey((CDORevisionKey)targetKey);
                    this.showKeyValue(pout, true, "target", browser.href(label, this.getName(), "revision", value));
                }
            } else {
                this.showKeyValue(pout, true, "resource", this.getRevisionValue(revision.getResourceID(), browser, ids, revision));
                this.showKeyValue(pout, true, "container", this.getRevisionValue(revision.getContainerID(), browser, ids, revision));
                this.showKeyValue(pout, true, "feature", revision.getContainerFeatureID());
                EStructuralFeature[] eStructuralFeatureArray = revision.getClassInfo().getAllPersistentFeatures();
                int n = eStructuralFeatureArray.length;
                int n2 = 0;
                while (n2 < n) {
                    EStructuralFeature feature = eStructuralFeatureArray[n2];
                    Object value = revision.getValue(feature);
                    this.showKeyValue(pout, false, feature.getName(), this.getRevisionValue(value, browser, ids, revision));
                    ++n2;
                }
            }
            pout.print("</table>\r\n");
        }

        protected Object getRevisionValue(Object value, CDOServerBrowser browser, Map<CDOID, List<CDORevision>> ids, InternalCDORevision context) {
            List<CDORevision> revisions;
            if (value instanceof CDOID && (revisions = ids.get(value)) != null) {
                StringBuilder builder = new StringBuilder();
                builder.append(this.getCDOIDLabel(revisions.get(0)));
                if (browser != null) {
                    builder.append("&nbsp;&nbsp;");
                    for (CDORevision revision : revisions) {
                        String versionPrefix = this.getVersionPrefix(revision);
                        int version = revision.getVersion();
                        CDOBranch branch = revision.getBranch();
                        String label = this.getVersionLabel(versionPrefix, version, branch);
                        builder.append(" ");
                        if (revision == context) {
                            builder.append(label);
                            continue;
                        }
                        builder.append(browser.href(label, this.getName(), "revision", CDORevisionUtil.formatRevisionKey((CDORevisionKey)revision)));
                    }
                }
                return builder.toString();
            }
            if (value instanceof Collection) {
                StringBuilder builder = new StringBuilder();
                for (Object element : (Collection)value) {
                    builder.append(builder.length() == 0 ? "" : "<br>");
                    builder.append(this.getRevisionValue(element, browser, ids, context));
                }
                return builder.toString();
            }
            return value;
        }

        private String getVersionLabel(String versionPrefix, int version, CDOBranch branch) {
            String label = String.valueOf(versionPrefix) + version;
            String branchName = branch.getName();
            if (!"MAIN".equals(branchName)) {
                label = String.valueOf(label) + "[" + branchName + "]";
            }
            return label;
        }

        private String getVersionPrefix(CDORevision revision) {
            if (revision instanceof PointerCDORevision) {
                return "p";
            }
            if (revision instanceof DetachedCDORevision) {
                return "d";
            }
            return "v";
        }

        protected void showKeyValue(PrintStream pout, boolean bg, String key, Object value) {
            String color = bg ? "EEEEEE" : "FFFFFF";
            pout.print("<tr bgcolor=\"" + color + "\">\r\n");
            pout.print("<td valign=\"top\"><b>" + key + "</b></td>\r\n");
            pout.print("<td valign=\"top\">");
            pout.print(value);
            pout.print("</td>\r\n");
            pout.print("</tr>\r\n");
        }

        protected abstract Map<CDOBranch, List<CDORevision>> getAllRevisions(InternalRepository var1);

        private Map<CDOID, List<CDORevision>> getAllIDs(Map<CDOBranch, List<CDORevision>> allRevisions) {
            Map ids = CDOIDUtil.createMap();
            for (List<CDORevision> list : allRevisions.values()) {
                for (CDORevision revision : list) {
                    CDOID id = revision.getID();
                    ArrayList<CDORevision> revisions = (ArrayList<CDORevision>)ids.get(id);
                    if (revisions == null) {
                        revisions = new ArrayList<CDORevision>();
                        ids.put(id, revisions);
                    }
                    revisions.add(revision);
                }
            }
            return ids;
        }

        protected String getCDOIDLabel(CDORevision revision) {
            String label = revision.toString();
            return label.substring(0, label.indexOf(58));
        }

        public static class FromCache
        extends RevisionsPage {
            public static final String NAME = "crevisions";

            public FromCache() {
                super(NAME, "Revisions From Cache");
            }

            @Override
            public boolean canDisplay(InternalRepository repository) {
                return true;
            }

            @Override
            protected Map<CDOBranch, List<CDORevision>> getAllRevisions(InternalRepository repository) {
                return repository.getRevisionManager().getCache().getAllRevisions();
            }
        }

        public static class FromStore
        extends RevisionsPage {
            public static final String NAME = "srevisions";

            public FromStore() {
                super(NAME, "Revisions From Store");
            }

            @Override
            public boolean canDisplay(InternalRepository repository) {
                return repository.getStore() instanceof CDOAllRevisionsProvider;
            }

            @Override
            protected Map<CDOBranch, List<CDORevision>> getAllRevisions(InternalRepository repository) {
                return ((CDOAllRevisionsProvider)repository.getStore()).getAllRevisions();
            }
        }
    }
}

