/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.revision.delta;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDeltaVisitor;
import org.eclipse.emf.cdo.common.revision.delta.CDOMoveFeatureDelta;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOFeatureDeltaImpl;
import org.eclipse.emf.cdo.spi.common.revision.CDOReferenceAdjuster;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDOFeatureDelta;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;

public class CDOMoveFeatureDeltaImpl
extends CDOFeatureDeltaImpl
implements CDOMoveFeatureDelta,
InternalCDOFeatureDelta.ListIndexAffecting,
InternalCDOFeatureDelta.WithIndex {
    private int oldPosition;
    private int newPosition;
    private Object value;

    public CDOMoveFeatureDeltaImpl(EStructuralFeature feature, int newPosition, int oldPosition) {
        super(feature);
        this.newPosition = newPosition;
        this.oldPosition = oldPosition;
        this.value = UNKNOWN_VALUE;
    }

    public CDOMoveFeatureDeltaImpl(CDODataInput in, EClass eClass) throws IOException {
        super(in, eClass);
        this.newPosition = in.readXInt();
        this.oldPosition = in.readXInt();
        this.value = UNKNOWN_VALUE;
    }

    @Override
    public void write(CDODataOutput out, EClass eClass) throws IOException {
        super.write(out, eClass);
        out.writeXInt(this.newPosition);
        out.writeXInt(this.oldPosition);
    }

    @Override
    public int getNewPosition() {
        return this.newPosition;
    }

    @Override
    public int getOldPosition() {
        return this.oldPosition;
    }

    @Override
    public CDOFeatureDelta.Type getType() {
        return CDOFeatureDelta.Type.MOVE;
    }

    @Override
    public int getIndex() {
        return this.oldPosition;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setOldPosition(int oldPosition) {
        this.oldPosition = oldPosition;
    }

    public void setNewPosition(int newPosition) {
        this.newPosition = newPosition;
    }

    @Override
    public CDOFeatureDelta copy() {
        CDOMoveFeatureDeltaImpl copy = new CDOMoveFeatureDeltaImpl(this.getFeature(), this.newPosition, this.oldPosition);
        copy.setValue(this.getValue());
        return copy;
    }

    @Override
    public Object applyTo(CDORevision revision) {
        EStructuralFeature feature = this.getFeature();
        InternalCDORevision internalRevision = (InternalCDORevision)revision;
        CDOList list = internalRevision.getListOrNull(feature);
        if (this.oldPosition < 0) {
            return null;
        }
        int size = list.size();
        if (this.oldPosition > size) {
            return null;
        }
        if (this.newPosition < 0) {
            this.newPosition = 0;
        } else if (this.newPosition > size) {
            this.newPosition = size;
        }
        return list.move(this.newPosition, this.oldPosition);
    }

    @Override
    public void affectIndices(InternalCDOFeatureDelta.ListTargetAdding[] source, int[] indices) {
        block9: {
            block8: {
                if (this.oldPosition >= this.newPosition) break block8;
                int i = 1;
                while (i <= indices[0]) {
                    if (this.oldPosition < indices[i] && indices[i] <= this.newPosition) {
                        int n = i;
                        indices[n] = indices[n] - 1;
                    } else if (indices[i] == this.oldPosition) {
                        indices[i] = this.newPosition;
                    }
                    ++i;
                }
                break block9;
            }
            if (this.newPosition >= this.oldPosition) break block9;
            int i = 1;
            while (i <= indices[0]) {
                if (this.newPosition <= indices[i] && indices[i] < this.oldPosition) {
                    int n = i;
                    indices[n] = indices[n] + 1;
                } else if (indices[i] == this.oldPosition) {
                    indices[i] = this.newPosition;
                }
                ++i;
            }
        }
    }

    public static void main(String[] args) {
        EReference feature = EcorePackage.Literals.EPACKAGE__ECLASSIFIERS;
        ArrayList<CDOFeatureDelta> deltas = new ArrayList<CDOFeatureDelta>();
        deltas.add(new CDOMoveFeatureDeltaImpl((EStructuralFeature)feature, 7, 1));
        int i = 0;
        while (i < 10) {
            CDOMoveFeatureDeltaImpl.projectIndex(deltas, i);
            ++i;
        }
    }

    private static void projectIndex(List<CDOFeatureDelta> deltas, int index) {
        for (CDOFeatureDelta delta : deltas) {
            if (!(delta instanceof InternalCDOFeatureDelta.ListIndexAffecting)) continue;
            index = ((InternalCDOFeatureDelta.ListIndexAffecting)((Object)delta)).projectIndex(index);
        }
        System.out.println(index);
    }

    @Override
    public int projectIndex(int index) {
        if (this.oldPosition < this.newPosition) {
            if (this.oldPosition <= index && index < this.newPosition) {
                ++index;
            } else if (index == this.newPosition) {
                index = this.oldPosition;
            }
        } else if (this.newPosition < index && index <= this.oldPosition) {
            --index;
        } else if (index == this.newPosition) {
            index = this.oldPosition;
        }
        return index;
    }

    @Override
    public void accept(CDOFeatureDeltaVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void adjustAfterAddition(int index) {
        if (index <= this.oldPosition) {
            ++this.oldPosition;
        }
        if (index <= this.newPosition) {
            ++this.newPosition;
        }
    }

    @Override
    public void adjustAfterRemoval(int index) {
        if (index < this.oldPosition && this.oldPosition > 0) {
            --this.oldPosition;
        }
        if (this.oldPosition < this.newPosition) {
            --index;
        }
        if (index < this.newPosition && this.newPosition > 0) {
            --this.newPosition;
        }
    }

    @Override
    public void adjustAfterMove(int oldPosition, int newPosition) {
        if (this.oldPosition == oldPosition) {
            this.oldPosition = newPosition;
        } else {
            this.adjustAfterRemoval(oldPosition);
            this.adjustAfterAddition(newPosition);
        }
    }

    @Override
    public boolean adjustReferences(CDOReferenceAdjuster adjuster) {
        return false;
    }

    @Override
    public boolean isStructurallyEqual(Object obj) {
        if (!super.isStructurallyEqual(obj)) {
            return false;
        }
        CDOMoveFeatureDelta that = (CDOMoveFeatureDelta)obj;
        return this.oldPosition == that.getOldPosition() && this.newPosition == that.getNewPosition();
    }

    @Override
    protected String toStringAdditional() {
        return MessageFormat.format("from={0}, to={1}, value={2}", this.oldPosition, this.newPosition, this.value);
    }
}

