/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder;

import org.eclipse.datatools.modelbase.sql.query.QueryStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryValueExpression;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCase;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCaseSearch;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCaseSimple;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCast;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionColumn;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCombined;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionDefaultValue;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionFunction;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionNullValue;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionScalarSelect;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionSimple;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.SQLBuilderPlugin;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.MainExpressionPage;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.caseexpr.CaseOptionsPage;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.caseexpr.CaseSearchPage;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.caseexpr.CaseSimplePage;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.cast.CastBuilderPage;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.constant.ConstantOptionsPage;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.constant.NumericConstantBuilderPage;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.constant.StringConstantBuilderPage;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.function.FunctionBuilderPage;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.multiexpr.ExpressionsByOperatorsPage;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.subquery.SubQueryPage;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.datatools.sqltools.sqlbuilder.util.StringUtility;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class ExpressionBuilderWizard
extends Wizard
implements INewWizard {
    protected MainExpressionPage mainExpressionPage;
    protected CaseOptionsPage caseOptionsPage;
    protected CaseSearchPage caseSearchPage;
    protected CaseSimplePage caseSimplePage;
    protected CastBuilderPage castBuilderPage;
    protected ConstantOptionsPage constantOptionsPage;
    protected NumericConstantBuilderPage numericConstantBuilderPage;
    protected StringConstantBuilderPage stringConstantBuilderPage;
    protected FunctionBuilderPage functionBuilderPage;
    protected SubQueryPage subQueryPage;
    protected ExpressionsByOperatorsPage expressionsByOperatorsPage;
    private SQLDomainModel domainModel;
    private SQLQueryObject sqlStatement;
    private QueryValueExpression inputSQLExpression;
    private QueryValueExpression updatedSQLExpression;
    public static String MAINEXPRESSIONPAGE = "Main Expression Page";
    public static String CASEOPTIONSPAGE = "CASE Options Page";
    public static String CASEBUILDERPAGE = "CASE Builder Page";
    public static String CONSTANTOPTIONSPAGE = "Constant Options Page";
    public static String NUMERICCONSTANTBUILDERPAGE = "Numeric Constant Builder Page";
    public static String STRINGCONSTANTBUILDERPAGE = "String Constant Builder Page";
    public static String EXPRESSIONSBYOPERATORSPAGE = "Expression By Operators Page";
    public static String SUBQUERYPAGE = "SubQuery Page";
    public static String NUMERICCONSTANT = Messages._UI_NUMERIC_CONSTANT;
    private boolean isColumn;
    boolean isXMLFunction = false;

    public ExpressionBuilderWizard() {
        this.domainModel = null;
        this.sqlStatement = null;
        this.inputSQLExpression = null;
        this.isColumn = false;
        this.setWindowTitle(Messages._UI_WIZARD_MAIN_EXPRESSION_TITLE);
        this.setDefaultPageImageDescriptor(ImageDescriptor.createFromFile(((Object)((Object)SQLBuilderPlugin.getPlugin())).getClass(), (String)"icons/expressionbuilder_wiz.gif"));
    }

    public ExpressionBuilderWizard(SQLDomainModel domainModel) {
        this.domainModel = domainModel;
        this.sqlStatement = null;
        this.inputSQLExpression = null;
        this.isColumn = false;
        this.setWindowTitle(Messages._UI_WIZARD_MAIN_EXPRESSION_TITLE);
        this.setDefaultPageImageDescriptor(ImageDescriptor.createFromFile(((Object)((Object)SQLBuilderPlugin.getPlugin())).getClass(), (String)"icons/expressionbuilder_wiz.gif"));
    }

    public ExpressionBuilderWizard(SQLDomainModel domainModel, SQLQueryObject sqlStatementArg) {
        this.domainModel = domainModel;
        this.sqlStatement = sqlStatementArg;
        this.inputSQLExpression = null;
        this.isColumn = false;
        this.setWindowTitle(Messages._UI_WIZARD_MAIN_EXPRESSION_TITLE);
        this.setDefaultPageImageDescriptor(ImageDescriptor.createFromFile(((Object)((Object)SQLBuilderPlugin.getPlugin())).getClass(), (String)"icons/expressionbuilder_wiz.gif"));
    }

    public SQLDomainModel getDomainModel() {
        return this.domainModel;
    }

    public void setDomainModel(SQLDomainModel domainModel) {
        this.domainModel = domainModel;
    }

    public void setIsColumn(boolean isColumn) {
        this.isColumn = isColumn;
    }

    public void setSQLStatement(QueryStatement sqlStatementArg) {
        this.sqlStatement = sqlStatementArg;
    }

    public SQLQueryObject getSQLStatement() {
        return this.sqlStatement;
    }

    public void setInputExpression(QueryValueExpression in) {
        this.inputSQLExpression = in;
    }

    public QueryValueExpression getSQLExpression() {
        return this.updatedSQLExpression;
    }

    public void setIsXMLFunction(boolean isXMLFunction) {
        this.isXMLFunction = isXMLFunction;
    }

    public void setSQLExpression(QueryValueExpression sqlExpr) {
        this.updatedSQLExpression = sqlExpr;
    }

    public Wizard createSmartGuide() {
        return this;
    }

    public void addPages() {
        if (this.inputSQLExpression == null || this.inputSQLExpression instanceof ValueExpressionNullValue || this.inputSQLExpression instanceof ValueExpressionDefaultValue) {
            this.addAllPages();
        } else if (this.inputSQLExpression != null && this.inputSQLExpression instanceof ValueExpressionFunction) {
            this.functionBuilderPage = new FunctionBuilderPage(this.domainModel, this.sqlStatement, (ValueExpressionFunction)this.inputSQLExpression, this.isColumn);
            this.addPage((IWizardPage)this.functionBuilderPage);
        } else if (this.inputSQLExpression != null && this.inputSQLExpression instanceof ValueExpressionCast) {
            this.castBuilderPage = new CastBuilderPage(this.domainModel, this.sqlStatement, this.inputSQLExpression);
            this.addPage((IWizardPage)this.castBuilderPage);
        } else if (this.inputSQLExpression != null && this.inputSQLExpression instanceof ValueExpressionSimple) {
            if (this.inputSQLExpression.toString().equals("*") || this.inputSQLExpression.toString().toUpperCase().equals("NULL") || this.inputSQLExpression.toString().toUpperCase().equals("NOT NULL") || this.inputSQLExpression.toString().toUpperCase().equals("DEFAULT") || this.inputSQLExpression.toString().equals("")) {
                this.addAllPages();
            } else if (StringUtility.lastIndexOfAnyBut(this.inputSQLExpression.getSQL(), NUMERICCONSTANT) == -1 && !this.inputSQLExpression.getSQL().equals("")) {
                this.numericConstantBuilderPage = new NumericConstantBuilderPage(this.sqlStatement, this.inputSQLExpression);
                this.addPage((IWizardPage)this.numericConstantBuilderPage);
            } else {
                this.stringConstantBuilderPage = new StringConstantBuilderPage(this.sqlStatement, this.inputSQLExpression, this.domainModel);
                this.stringConstantBuilderPage.setIsXMLFunction(this.isXMLFunction);
                this.addPage((IWizardPage)this.stringConstantBuilderPage);
            }
        } else if (this.inputSQLExpression != null && (this.inputSQLExpression instanceof ValueExpressionCombined || this.inputSQLExpression instanceof ValueExpressionColumn)) {
            this.expressionsByOperatorsPage = new ExpressionsByOperatorsPage(this.domainModel, this.sqlStatement, this.inputSQLExpression);
            this.addPage((IWizardPage)this.expressionsByOperatorsPage);
        } else if (this.inputSQLExpression != null && this.inputSQLExpression instanceof ValueExpressionCase) {
            if (this.inputSQLExpression instanceof ValueExpressionCaseSearch) {
                this.caseSearchPage = new CaseSearchPage(this.domainModel, this.sqlStatement, this.inputSQLExpression);
                this.addPage((IWizardPage)this.caseSearchPage);
            } else if (this.inputSQLExpression instanceof ValueExpressionCaseSimple) {
                this.caseSimplePage = new CaseSimplePage(this.domainModel, this.sqlStatement, this.inputSQLExpression);
                this.addPage((IWizardPage)this.caseSimplePage);
            }
        } else if (this.inputSQLExpression != null && this.inputSQLExpression instanceof ValueExpressionScalarSelect) {
            this.subQueryPage = new SubQueryPage(this.domainModel, this.inputSQLExpression);
            this.addPage((IWizardPage)this.subQueryPage);
        }
    }

    private void addAllPages() {
        this.mainExpressionPage = new MainExpressionPage(this.domainModel, this.inputSQLExpression);
        this.addPage((IWizardPage)this.mainExpressionPage);
        this.functionBuilderPage = new FunctionBuilderPage(this.domainModel, this.sqlStatement, null, this.isColumn);
        this.addPage((IWizardPage)this.functionBuilderPage);
        this.castBuilderPage = new CastBuilderPage(this.domainModel, this.sqlStatement, null);
        this.addPage((IWizardPage)this.castBuilderPage);
        this.expressionsByOperatorsPage = new ExpressionsByOperatorsPage(this.domainModel, this.sqlStatement, null);
        this.addPage((IWizardPage)this.expressionsByOperatorsPage);
        this.constantOptionsPage = new ConstantOptionsPage(this.sqlStatement, null);
        this.stringConstantBuilderPage = new StringConstantBuilderPage(this.sqlStatement, null, this.domainModel);
        this.numericConstantBuilderPage = new NumericConstantBuilderPage(this.sqlStatement, null);
        this.addPage((IWizardPage)this.constantOptionsPage);
        this.addPage((IWizardPage)this.numericConstantBuilderPage);
        this.addPage((IWizardPage)this.stringConstantBuilderPage);
        this.subQueryPage = new SubQueryPage(this.domainModel, null);
        this.addPage((IWizardPage)this.subQueryPage);
        this.caseOptionsPage = new CaseOptionsPage(this.sqlStatement, null);
        this.caseSearchPage = new CaseSearchPage(this.domainModel, this.sqlStatement, null);
        this.caseSimplePage = new CaseSimplePage(this.domainModel, this.sqlStatement, null);
        this.addPage((IWizardPage)this.caseOptionsPage);
        this.addPage((IWizardPage)this.caseSearchPage);
        this.addPage((IWizardPage)this.caseSimplePage);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public boolean performFinish() {
        boolean rc = true;
        if (this.functionBuilderPage != null && this.functionBuilderPage.currentPage()) {
            rc = this.functionBuilderPage.performOk();
        }
        if (this.castBuilderPage != null && this.castBuilderPage.currentPage()) {
            rc = this.castBuilderPage.performOk();
        }
        if (this.stringConstantBuilderPage != null && this.stringConstantBuilderPage.currentPage()) {
            rc = this.stringConstantBuilderPage.performOk();
        }
        if (this.numericConstantBuilderPage != null && this.numericConstantBuilderPage.currentPage()) {
            rc = this.numericConstantBuilderPage.performOk();
        }
        if (this.caseSearchPage != null && this.caseSearchPage.currentPage()) {
            rc = this.caseSearchPage.performOk();
        }
        if (this.caseSimplePage != null && this.caseSimplePage.currentPage()) {
            rc = this.caseSimplePage.performOk();
        }
        if (this.expressionsByOperatorsPage != null && this.expressionsByOperatorsPage.currentPage()) {
            rc = this.expressionsByOperatorsPage.performOk();
        }
        if (this.subQueryPage != null && this.subQueryPage.currentPage()) {
            rc = this.subQueryPage.performOk();
        }
        return rc;
    }

    public void setAllPagesComplete(boolean bstate) {
        if (this.functionBuilderPage != null) {
            this.functionBuilderPage.setPageComplete(bstate);
        }
        if (this.castBuilderPage != null) {
            this.castBuilderPage.setPageComplete(bstate);
        }
        if (this.constantOptionsPage != null) {
            this.constantOptionsPage.setPageComplete(bstate);
        }
        if (this.stringConstantBuilderPage != null) {
            this.stringConstantBuilderPage.setPageComplete(bstate);
        }
        if (this.numericConstantBuilderPage != null) {
            this.numericConstantBuilderPage.setPageComplete(bstate);
        }
        if (this.caseOptionsPage != null) {
            this.caseOptionsPage.setPageComplete(bstate);
        }
        if (this.caseSearchPage != null) {
            this.caseSearchPage.setPageComplete(bstate);
        }
        if (this.caseSimplePage != null) {
            this.caseSimplePage.setPageComplete(bstate);
        }
        if (this.mainExpressionPage != null) {
            this.mainExpressionPage.setPageComplete(bstate);
        }
        if (this.expressionsByOperatorsPage != null) {
            this.expressionsByOperatorsPage.setPageComplete(bstate);
        }
        if (this.subQueryPage != null) {
            this.subQueryPage.setPageComplete(bstate);
        }
    }

    public IWizardPage getNextPage(IWizardPage currentPage) {
        WizardPage nextPage = null;
        if (currentPage instanceof MainExpressionPage) {
            String type = ((MainExpressionPage)currentPage).getExpressionType();
            if (type.equals("CASE")) {
                nextPage = this.caseOptionsPage;
            } else if (type.equals("CAST")) {
                nextPage = this.castBuilderPage;
            } else if (type.equals("Function")) {
                nextPage = this.functionBuilderPage;
            } else if (type.equals("Constant")) {
                nextPage = this.constantOptionsPage;
            } else if (type.equals("SUBQUERY")) {
                nextPage = this.subQueryPage;
            } else if (type.equals("Expressions by operators")) {
                nextPage = this.expressionsByOperatorsPage;
            } else {
                return null;
            }
            return nextPage;
        }
        if (currentPage instanceof CaseOptionsPage) {
            Object type = ((CaseOptionsPage)currentPage).getCaseType();
            if (type.equals(CaseOptionsPage.CASE_SEARCH_WHEN_CLAUSE)) {
                nextPage = this.caseSearchPage;
            } else if (type.equals(CaseOptionsPage.CASE_SIMPLE_WHEN_CLAUSE)) {
                nextPage = this.caseSimplePage;
            } else {
                return null;
            }
            return nextPage;
        }
        if (currentPage instanceof ConstantOptionsPage) {
            Object type = ((ConstantOptionsPage)currentPage).getConstantType();
            if (type.equals(ConstantOptionsPage.NUMERIC_CONSTANT)) {
                nextPage = this.numericConstantBuilderPage;
            } else if (type.equals(ConstantOptionsPage.STRING_CONSTANT)) {
                nextPage = this.stringConstantBuilderPage;
            } else {
                return null;
            }
            return nextPage;
        }
        return null;
    }
}

