/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.ui.editors.automake;

import org.eclipse.cdt.internal.autotools.ui.editors.automake.AutomakeCompletionProcessor;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.AutomakeEditor;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.AutomakeTextHover;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.AutomakefileCodeScanner;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.AutomakefilePresentationReconciler;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.AutomakefileReconcilingStrategy;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.MakefileSourceConfiguration;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IEditorPart;

public class AutomakefileSourceConfiguration
extends MakefileSourceConfiguration {
    AutomakeEditor editor;
    AutomakefileCodeScanner codeScanner;
    AutomakeTextHover amHover;

    public AutomakefileSourceConfiguration(IPreferenceStore preferenceStore) {
        super(preferenceStore, null);
    }

    public AutomakefileSourceConfiguration(IPreferenceStore preferenceStore, AutomakeEditor editor) {
        super(preferenceStore, editor);
        this.editor = editor;
    }

    public AutomakefileCodeScanner getAutomakeCodeScanner() {
        if (this.codeScanner == null) {
            this.codeScanner = new AutomakefileCodeScanner();
        }
        return this.codeScanner;
    }

    @Override
    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        if (this.amHover == null) {
            this.amHover = new AutomakeTextHover(this.editor);
        }
        return this.amHover;
    }

    @Override
    public void adaptToPreferenceChange(PropertyChangeEvent event) {
        AutomakefileCodeScanner scanner = this.getAutomakeCodeScanner();
        scanner.adaptToPreferenceChange(event);
    }

    @Override
    public boolean affectsBehavior(PropertyChangeEvent event) {
        AutomakefileCodeScanner scanner = this.getAutomakeCodeScanner();
        return scanner.affectsBehavior(event);
    }

    @Override
    public IPresentationReconciler getPresentationReconciler(ISourceViewer v) {
        return new AutomakefilePresentationReconciler();
    }

    @Override
    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        if (this.editor != null && this.editor.isEditable()) {
            MonoReconciler reconciler = new MonoReconciler((IReconcilingStrategy)new AutomakefileReconcilingStrategy(this.editor), false);
            reconciler.setDelay(1000);
            reconciler.setProgressMonitor((IProgressMonitor)new NullProgressMonitor());
            return reconciler;
        }
        return null;
    }

    @Override
    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        assistant.setContentAssistProcessor((IContentAssistProcessor)new AutomakeCompletionProcessor((IEditorPart)this.editor), "__dftl_partition_content_type");
        assistant.setContentAssistProcessor((IContentAssistProcessor)new AutomakeCompletionProcessor((IEditorPart)this.editor), "makefile_comment");
        assistant.setContentAssistProcessor((IContentAssistProcessor)new AutomakeCompletionProcessor((IEditorPart)this.editor), "makefile_def_block");
        assistant.setContentAssistProcessor((IContentAssistProcessor)new AutomakeCompletionProcessor((IEditorPart)this.editor), "makefile_if_block");
        assistant.setContentAssistProcessor((IContentAssistProcessor)new AutomakeCompletionProcessor((IEditorPart)this.editor), "makefile_include_block");
        assistant.setContentAssistProcessor((IContentAssistProcessor)new AutomakeCompletionProcessor((IEditorPart)this.editor), "makefile_macro_assignement");
        assistant.enableAutoActivation(true);
        assistant.setAutoActivationDelay(500);
        assistant.setProposalPopupOrientation(21);
        assistant.setContextInformationPopupOrientation(21);
        return assistant;
    }
}

