/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.model;

import java.util.Map;
import org.apache.commons.collections4.map.AbstractReferenceMap;
import org.apache.commons.collections4.map.ReferenceMap;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.utils.check.Assert;

public final class ObjectInfoUtils {
    private static long m_lastObjectInfoID = 0L;
    private static Map<String, ObjectInfo> m_idToObjectInfo = new ReferenceMap(AbstractReferenceMap.ReferenceStrength.HARD, AbstractReferenceMap.ReferenceStrength.WEAK);
    private static Map<ObjectInfo, String> m_objectInfoToId = new ReferenceMap(AbstractReferenceMap.ReferenceStrength.WEAK, AbstractReferenceMap.ReferenceStrength.HARD);

    private ObjectInfoUtils() {
    }

    public static ObjectInfo getById(String id) {
        ObjectInfo result = m_idToObjectInfo.get(id);
        Assert.isNotNull(result, "Can not find ObjectInfo for %s", id);
        return result;
    }

    public static String getId(ObjectInfo objectInfo) {
        String id = ObjectInfoUtils.getId0(objectInfo);
        Assert.isNotNull(id, "No ID for (%s) %s", objectInfo.getClass().getName(), objectInfo);
        return id;
    }

    public static void setNewId(ObjectInfo objectInfo) {
        String existingID = ObjectInfoUtils.getId0(objectInfo);
        Assert.isNull(existingID, "%s already has ID %s", objectInfo, existingID);
        ObjectInfoUtils.setId0(objectInfo, Long.toString(m_lastObjectInfoID++));
    }

    private static String getId0(ObjectInfo objectInfo) {
        return m_objectInfoToId.get(objectInfo);
    }

    private static void setId0(ObjectInfo objectInfo, String id) {
        m_objectInfoToId.put(objectInfo, id);
        m_idToObjectInfo.put(id, objectInfo);
    }
}

