/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.base.ui;

import org.apache.log4j.Logger;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.annotation.NonNull;

public class OCLProjectHelper {
    public static final @NonNull String NATURE_ID = "org.eclipse.ocl.pivot.ui.oclnature";
    public static final @NonNull String BUILDER_ID = "org.eclipse.ocl.pivot.ui.oclbuilder";
    private static final Logger log = Logger.getLogger(OCLProjectHelper.class);

    public static boolean hasNature(IProject project) {
        try {
            if (project.isAccessible()) {
                return project.hasNature(NATURE_ID);
            }
        }
        catch (CoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasBuilder(IProject project) {
        if (!project.isAccessible()) return false;
        try {
            ICommand[] iCommandArray = project.getDescription().getBuildSpec();
            int n = iCommandArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                ICommand command = iCommandArray[n2];
                if (BUILDER_ID.equals(command.getBuilderName())) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            log.error((Object)"Can't build due to an exception.", (Throwable)e);
        }
        return false;
    }
}

