/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.impactanalyzer.instanceScope;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.ecore.opposites.OppositeEndFinder;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.AbstractNavigationStep;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.NavigationStep;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.TracebackCache;
import org.eclipse.ocl.examples.impactanalyzer.util.AnnotatedEObject;
import org.eclipse.ocl.examples.impactanalyzer.util.SemanticIdentity;

public class OppositePropertyNavigationStep
extends AbstractNavigationStep {
    private final EStructuralFeature property;
    private final OppositeEndFinder oppositeEndFinder;
    private final SemanticIdentity semanticIdentity;

    public OppositePropertyNavigationStep(EClass sourceType, EClass targetType, EStructuralFeature property, OCLExpression debugInfo, OppositeEndFinder oppositeEndFinder) {
        super(sourceType, targetType, debugInfo);
        this.property = property;
        this.oppositeEndFinder = oppositeEndFinder;
        this.semanticIdentity = new OppositePropertyNavigationStepIdentity();
    }

    public SemanticIdentity getSemanticIdentityOfSuper() {
        return super.getSemanticIdentity();
    }

    @Override
    protected Set<AnnotatedEObject> navigate(AnnotatedEObject fromObject, TracebackCache cache, Notification changeEvent) {
        HashSet<EObject> result = new HashSet<EObject>();
        HashSet<AnnotatedEObject> returnValue = new HashSet<AnnotatedEObject>();
        if (this.property instanceof EReference) {
            Collection navigationResult = this.oppositeEndFinder.navigateOppositePropertyWithBackwardScope((EReference)this.property, fromObject.getAnnotatedObject());
            if (navigationResult instanceof Collection) {
                Collection eObjectCollectionNavigationResult = navigationResult;
                result.addAll(eObjectCollectionNavigationResult);
            } else if (navigationResult != null) {
                result.add((EObject)navigationResult);
            }
        }
        for (EObject o : result) {
            returnValue.add(this.annotateEObject(fromObject, o));
        }
        return returnValue;
    }

    @Override
    public String contentToString(Map<NavigationStep, Integer> visited, int indent) {
        return "opposite of " + this.property.getName();
    }

    @Override
    public SemanticIdentity getSemanticIdentity() {
        return this.semanticIdentity;
    }

    private class OppositePropertyNavigationStepIdentity
    extends SemanticIdentity {
        private OppositePropertyNavigationStepIdentity() {
        }

        public OppositePropertyNavigationStep getNavigationStep() {
            return OppositePropertyNavigationStep.this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.hashCode() != o.hashCode()) {
                return false;
            }
            return OppositePropertyNavigationStep.this.getSemanticIdentityOfSuper().equals(o) && OppositePropertyNavigationStep.this.property.equals(((OppositePropertyNavigationStepIdentity)o).getNavigationStep().property);
        }

        @Override
        public int calculateHashCode() {
            return OppositePropertyNavigationStep.this.getSemanticIdentityOfSuper().hashCode() ^ OppositePropertyNavigationStep.this.property.hashCode();
        }

        @Override
        public NavigationStep getStep() {
            return this.getNavigationStep();
        }
    }
}

