/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.util.factory;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.internal.util.factory.FactoryDescriptor;
import org.eclipse.net4j.internal.util.factory.MarkupNames;
import org.eclipse.net4j.internal.util.factory.PluginFactoryRegistry;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.factory.AnnotationFactory;
import org.eclipse.net4j.util.factory.Factory;
import org.eclipse.net4j.util.factory.FactoryKey;
import org.eclipse.net4j.util.factory.IFactory;
import org.eclipse.net4j.util.factory.IFactoryKey;

public final class AnnotationFactoryDescriptor
extends Factory
implements PluginFactoryRegistry.IFactoryDescriptor,
MarkupNames {
    private final IConfigurationElement configurationElement;

    public AnnotationFactoryDescriptor(IConfigurationElement configurationElement) {
        super(AnnotationFactoryDescriptor.createFactoryKey(configurationElement));
        this.configurationElement = configurationElement;
    }

    @Override
    public IFactory createFactory() {
        Class<?> productClass;
        String bundleSymbolicName = this.configurationElement.getContributor().getName();
        String productClassName = this.configurationElement.getAttribute("productClass");
        try {
            productClass = OM.BUNDLE.loadClass(bundleSymbolicName, productClassName);
        }
        catch (ClassNotFoundException ex) {
            throw WrappedException.wrap(ex);
        }
        FactoryKey factoryKey = this.getKey();
        AnnotationFactory factory = new AnnotationFactory(productClass, factoryKey);
        FactoryDescriptor.adjustFactoryType(factory, this.getType());
        return factory;
    }

    private static IFactoryKey createFactoryKey(IConfigurationElement element) {
        String name = element.getName();
        if ("annotationFactory".equals(name)) {
            String productGroup = element.getAttribute("productGroup");
            String type = element.getAttribute("type");
            return new FactoryKey(productGroup, type);
        }
        throw new IllegalStateException("Wrong configuration element: " + name);
    }
}

