/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.metadata.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataModelContext;
import org.eclipse.jst.jsf.common.metadata.internal.ModelKeyDescriptor;

public class MetaDataModelContext
implements IMetaDataModelContext {
    private final IProject _project;
    private final String _domainId;
    private final String _modelId;

    public MetaDataModelContext(IProject project, String domainId, String modelId) {
        this._project = project;
        this._domainId = domainId;
        this._modelId = this.fixJSPURIIfNecessary(modelId);
    }

    private String fixJSPURIIfNecessary(String tempuri) {
        if (tempuri != null && tempuri.equals("jsp11")) {
            return tempuri.toUpperCase();
        }
        return tempuri;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ModelKeyDescriptor.class) {
            return new ModelKeyDescriptor(this._project, this._domainId, this._modelId);
        }
        if (adapter == IProject.class) {
            return this._project;
        }
        return null;
    }

    @Override
    public String getDomainId() {
        return this._domainId;
    }

    @Override
    public String getModelIdentifier() {
        return this._modelId;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this._project != null) {
            buf.append(this._project.getName()).append(":");
        }
        buf.append(this.getDomainId()).append(":");
        buf.append(this.getModelIdentifier()).append(":");
        return buf.toString();
    }
}

