/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.internal.locator;

import java.util.Iterator;
import org.eclipse.jst.jsf.common.internal.locator.DefaultComposingLocatorDelegate;
import org.eclipse.jst.jsf.common.internal.locator.ILocator;
import org.eclipse.jst.jsf.common.internal.locator.ILocatorChangeListener;
import org.eclipse.jst.jsf.common.internal.policy.IIteratorPolicy;
import org.eclipse.jst.jsf.common.internal.strategy.IteratorPolicyBasedStrategyComposite;
import org.eclipse.jst.jsf.common.internal.strategy.StrategyComposite;

public abstract class CompositeLocator<LOCATORTYPE, COMPOSITETYPE, CONTEXTTYPE, IDTYPE>
extends IteratorPolicyBasedStrategyComposite<CONTEXTTYPE, LOCATORTYPE, COMPOSITETYPE, IDTYPE, ILocator<LOCATORTYPE, CONTEXTTYPE, IDTYPE>>
implements ILocator<COMPOSITETYPE, CONTEXTTYPE, IDTYPE>,
ILocatorChangeListener {
    private DefaultComposingLocatorDelegate<LOCATORTYPE, COMPOSITETYPE, CONTEXTTYPE, IDTYPE> _delegate;
    private final COMPOSITETYPE _noResultValue;

    public CompositeLocator(IDTYPE id, String displayName, IIteratorPolicy<IDTYPE> policy, COMPOSITETYPE noResultValue, StrategyComposite.DefaultCompositionStrategy<CONTEXTTYPE, LOCATORTYPE, COMPOSITETYPE, ILocator<LOCATORTYPE, CONTEXTTYPE, IDTYPE>> compositionStrategy) {
        super(policy, compositionStrategy);
        this._delegate = new DefaultComposingLocatorDelegate<LOCATORTYPE, COMPOSITETYPE, CONTEXTTYPE, IDTYPE>(id, displayName){

            @Override
            protected COMPOSITETYPE doLocate(CONTEXTTYPE context) {
                return CompositeLocator.this.doLocate(context);
            }
        };
        this._noResultValue = noResultValue;
    }

    protected abstract COMPOSITETYPE doLocate(CONTEXTTYPE var1);

    @Override
    public final IDTYPE getId() {
        return this._delegate.getId();
    }

    @Override
    public String getDisplayName() {
        return this._delegate.getDisplayName();
    }

    @Override
    public void start(CONTEXTTYPE initialContext) {
        if (this.canStart()) {
            Iterator iterator = this.getIterator();
            while (iterator.hasNext()) {
                ILocator next = (ILocator)iterator.next();
                next.addListener(this);
                next.start(initialContext);
            }
            this._delegate.start(initialContext);
        }
        throw new IllegalStateException("canStart must be called before calling start");
    }

    @Override
    public boolean canStart() {
        boolean canStart = true;
        Iterator iterator = this.getIterator();
        while (canStart && iterator.hasNext()) {
            canStart &= ((ILocator)iterator.next()).canStart();
        }
        return canStart && this._delegate.canStart();
    }

    @Override
    public boolean isStarted() {
        return this._delegate.isStarted();
    }

    @Override
    public void stop() {
        if (!this.isStarted()) {
            Iterator iterator = this.getIterator();
            while (iterator.hasNext()) {
                ILocator next = (ILocator)iterator.next();
                next.removeListener(this);
                next.stop();
            }
            this._delegate.stop();
        }
    }

    @Override
    public COMPOSITETYPE locate(CONTEXTTYPE context) {
        return (COMPOSITETYPE)this._delegate.locate(context);
    }

    @Override
    public COMPOSITETYPE getNoResult() {
        return this._noResultValue;
    }

    @Override
    public void changed(ILocatorChangeListener.LocatorChangeEvent event) {
        this._delegate.fireChangeEvent(event);
    }

    @Override
    public void addListener(ILocatorChangeListener listener) {
        this._delegate.addListener(listener);
    }

    @Override
    public void removeListener(ILocatorChangeListener listener) {
        this._delegate.removeListener(listener);
    }

    protected void fireChangeEvent(ILocatorChangeListener.LocatorChangeEvent event) {
        this._delegate.fireChangeEvent(event);
    }
}

