/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.ui.internal.utils;

import java.util.Arrays;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.jst.jsf.common.ui.JSFUICommonPlugin;
import org.eclipse.jst.jsf.common.ui.internal.utils.WorkspaceUtil;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class WebrootUtil {
    public static String getWebPath(IPath path) {
        Object strWebrootPath = "";
        IProject project = WorkspaceUtil.getProjectFor(path);
        IPath webContentPath = WebrootUtil.getWebContentPath(project);
        if (webContentPath != null && webContentPath.isPrefixOf(path)) {
            int start = path.matchingFirstSegments(webContentPath);
            String[] segments = path.segments();
            int i = start;
            int n = path.segmentCount();
            while (i < n) {
                strWebrootPath = (String)strWebrootPath + "/" + segments[i];
                ++i;
            }
        }
        return strWebrootPath;
    }

    public static boolean isUnderWebContentFolder(IResource resource) {
        IPath webContentPath = WebrootUtil.getWebContentPath(resource.getProject());
        if (webContentPath != null) {
            return webContentPath.isPrefixOf(resource.getFullPath());
        }
        return true;
    }

    public static IPath getWebContentPath(IProject project) {
        IContainer underlyingFolder;
        IVirtualFolder rootFolder;
        IVirtualComponent component;
        if (project != null && (component = ComponentCore.createComponent((IProject)project)) != null && (rootFolder = component.getRootFolder()) != null && (underlyingFolder = rootFolder.getUnderlyingFolder()) != null) {
            return underlyingFolder.getFullPath();
        }
        return null;
    }

    public static String getWebContentFolderName(IProject project) {
        IPath webContentPath = WebrootUtil.getWebContentPath(project);
        if (webContentPath != null) {
            return webContentPath.lastSegment();
        }
        return null;
    }

    public static IFolder getWebContentFolder(IProject project) {
        IPath webContentPath = WebrootUtil.getWebContentPath(project);
        IFolder folder = null;
        if (webContentPath != null) {
            folder = project.getFolder(webContentPath.removeFirstSegments(1));
        }
        return folder;
    }

    public static IContainer getWebContentContainer(IProject project) {
        Object container = null;
        IPath webContentPath = WebrootUtil.getWebContentPath(project);
        if (webContentPath != null) {
            container = webContentPath.segmentCount() > 1 ? project.getFolder(webContentPath.removeFirstSegments(1)) : project;
        }
        return container;
    }

    public static IContainer[] getWebContentContainers(IProject project) {
        IVirtualFolder rootFolder;
        IVirtualComponent component;
        IContainer[] containers = null;
        if (project != null && (component = ComponentCore.createComponent((IProject)project)) != null && (rootFolder = component.getRootFolder()) != null) {
            containers = rootFolder.getUnderlyingFolders();
        }
        return containers;
    }

    public static int getWebContentFolderDepth(IProject project) {
        IPath webContentPath;
        if (project != null && (webContentPath = WebrootUtil.getWebContentPath(project)) != null) {
            return webContentPath.segmentCount();
        }
        return 2;
    }

    public static boolean isValidWebFile(IPath path) {
        String[] jspExtensions = WebrootUtil.getJSPFileExtensions();
        String extension = path.getFileExtension();
        return extension != null && Arrays.asList(jspExtensions).contains(extension);
    }

    public static String getWebPath(String strPath) {
        String strWebrootPath = "";
        if (strPath != null) {
            Path path = new Path(strPath);
            return WebrootUtil.getWebPath((IPath)path);
        }
        return strWebrootPath;
    }

    public static String getPageNameFromWebPath(String strWebPath) {
        String pageName = strWebPath;
        if (pageName.startsWith("/")) {
            pageName = pageName.substring(1);
        }
        String[] jspExtensions = WebrootUtil.getJSPFileExtensions();
        int i = 0;
        int n = jspExtensions.length;
        while (i < n) {
            String extension = "." + jspExtensions[i];
            if (pageName.endsWith(extension)) {
                pageName = pageName.substring(0, pageName.length() - extension.length());
                break;
            }
            ++i;
        }
        return pageName;
    }

    public static String[] getJSPFileExtensions() {
        IContentTypeManager typeManager = Platform.getContentTypeManager();
        IContentType jspContentType = typeManager.getContentType("org.eclipse.jst.jsp.core.jspsource");
        if (jspContentType != null) {
            return jspContentType.getFileSpecs(8);
        }
        return null;
    }

    public static boolean isValidWebProject(IProject project) {
        boolean isValid;
        block4: {
            isValid = false;
            if (project != null && project.isAccessible()) {
                try {
                    IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                    if (facetedProject == null) break block4;
                    Set projectFacets = facetedProject.getProjectFacets();
                    for (IProjectFacetVersion projectFacetVersion : projectFacets) {
                        IProjectFacet projectFacet = projectFacetVersion.getProjectFacet();
                        if (!"jst.web".equals(projectFacet.getId())) continue;
                        isValid = true;
                        break;
                    }
                }
                catch (CoreException ce) {
                    JSFUICommonPlugin.getLogger(WebrootUtil.class).error("checking web project", ce);
                }
            }
        }
        return isValid;
    }
}

