/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.EdgeList;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.gmf.runtime.draw2d.ui.graph.BorderNode;
import org.eclipse.gmf.runtime.draw2d.ui.graph.ConstantSizeNode;
import org.eclipse.gmf.runtime.draw2d.ui.graph.ConstrainedEdge;
import org.eclipse.gmf.runtime.draw2d.ui.graph.GraphUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.graph.JointEdges;

class EdgeEndPointsAssignment {
    private DirectedGraph graph;

    public EdgeEndPointsAssignment(DirectedGraph g) {
        this.graph = g;
    }

    void assignEdgesEndPoints() {
        int i = 0;
        while (i < this.graph.edges.size()) {
            Edge e = this.graph.edges.getEdge(i);
            e.start = null;
            e.end = null;
            ++i;
        }
        Collections.sort(this.graph.nodes, new Comparator<Node>(){

            @Override
            public int compare(Node arg0, Node arg1) {
                return arg0.width - arg1.width;
            }
        });
        i = 0;
        while (i < this.graph.nodes.size()) {
            Node node = this.graph.nodes.getNode(i);
            this.assignEndPointsForEdgesFromNode(node);
            ++i;
        }
    }

    private void assignEndPointsForEdgesFromNode(Node node) {
        int i;
        EdgeList incoming = new EdgeList();
        EdgeList outgoing = new EdgeList();
        ArrayList<BorderNode> specialBorderNodes = new ArrayList<BorderNode>();
        if (node instanceof ConstantSizeNode) {
            this.initEdgesSets((ConstantSizeNode)node, incoming, outgoing, specialBorderNodes);
        } else {
            incoming = node.incoming;
            outgoing = node.outgoing;
        }
        if (node instanceof ConstantSizeNode && ((ConstantSizeNode)node).minIncomingPadding > 0) {
            this.assignEdgesEndPoints(incoming, (ConstantSizeNode)node, true);
        } else {
            i = 0;
            while (i < incoming.size()) {
                this.setEndPoint(incoming.getEdge(i), new Point(node.x + node.getOffsetIncoming(), node.y));
                ++i;
            }
        }
        if (node instanceof ConstantSizeNode && ((ConstantSizeNode)node).minOutgoingPadding > 0) {
            this.assignEdgesEndPoints(outgoing, (ConstantSizeNode)node, false);
        } else {
            i = 0;
            while (i < outgoing.size()) {
                this.setStartPoint(outgoing.getEdge(i), new Point(node.x + node.getOffsetOutgoing(), node.y + node.height));
                ++i;
            }
        }
        if (node instanceof ConstantSizeNode) {
            this.assignEndPointsForJointEdgeWithIncomingAndOutgoingEdges((ConstantSizeNode)node, specialBorderNodes);
        }
    }

    private void initEdgesSets(ConstantSizeNode n, EdgeList incoming, EdgeList outgoing, List<BorderNode> specialBorderNodes) {
        ConstrainedEdge ce;
        Edge e;
        int i = 0;
        while (i < n.outgoing.size()) {
            block12: {
                block11: {
                    e = n.outgoing.getEdge(i);
                    if (!(e instanceof ConstrainedEdge)) break block11;
                    ce = (ConstrainedEdge)e;
                    if (ce.sourceConstraint != null) break block12;
                }
                outgoing.add((Object)e);
            }
            ++i;
        }
        i = 0;
        while (i < n.incoming.size()) {
            block14: {
                block13: {
                    e = n.incoming.getEdge(i);
                    if (!(e instanceof ConstrainedEdge)) break block13;
                    ce = (ConstrainedEdge)e;
                    if (ce.targetConstraint != null) break block14;
                }
                incoming.add((Object)e);
            }
            ++i;
        }
        for (BorderNode borderNode : n.borderNodes) {
            if (!(borderNode.incomingJointEdges.edges.isEmpty() ^ borderNode.outgoingJointEdges.edges.isEmpty())) {
                specialBorderNodes.add(borderNode);
                continue;
            }
            if (borderNode.incomingJointEdges.edges.isEmpty()) {
                outgoing.add((Object)borderNode.outgoingJointEdges);
                continue;
            }
            incoming.add((Object)borderNode.incomingJointEdges);
        }
        Collections.sort(incoming, new Comparator<Edge>(){

            @Override
            public int compare(Edge e1, Edge e2) {
                return GraphUtilities.getIncomingEdgeBendpointX(e1, EdgeEndPointsAssignment.this.graph) - GraphUtilities.getIncomingEdgeBendpointX(e2, EdgeEndPointsAssignment.this.graph);
            }
        });
        Collections.sort(outgoing, new Comparator<Edge>(){

            @Override
            public int compare(Edge e1, Edge e2) {
                return GraphUtilities.getOutogingEdgeBendpointX(e1, EdgeEndPointsAssignment.this.graph) - GraphUtilities.getOutogingEdgeBendpointX(e2, EdgeEndPointsAssignment.this.graph);
            }
        });
    }

    private void assignEdgesEndPoints(EdgeList edges, ConstantSizeNode n, boolean end) {
        int y;
        Edge e;
        int padding = end ? n.minIncomingPadding : n.minOutgoingPadding;
        int leftX = n.x;
        int rightX = n.x + n.width;
        int leftBendpointX = 0;
        int rightBendpointX = 0;
        int leftIndex = 0;
        while (leftIndex < edges.size()) {
            e = edges.getEdge(leftIndex);
            int n2 = leftBendpointX = end ? GraphUtilities.getIncomingEdgeBendpointX(e, this.graph) : GraphUtilities.getOutogingEdgeBendpointX(e, this.graph);
            if (leftX < leftBendpointX && leftBendpointX < rightX && (float)(leftBendpointX - leftX) / (float)(leftIndex + 1) >= (float)padding) break;
            ++leftIndex;
        }
        int rightIndex = edges.size() - 1;
        while (rightIndex >= leftIndex) {
            e = edges.getEdge(rightIndex);
            int n3 = rightBendpointX = end ? GraphUtilities.getIncomingEdgeBendpointX(e, this.graph) : GraphUtilities.getOutogingEdgeBendpointX(e, this.graph);
            if (leftX < rightBendpointX && rightBendpointX < rightX && (float)(rightX - rightBendpointX) / (float)(edges.size() - rightIndex) >= (float)padding) break;
            --rightIndex;
        }
        int n4 = y = end ? n.y : n.y + n.height;
        if (rightIndex >= leftIndex) {
            this.uniformlyPadEdges((List)edges, 0, leftIndex, new Point(leftX, y), new Point(leftBendpointX, y), end);
            this.uniformlyPadEdges((List)edges, rightIndex + 1, edges.size(), new Point(rightBendpointX, y), new Point(rightX, y), end);
            this.makeStraight(edges, leftIndex, rightIndex + 1, end);
        } else {
            this.uniformlyPadEdges((List)edges, 0, edges.size(), new Point(leftX, y), new Point(rightX, y), end);
        }
    }

    private void uniformlyPadEdges(List edges, int startIndex, int endIndex, Point startPoint, Point endPoint, boolean end) {
        Dimension diff = endPoint.getDifference(startPoint);
        int numPieces = endIndex - startIndex + 1;
        int i = startIndex;
        while (i < endIndex) {
            Edge e = (Edge)edges.get(i);
            float coefficient = (float)(i - startIndex + 1) / (float)numPieces;
            Point p = startPoint.getCopy().translate(diff.getCopy().scale((double)coefficient));
            if (end) {
                this.setEndPoint(e, p);
            } else {
                this.setStartPoint(e, p);
            }
            ++i;
        }
    }

    private void makeStraight(EdgeList edges, int startIndex, int endIndex, boolean end) {
        int i = startIndex;
        while (i < endIndex) {
            int y;
            Edge e = edges.getEdge(i);
            int n = y = end ? e.target.y : e.source.y + e.source.height;
            if (e instanceof ConstrainedEdge) {
                ConstrainedEdge ce = (ConstrainedEdge)e;
                if (end && ce.targetConstraint != null) {
                    y = ce.targetConstraint.y;
                } else if (!end && ce.sourceConstraint != null) {
                    y = ce.sourceConstraint.y + ce.sourceConstraint.height;
                }
            }
            if (end) {
                this.setEndPoint(e, new Point(GraphUtilities.getIncomingEdgeBendpointX(e, this.graph), y));
            } else {
                this.setStartPoint(e, new Point(GraphUtilities.getOutogingEdgeBendpointX(e, this.graph), y));
            }
            ++i;
        }
    }

    private void setStartPoint(Edge e, Point p) {
        if (e instanceof JointEdges) {
            JointEdges je = (JointEdges)e;
            je.getJoint().setPoint(p);
            this.assignEndPointsForEdgesFromBorderNode(je.getJoint());
        } else {
            if (p == null) {
                p = e instanceof ConstrainedEdge && ((ConstrainedEdge)e).sourceConstraint != null ? ((ConstrainedEdge)e).sourceConstraint.getEdgesDefaultEndPoint() : new Point(e.source.x + e.source.getOffsetOutgoing(), e.source.y + e.source.height);
            }
            e.start = p;
        }
    }

    private void setEndPoint(Edge e, Point p) {
        if (e instanceof JointEdges) {
            JointEdges je = (JointEdges)e;
            je.getJoint().setPoint(p);
            this.assignEndPointsForEdgesFromBorderNode(je.getJoint());
        } else {
            if (p == null) {
                p = e instanceof ConstrainedEdge && ((ConstrainedEdge)e).targetConstraint != null ? ((ConstrainedEdge)e).targetConstraint.getEdgesDefaultEndPoint() : new Point(e.target.x + e.target.getOffsetIncoming(), e.target.y);
            }
            e.end = p;
        }
    }

    private void assignEndPointsForJointEdgeWithIncomingAndOutgoingEdges(ConstantSizeNode node, List<BorderNode> specialBorderNodes) {
        Collections.sort(specialBorderNodes, new Comparator<BorderNode>(){

            @Override
            public int compare(BorderNode bn1, BorderNode bn2) {
                return bn1.incomingJointEdges.edges.size() + bn1.outgoingJointEdges.edges.size() - bn2.incomingJointEdges.edges.size() - bn2.outgoingJointEdges.edges.size();
            }
        });
        ArrayList<BorderNode> leftSideBorderNodes = new ArrayList<BorderNode>(specialBorderNodes.size() / 2 + 1);
        ArrayList<BorderNode> rightSideBorderNodes = new ArrayList<BorderNode>(specialBorderNodes.size() / 2 + 1);
        Iterator<BorderNode> itr = specialBorderNodes.iterator();
        while (itr.hasNext()) {
            leftSideBorderNodes.add(itr.next());
            itr.remove();
            if (!itr.hasNext()) continue;
            rightSideBorderNodes.add(itr.next());
            itr.remove();
        }
        Collections.sort(leftSideBorderNodes, new Comparator<BorderNode>(){

            @Override
            public int compare(BorderNode bn1, BorderNode bn2) {
                return bn1.outgoingJointEdges.edges.size() - bn1.incomingJointEdges.edges.size() - (bn2.outgoingJointEdges.edges.size() - bn2.incomingJointEdges.edges.size());
            }
        });
        Collections.sort(rightSideBorderNodes, new Comparator<BorderNode>(){

            @Override
            public int compare(BorderNode bn1, BorderNode bn2) {
                return bn1.outgoingJointEdges.edges.size() - bn1.incomingJointEdges.edges.size() - (bn2.outgoingJointEdges.edges.size() - bn2.incomingJointEdges.edges.size());
            }
        });
        this.uniformlyPadBorderNodes(leftSideBorderNodes, 0, leftSideBorderNodes.size(), new Point(node.x, node.y), new Point(node.x, node.y + node.height));
        this.uniformlyPadBorderNodes(rightSideBorderNodes, 0, rightSideBorderNodes.size(), new Point(node.x + node.width, node.y), new Point(node.x + node.width, node.y + node.height));
        for (BorderNode bn : leftSideBorderNodes) {
            if (bn.incomingJointEdges.edges.isEmpty() && bn.outgoingJointEdges.edges.isEmpty()) continue;
            this.assignEndPointsForEdgesFromBorderNode(bn);
        }
        for (BorderNode bn : rightSideBorderNodes) {
            if (bn.incomingJointEdges.edges.isEmpty() && bn.outgoingJointEdges.edges.isEmpty()) continue;
            this.assignEndPointsForEdgesFromBorderNode(bn);
        }
    }

    private void uniformlyPadBorderNodes(List<BorderNode> borderNodes, int startIndex, int endIndex, Point startPoint, Point endPoint) {
        Dimension diff = endPoint.getDifference(startPoint);
        int numPieces = endIndex - startIndex + 1;
        int i = startIndex;
        while (i < endIndex) {
            float coefficient = (float)(i - startIndex + 1) / (float)numPieces;
            Point p = startPoint.getCopy().translate(diff.getCopy().scale((double)coefficient));
            borderNodes.get(i).setPoint(p);
            ++i;
        }
    }

    private void assignEndPointsForEdgesFromBorderNode(BorderNode node) {
        Collections.sort(node.incomingJointEdges.edges, new Comparator<Edge>(){

            @Override
            public int compare(Edge e1, Edge e2) {
                return GraphUtilities.getIncomingEdgeBendpointX(e1, EdgeEndPointsAssignment.this.graph) - GraphUtilities.getIncomingEdgeBendpointX(e2, EdgeEndPointsAssignment.this.graph);
            }
        });
        Collections.sort(node.outgoingJointEdges.edges, new Comparator<Edge>(){

            @Override
            public int compare(Edge e1, Edge e2) {
                return GraphUtilities.getOutogingEdgeBendpointX(e1, EdgeEndPointsAssignment.this.graph) - GraphUtilities.getOutogingEdgeBendpointX(e2, EdgeEndPointsAssignment.this.graph);
            }
        });
        if (node.minIncomingPadding > 0 || node.minOutgoingPadding > 0) {
            if (node.position == 1) {
                this.assignEdgesEndPoints(node.incomingJointEdges.edges, node, true);
            } else if (node.position == 4) {
                this.assignEdgesEndPoints(node.outgoingJointEdges.edges, node, false);
            } else {
                Point outgoingEndPt;
                Point outgoingStartPt;
                Point incomingEndPt;
                Point incomingStartPt;
                if (node.position == 8) {
                    incomingStartPt = new Point(node.x, node.y + (node.incomingJointEdges.edges.size() + 1) * node.height / (node.incomingJointEdges.edges.size() + node.outgoingJointEdges.edges.size() + 1));
                    incomingEndPt = new Point(node.x, node.y);
                    outgoingStartPt = new Point(node.x, node.y + node.incomingJointEdges.edges.size() * node.height / (node.incomingJointEdges.edges.size() + node.outgoingJointEdges.edges.size() + 1));
                    outgoingEndPt = new Point(node.x, node.y + node.height);
                } else {
                    incomingStartPt = new Point(node.x + node.width, node.y);
                    incomingEndPt = new Point(node.x + node.width, node.y + (node.incomingJointEdges.edges.size() + 1) * node.height / (node.incomingJointEdges.edges.size() + node.outgoingJointEdges.edges.size() + 1));
                    outgoingStartPt = new Point(node.x + node.width, node.y + node.height);
                    outgoingEndPt = new Point(node.x + node.width, node.y + node.incomingJointEdges.edges.size() * node.height / (node.incomingJointEdges.edges.size() + node.outgoingJointEdges.edges.size() + 1));
                }
                this.uniformlyPadEdges((List)node.incomingJointEdges.edges, 0, node.incomingJointEdges.edges.size(), incomingStartPt, incomingEndPt, true);
                this.uniformlyPadEdges((List)node.outgoingJointEdges.edges, 0, node.outgoingJointEdges.edges.size(), outgoingStartPt, outgoingEndPt, false);
            }
        } else {
            Point defaultPt = node.getEdgesDefaultEndPoint();
            int i = 0;
            while (i < node.incomingJointEdges.edges.size()) {
                this.setEndPoint(node.incomingJointEdges.edges.getEdge(i), defaultPt);
                ++i;
            }
            i = 0;
            while (i < node.outgoingJointEdges.edges.size()) {
                this.setStartPoint(node.outgoingJointEdges.edges.getEdge(i), defaultPt);
                ++i;
            }
        }
    }
}

