/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.build.gcc.core;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.build.gcc.core.GCCToolChain;
import org.eclipse.cdt.core.build.IToolChainProvider;
import org.eclipse.cdt.core.envvar.EnvironmentVariable;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;

public class ClangToolChain
extends GCCToolChain {
    private static final String CC = "CC";
    private static final String CXX = "CXX";
    private static final Pattern CC_PATTERN = Pattern.compile("^clang(?:-\\d+)?(?:\\.exe)?$");
    private static final Pattern CXX_PATTERN = Pattern.compile("^clang\\+\\+(?:-\\d+)?(?:\\.exe)?$");
    public static final String TYPE_ID = "org.eclipse.cdt.build.clang";

    public ClangToolChain(IToolChainProvider provider, Path pathToToolChain, String arch, IEnvironmentVariable[] envVars) {
        super(provider, pathToToolChain, arch, ClangToolChain.addCompilerOverrides(pathToToolChain, envVars));
    }

    private static IEnvironmentVariable[] addCompilerOverrides(Path pathToToolChain, IEnvironmentVariable[] envVars) {
        if (pathToToolChain == null) {
            return envVars;
        }
        ArrayList<IEnvironmentVariable> envVarsNew = new ArrayList<IEnvironmentVariable>();
        if (envVars != null) {
            envVarsNew.addAll(Arrays.asList(envVars));
        }
        String[] stringArray = new String[]{CC, CXX};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPath mapped;
            String type = stringArray[n2];
            if (ClangToolChain.isAbsent(type, envVarsNew) && (mapped = ClangToolChain.mapCompilerPath(IPath.fromPath((Path)pathToToolChain), type)) != null) {
                envVarsNew.add((IEnvironmentVariable)new EnvironmentVariable(type, mapped.toString()));
            }
            ++n2;
        }
        return (IEnvironmentVariable[])envVarsNew.toArray(new EnvironmentVariable[0]);
    }

    private static boolean isAbsent(String name, List<IEnvironmentVariable> envVarsNew) {
        return envVarsNew.stream().noneMatch(ev -> {
            if ("win32".equals(Platform.getOS())) {
                return ev.getName().equalsIgnoreCase(name);
            }
            return ev.getName().equals(name);
        });
    }

    private static IPath mapCompilerPath(IPath pathToToolChain, String desiredType) {
        if (!CC.equals(desiredType) && !CXX.equals(desiredType)) {
            return null;
        }
        String filename = pathToToolChain.lastSegment();
        Matcher cxxMatcher = CXX_PATTERN.matcher(filename);
        Matcher ccMatcher = CC_PATTERN.matcher(filename);
        boolean isCXX = cxxMatcher.matches();
        boolean isCC = ccMatcher.matches();
        if (!isCC && !isCXX) {
            return null;
        }
        if (isCXX && CC.equals(desiredType)) {
            String mappedFilename = cxxMatcher.group(0).replaceFirst("^clang\\+\\+", "clang");
            return pathToToolChain.removeLastSegments(1).append(mappedFilename);
        }
        if (isCC && CXX.equals(desiredType)) {
            String mappedFilename = ccMatcher.group(0).replaceFirst("^clang", "clang++");
            return pathToToolChain.removeLastSegments(1).append(mappedFilename);
        }
        return pathToToolChain;
    }

    @Override
    public String getTypeId() {
        return TYPE_ID;
    }
}

