/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.commands;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.ide.ui.resources.AcceleoProject;
import org.eclipse.acceleo.internal.ide.ui.acceleowizardmodel.AcceleoMainClass;
import org.eclipse.acceleo.internal.ide.ui.acceleowizardmodel.AcceleowizardmodelFactory;
import org.eclipse.acceleo.internal.ide.ui.builders.runner.CreateRunnableAcceleoOperation;
import org.eclipse.acceleo.internal.ide.ui.generators.AcceleoUIGenerator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.TreeSelection;

public class CreateAntCommandHandler
extends AbstractHandler {
    private boolean enabled;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object applicationContext = event.getApplicationContext();
        if (applicationContext instanceof IEvaluationContext) {
            IEvaluationContext context = (IEvaluationContext)applicationContext;
            Object defaultVariable = context.getDefaultVariable();
            ArrayList<IProject> projects = new ArrayList<IProject>();
            if (defaultVariable instanceof List) {
                List variables = (List)defaultVariable;
                for (Object object : variables) {
                    if (object instanceof IProject) {
                        IProject project = (IProject)object;
                        projects.add(project);
                        continue;
                    }
                    if (object instanceof IJavaProject) {
                        IJavaProject javaProject = (IJavaProject)object;
                        projects.add(javaProject.getProject());
                        continue;
                    }
                    if (!(Platform.getAdapterManager().getAdapter(object, IProject.class) instanceof IProject)) continue;
                    projects.add((IProject)Platform.getAdapterManager().getAdapter(object, IProject.class));
                }
            } else if (defaultVariable instanceof TreeSelection && ((TreeSelection)defaultVariable).size() > 0) {
                TreeSelection selection = (TreeSelection)defaultVariable;
                List list = selection.toList();
                for (Object object : list) {
                    if (object instanceof IProject) {
                        IProject project = (IProject)object;
                        projects.add(project);
                        continue;
                    }
                    if (object instanceof IJavaProject) {
                        IJavaProject javaProject = (IJavaProject)object;
                        projects.add(javaProject.getProject());
                        continue;
                    }
                    if (!(Platform.getAdapterManager().getAdapter(object, IProject.class) instanceof IProject)) continue;
                    projects.add((IProject)Platform.getAdapterManager().getAdapter(object, IProject.class));
                }
            }
            for (IProject iProject : projects) {
                try {
                    if (!iProject.isAccessible() || !iProject.hasNature("org.eclipse.acceleo.ide.ui.acceleoNature")) continue;
                    this.generateAnt(iProject);
                }
                catch (CoreException e) {
                    AcceleoUIActivator.log((Exception)((Object)e), true);
                }
            }
        }
        return applicationContext;
    }

    private void generateAnt(IProject iProject) {
        AcceleoProject acceleoProject = new AcceleoProject(iProject);
        ArrayList<String> resolvedClasspath = new ArrayList<String>();
        Iterator<IPath> entries = acceleoProject.getResolvedClasspath().iterator();
        IPath eclipseWorkspace = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        Path eclipseHome = new Path(Platform.getInstallLocation().getURL().getPath());
        while (entries.hasNext()) {
            IPath path = entries.next();
            if (eclipseWorkspace.isPrefixOf(path)) {
                resolvedClasspath.add("${ECLIPSE_WORKSPACE}/" + path.toString().substring(eclipseWorkspace.toString().length()));
                continue;
            }
            if (!eclipseHome.isPrefixOf(path)) continue;
            resolvedClasspath.add("${ECLIPSE_HOME}/" + path.toString().substring(eclipseHome.toString().length()));
        }
        AcceleoMainClass acceleoMainClass = AcceleowizardmodelFactory.eINSTANCE.createAcceleoMainClass();
        acceleoMainClass.setProjectName(iProject.getName());
        EList<String> classPath = acceleoMainClass.getResolvedClassPath();
        classPath.addAll(resolvedClasspath);
        IPath workspacePathRelativeToFile = CreateRunnableAcceleoOperation.computeWorkspacePath();
        IPath eclipsePathRelativeToFile = CreateRunnableAcceleoOperation.computeEclipsePath();
        AcceleoUIGenerator.getDefault().generateBuildXML(acceleoMainClass, AcceleoProject.makeRelativeTo(eclipsePathRelativeToFile, iProject.getLocation()).toString(), AcceleoProject.makeRelativeTo(workspacePathRelativeToFile, iProject.getLocation()).toString(), (IContainer)iProject);
    }

    public void setEnabled(Object evaluationContext) {
        if (evaluationContext instanceof IEvaluationContext) {
            IEvaluationContext context = (IEvaluationContext)evaluationContext;
            Object defaultVariable = context.getDefaultVariable();
            if (defaultVariable instanceof List && ((List)defaultVariable).size() > 0) {
                List variables = (List)defaultVariable;
                for (Object object : variables) {
                    try {
                        IProject project;
                        if (object instanceof IProject) {
                            project = (IProject)object;
                            this.enabled = project.isAccessible() && project.hasNature("org.eclipse.acceleo.ide.ui.acceleoNature");
                            continue;
                        }
                        if (object instanceof IJavaProject) {
                            project = ((IJavaProject)object).getProject();
                            this.enabled = project.isAccessible() && project.hasNature("org.eclipse.acceleo.ide.ui.acceleoNature");
                            continue;
                        }
                        if (!(Platform.getAdapterManager().getAdapter(object, IProject.class) instanceof IProject)) continue;
                        project = (IProject)Platform.getAdapterManager().getAdapter(object, IProject.class);
                        this.enabled = project.isAccessible() && project.hasNature("org.eclipse.acceleo.ide.ui.acceleoNature");
                    }
                    catch (CoreException e) {
                        AcceleoUIActivator.log((Exception)((Object)e), true);
                    }
                }
            } else if (defaultVariable instanceof TreeSelection && ((TreeSelection)defaultVariable).size() > 0) {
                TreeSelection selection = (TreeSelection)defaultVariable;
                List list = selection.toList();
                for (Object object : list) {
                    try {
                        IProject project;
                        if (object instanceof IProject) {
                            project = (IProject)object;
                            this.enabled = project.isAccessible() && project.hasNature("org.eclipse.acceleo.ide.ui.acceleoNature");
                            continue;
                        }
                        if (object instanceof IJavaProject) {
                            project = ((IJavaProject)object).getProject();
                            this.enabled = project.isAccessible() && project.hasNature("org.eclipse.acceleo.ide.ui.acceleoNature");
                            continue;
                        }
                        if (!(Platform.getAdapterManager().getAdapter(object, IProject.class) instanceof IProject)) continue;
                        project = (IProject)Platform.getAdapterManager().getAdapter(object, IProject.class);
                        this.enabled = project.isAccessible() && project.hasNature("org.eclipse.acceleo.ide.ui.acceleoNature");
                    }
                    catch (CoreException e) {
                        AcceleoUIActivator.log((Exception)((Object)e), true);
                    }
                }
            }
        } else {
            this.enabled = true;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

