/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.core.launch.execution;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.debug.core.DebugException;
import org.eclipse.php.composer.core.launch.execution.ExecutionResponseListener;
import org.eclipse.php.composer.core.launch.execution.Messages;
import org.eclipse.php.composer.core.log.Logger;

public class ScriptExecutor {
    private StringBuilder outBuilder;
    private StringBuilder errBuilder;
    private long timeout = 60000L;
    private Set<ExecutionResponseListener> listeners = new HashSet<ExecutionResponseListener>();
    private File workingDirectory;
    private Process process;

    public ScriptExecutor() {
        this.outBuilder = new StringBuilder();
        this.errBuilder = new StringBuilder();
    }

    public void addResponseListener(ExecutionResponseListener listener) {
        this.listeners.add(listener);
    }

    public void removeResponseListener(ExecutionResponseListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * Unable to fully structure code
     */
    public void execute(ProcessBuilder launch) {
        block11: {
            try {
                for (ExecutionResponseListener handler : this.listeners) {
                    handler.executionAboutToStart();
                }
                Logger.debug("executing command using executable: " + launch.command().get(0));
                if (this.workingDirectory != null) {
                    launch.directory(this.workingDirectory);
                }
                this.process = launch.start();
                for (ExecutionResponseListener handler : this.listeners) {
                    handler.executionStarted();
                }
                outputReader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
                while ((line = outputReader.readLine()) != null) {
                    for (ExecutionResponseListener handler : this.listeners) {
                        handler.executionMessage(line);
                        this.outBuilder.append(line);
                    }
                }
                errorReader = new BufferedReader(new InputStreamReader(this.process.getErrorStream()));
                while ((line = errorReader.readLine()) != null) {
                    for (ExecutionResponseListener handler : this.listeners) {
                        handler.executionError(line);
                        this.errBuilder.append(line);
                    }
                }
                result = this.process.waitFor();
                for (ExecutionResponseListener handler : this.listeners) {
                    handler.executionFinished(this.outBuilder.toString(), result);
                }
                break block11;
            }
            catch (Exception e) {
                ** for (handler : this.listeners)
            }
lbl-1000:
            // 1 sources

            {
                handler.executionFailed("", e);
                continue;
            }
        }
    }

    public void abort() throws DebugException {
        if (this.process != null && this.process.isAlive()) {
            this.process.destroyForcibly();
        }
    }

    public void setWorkingDirectory(File dir) {
        this.workingDirectory = dir;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setTimeout(long timeout) {
        if (timeout < 0L) {
            throw new IllegalArgumentException(Messages.ScriptExecutor_NegativeTimeoutError);
        }
        this.timeout = timeout;
    }
}

