/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.refactoring.internal;

import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.m2e.refactoring.internal.Activator;

public class RefactoringImages {
    private static final ILog log = Platform.getLog(RefactoringImages.class);
    public static final ImageDescriptor EXCLUDE = RefactoringImages.create("exclude.gif");

    private static ImageDescriptor create(String key) {
        try {
            ImageDescriptor imageDescriptor = RefactoringImages.createDescriptor(key);
            ImageRegistry imageRegistry = RefactoringImages.getImageRegistry();
            if (imageRegistry != null) {
                imageRegistry.put(key, imageDescriptor);
            }
            return imageDescriptor;
        }
        catch (Exception ex) {
            log.error(key, (Throwable)ex);
            return null;
        }
    }

    private static ImageRegistry getImageRegistry() {
        Activator plugin = Activator.getDefault();
        return plugin == null ? null : plugin.getImageRegistry();
    }

    private static ImageDescriptor createDescriptor(String image) {
        return (ImageDescriptor)ResourceLocator.imageDescriptorFromBundle((String)"org.eclipse.m2e.refactoring", (String)("icons/" + image)).get();
    }
}

