/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.editors.listeners;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class ResourceDeltaVisitor
implements IResourceDeltaVisitor {
    protected ResourceSet resourceSet;
    protected Collection<Resource> savedResources;
    protected Collection<Resource> changedResources = new ArrayList<Resource>();
    protected Collection<Resource> removedResources = new ArrayList<Resource>();

    public void init(ResourceSet resourceSet, Collection<Resource> savedResources) {
        this.resourceSet = resourceSet;
        this.savedResources = savedResources;
    }

    public boolean visit(IResourceDelta delta) {
        Resource resource;
        if (delta.getResource().getType() == 1 && this.deltaShouldBeHandled(delta) && (resource = this.resourceSet.getResource(URI.createPlatformResourceURI((String)delta.getFullPath().toString(), (boolean)true), false)) != null) {
            if (delta.getKind() == 2) {
                this.removedResources.add(resource);
            } else if (!this.savedResources.remove(resource)) {
                this.changedResources.add(resource);
            }
        }
        return true;
    }

    private boolean deltaShouldBeHandled(IResourceDelta delta) {
        return delta.getKind() == 2 || delta.getKind() == 4 && delta.getFlags() != 131072;
    }

    public Collection<Resource> getChangedResources() {
        return this.changedResources;
    }

    public Collection<Resource> getRemovedResources() {
        return this.removedResources;
    }
}

