/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.datatools.enablement.sybase.ui.SybaseDatabaseProfileSetting;
import org.eclipse.datatools.enablement.sybase.ui.SybaseDatabaseSetting;

public class SybaseDatabaseProfileSettingManager {
    private static SybaseDatabaseProfileSettingManager instance = null;
    private List profileSettings = new ArrayList();
    private List databaseSettings = new ArrayList();
    private boolean isShowSchemaGlobal = false;
    private boolean isShowOwnerGlobal = true;
    public static final String PREFERENCE_SHOW_OWNER = "org.eclipse.datatools.enablement.sybase.isShowOwner";
    public static final String PREFERENCE_SHOW_SCHEMA = "org.eclipse.datatools.enablement.sybase.isSchemaEnabled";

    private SybaseDatabaseProfileSettingManager() {
    }

    public static SybaseDatabaseProfileSettingManager getInstance() {
        if (instance == null) {
            instance = new SybaseDatabaseProfileSettingManager();
        }
        return instance;
    }

    public boolean isShowSchema(String profileId) {
        SybaseDatabaseProfileSetting setting = this.findSettingByProfile(profileId);
        return setting == null ? this.isShowSchemaGlobal : setting.isShowSchema();
    }

    public boolean isShowSchema(String profileId, String databaseName) {
        SybaseDatabaseSetting databaseSetting = this.findSettingByProfileAndDatabase(profileId, databaseName);
        if (databaseSetting != null) {
            return databaseSetting.isShowSchema();
        }
        SybaseDatabaseProfileSetting profileSetting = this.findSettingByProfile(profileId);
        return profileSetting == null ? this.isShowSchemaGlobal : profileSetting.isShowSchema();
    }

    public void setShowSchema(String profileId, boolean isShowSchema) {
        SybaseDatabaseProfileSetting profileSetting = this.findSettingByProfile(profileId);
        if (profileSetting == null) {
            profileSetting = SybaseDatabaseProfileSetting.newInstance(profileId);
            profileSetting.setShowSchema(isShowSchema);
            this.profileSettings.add(profileSetting);
        } else {
            profileSetting.setShowSchema(isShowSchema);
        }
        for (SybaseDatabaseSetting setting : this.databaseSettings) {
            if (!profileId.equals(setting.getConnectionProfileId())) continue;
            setting.setShowSchema(isShowSchema);
        }
    }

    public void setShowSchema(String profileId, String databaseName, boolean isShowSchema) {
        SybaseDatabaseSetting databaseSetting = this.findSettingByProfileAndDatabase(profileId, databaseName);
        if (databaseSetting == null) {
            databaseSetting = SybaseDatabaseSetting.newInstance(profileId, databaseName);
            databaseSetting.setShowSchema(isShowSchema);
            SybaseDatabaseProfileSetting profileSetting = this.findSettingByProfile(profileId);
            if (profileSetting != null) {
                databaseSetting.setShowOwner(profileSetting.isShowOwner());
            }
            this.databaseSettings.add(databaseSetting);
        } else {
            databaseSetting.setShowSchema(isShowSchema);
        }
    }

    public boolean isShowOwner(String profileId) {
        SybaseDatabaseProfileSetting setting = this.findSettingByProfile(profileId);
        return setting == null ? this.isShowOwnerGlobal : setting.isShowOwner();
    }

    public boolean isShowOwner(String profileId, String databaseName) {
        SybaseDatabaseSetting databaseSetting = this.findSettingByProfileAndDatabase(profileId, databaseName);
        if (databaseSetting != null) {
            return databaseSetting.isShowOwner();
        }
        SybaseDatabaseProfileSetting profileSetting = this.findSettingByProfile(profileId);
        return profileSetting == null ? this.isShowOwnerGlobal : profileSetting.isShowOwner();
    }

    public void setShowOwner(String profileId, boolean isShowOwner) {
        SybaseDatabaseProfileSetting profileSetting = this.findSettingByProfile(profileId);
        if (profileSetting == null) {
            profileSetting = SybaseDatabaseProfileSetting.newInstance(profileId);
            profileSetting.setShowOwner(isShowOwner);
            this.profileSettings.add(profileSetting);
        } else {
            profileSetting.setShowOwner(isShowOwner);
        }
        for (SybaseDatabaseSetting setting : this.databaseSettings) {
            if (!profileId.equals(setting.getConnectionProfileId())) continue;
            setting.setShowOwner(isShowOwner);
        }
    }

    public void setShowOwner(String profileId, String databaseName, boolean isShowOwner) {
        SybaseDatabaseSetting databaseSetting = this.findSettingByProfileAndDatabase(profileId, databaseName);
        if (databaseSetting == null) {
            databaseSetting = SybaseDatabaseSetting.newInstance(profileId, databaseName);
            databaseSetting.setShowOwner(isShowOwner);
            SybaseDatabaseProfileSetting profileSetting = this.findSettingByProfile(profileId);
            if (profileSetting != null) {
                databaseSetting.setShowSchema(profileSetting.isShowSchema());
            }
            this.databaseSettings.add(databaseSetting);
        } else {
            databaseSetting.setShowOwner(isShowOwner);
        }
    }

    private SybaseDatabaseProfileSetting findSettingByProfile(String profileId) {
        if (profileId == null) {
            return null;
        }
        for (SybaseDatabaseProfileSetting profileSetting : this.profileSettings) {
            if (!profileId.equals(profileSetting.getDatabaseProfileId())) continue;
            return profileSetting;
        }
        return null;
    }

    private SybaseDatabaseSetting findSettingByProfileAndDatabase(String profileId, String databaseName) {
        if (profileId == null || databaseName == null) {
            return null;
        }
        for (SybaseDatabaseSetting databaseSetting : this.databaseSettings) {
            if (!profileId.equals(databaseSetting.getConnectionProfileId()) || !databaseName.equals(databaseSetting.getDatabaseName())) continue;
            return databaseSetting;
        }
        return null;
    }

    public void setShowSchemaGlobal(boolean isShowSchemaGlobal) {
        this.isShowSchemaGlobal = isShowSchemaGlobal;
        for (SybaseDatabaseProfileSetting profileSetting : this.profileSettings) {
            profileSetting.setShowSchema(isShowSchemaGlobal);
        }
        for (SybaseDatabaseSetting databaseSetting : this.databaseSettings) {
            databaseSetting.setShowSchema(isShowSchemaGlobal);
        }
    }

    public void setShowOwnerGlobal(boolean isShowOwnerGlobal) {
        this.isShowOwnerGlobal = isShowOwnerGlobal;
        for (SybaseDatabaseProfileSetting profileSetting : this.profileSettings) {
            profileSetting.setShowOwner(isShowOwnerGlobal);
        }
        for (SybaseDatabaseSetting databaseSetting : this.databaseSettings) {
            databaseSetting.setShowOwner(isShowOwnerGlobal);
        }
    }
}

