/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import org.eclipse.cdt.internal.ui.text.CPairMatcher;
import org.eclipse.cdt.internal.ui.text.CWordFinder;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;

public class CDoubleClickSelector
implements ITextDoubleClickStrategy {
    protected static char[] fgBrackets = new char[]{'{', '}', '(', ')', '[', ']', '<', '>'};
    private CPairMatcher fPairMatcher = new CPairMatcher(fgBrackets);

    public void doubleClicked(ITextViewer textViewer) {
        int offset = textViewer.getSelectedRange().x;
        if (offset < 0) {
            return;
        }
        IDocument document = textViewer.getDocument();
        IRegion region = this.fPairMatcher.match(document, offset);
        if (region != null && region.getLength() >= 2) {
            textViewer.setSelectedRange(region.getOffset() + 1, region.getLength() - 2);
        } else {
            region = this.selectWord(document, offset);
            if (region != null && region.getLength() > 0) {
                textViewer.setSelectedRange(region.getOffset(), region.getLength());
            }
        }
    }

    protected IRegion selectWord(IDocument document, int offset) {
        return CWordFinder.findWord(document, offset);
    }
}

