/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.launching;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.debug.core.launching.PHPLaunchUtilities;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;
import org.eclipse.php.internal.debug.ui.launching.AbstractPHPLaunchConfigurationDebuggerTab;
import org.eclipse.php.internal.debug.ui.launching.Messages;
import org.eclipse.php.internal.debug.ui.wizards.PHPExeEditDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class PHPExeLaunchConfigurationDebuggerTab
extends AbstractPHPLaunchConfigurationDebuggerTab {
    @Override
    protected void handleConfigureDebugger() {
        PHPexeItem phpExe = this.getPHPExe();
        if (phpExe != null) {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            NullProgressMonitor monitor = new NullProgressMonitor();
            PHPExeEditDialog dialog = new PHPExeEditDialog(shell, phpExe, PHPexes.getInstance().getAllItems(), "org.eclipse.php.debug.ui.fragments.debuggerCompositeFragment");
            if (dialog.open() == 1) {
                monitor.setCanceled(true);
                return;
            }
        }
    }

    @Override
    protected String getCurrentDebuggerId() {
        PHPexeItem phpExe = this.getPHPExe();
        if (phpExe == null) {
            return "org.eclipse.php.debug.core.noneDebugger";
        }
        return phpExe.getDebuggerID();
    }

    @Override
    protected String getNoDebuggerMessage() {
        return MessageFormat.format(Messages.PHPExeLaunchConfigurationDebuggerTab_No_debugger_is_attached_to_configuration, this.getPHPExe() != null ? this.getPHPExe().getName() : Messages.PHPExeLaunchConfigurationDebuggerTab_none);
    }

    @Override
    protected void updateDebugTest() {
        this.validateDebuggerBtn.setVisible(false);
    }

    @Override
    protected void performDebugTest() {
    }

    private PHPexeItem getPHPExe() {
        PHPexeItem phpExe = null;
        try {
            phpExe = PHPLaunchUtilities.getPHPExe((ILaunchConfiguration)this.getConfiguration());
        }
        catch (CoreException e) {
            Logger.logException((Throwable)e);
        }
        return phpExe;
    }
}

