/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.internal.locator;

import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jst.jsf.common.internal.locator.ILocator;
import org.eclipse.jst.jsf.common.internal.locator.ILocatorChangeListener;

public abstract class AbstractLocator<LOCATORTYPE, CONTEXTTYPE, IDTYPE>
implements ILocator<LOCATORTYPE, CONTEXTTYPE, IDTYPE> {
    protected static final Object DEFAULT_NO_RESULT_VALUE = null;
    private final CopyOnWriteArrayList<ILocatorChangeListener> _listeners;
    private final LOCATORTYPE _noResultValue;
    private final IDTYPE _id;
    private final String _displayName;
    private boolean _isStarted;
    private Exception _startTrace;

    public AbstractLocator(IDTYPE id, String displayName) {
        this(id, displayName, null, new CopyOnWriteArrayList<ILocatorChangeListener>());
    }

    protected AbstractLocator(IDTYPE id, String displayName, LOCATORTYPE noResultValue, CopyOnWriteArrayList<ILocatorChangeListener> mutableListenerList) {
        this._id = id;
        this._displayName = displayName;
        this._listeners = mutableListenerList;
        this._noResultValue = noResultValue;
    }

    @Override
    public final LOCATORTYPE perform(CONTEXTTYPE context) throws Exception {
        return this.locate(context);
    }

    @Override
    public LOCATORTYPE getNoResult() {
        return this._noResultValue;
    }

    @Override
    public IDTYPE getId() {
        return this._id;
    }

    @Override
    public String getDisplayName() {
        return this._displayName;
    }

    @Override
    public LOCATORTYPE locate(CONTEXTTYPE context) {
        if (this.isStarted()) {
            return this.doLocate(context);
        }
        throw new IllegalStateException("Locator not started");
    }

    protected abstract LOCATORTYPE doLocate(CONTEXTTYPE var1);

    @Override
    public void start(CONTEXTTYPE initialContext) {
        if (this.isStarted()) {
            throw new IllegalStateException("Locator was already started", this._startTrace);
        }
        this.setStarted(true);
        this._startTrace = new Exception("Locator was started on this trace");
    }

    @Override
    public void stop() {
        this._listeners.clear();
        this.setStarted(false);
        this._startTrace = null;
    }

    @Override
    public void addListener(ILocatorChangeListener listener) {
        this._listeners.addIfAbsent(listener);
    }

    @Override
    public void removeListener(ILocatorChangeListener listener) {
        this._listeners.remove(listener);
    }

    protected void fireChangeEvent(ILocatorChangeListener.LocatorChangeEvent event) {
        for (ILocatorChangeListener listener : this._listeners) {
            listener.changed(event);
        }
    }

    @Override
    public final boolean isStarted() {
        return this._isStarted;
    }

    @Override
    public boolean canStart() {
        return !this.isStarted();
    }

    protected final void setStarted(boolean newValue) {
        this._isStarted = newValue;
    }
}

