/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateTypeParameter;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPUnknownTypeScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPASTInternalTemplateDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.core.runtime.PlatformObject;

public class CPPImplicitTemplateTypeParameter
extends PlatformObject
implements ICPPTemplateTypeParameter,
ICPPUnknownType,
ICPPUnknownBinding {
    private int fParameterID;
    private boolean fIsParameterPack;
    private ICPPScope fUnknownScope;
    private ICPPTemplateDefinition fContainingTemplate;
    private IASTNode fNode;

    public CPPImplicitTemplateTypeParameter(IASTNode node, int position, boolean isParameterPack) {
        this.fParameterID = this.computeParameterID(position);
        this.fIsParameterPack = isParameterPack;
        this.fNode = node;
    }

    private int computeParameterID(int position) {
        int nesting = 0;
        IASTNode node = this.fNode;
        while (node != null) {
            if (node instanceof ICPPASTInternalTemplateDeclaration) {
                nesting = ((ICPPASTInternalTemplateDeclaration)node).getNestingLevel();
                break;
            }
            node = node.getParent();
        }
        return (nesting << 16) + (position & 0xFFFF);
    }

    public void setContainingTemplate(ICPPTemplateDefinition containingTemplate) {
        this.fContainingTemplate = containingTemplate;
    }

    @Override
    public String[] getQualifiedName() throws DOMException {
        return new String[]{this.getName()};
    }

    @Override
    public char[][] getQualifiedNameCharArray() throws DOMException {
        return new char[][]{this.getNameCharArray()};
    }

    @Override
    public boolean isGloballyQualified() throws DOMException {
        return false;
    }

    @Override
    public String getName() {
        return new String();
    }

    @Override
    public char[] getNameCharArray() {
        return CharArrayUtils.EMPTY;
    }

    @Override
    public ILinkage getLinkage() {
        return Linkage.CPP_LINKAGE;
    }

    @Override
    public IBinding getOwner() {
        return this.fContainingTemplate;
    }

    @Override
    public IScope getScope() throws DOMException {
        return CPPVisitor.getContainingScope(this.fNode);
    }

    @Override
    public short getParameterPosition() {
        return (short)this.fParameterID;
    }

    @Override
    public short getTemplateNestingLevel() {
        return (short)(this.fParameterID >> 16);
    }

    @Override
    public int getParameterID() {
        return this.fParameterID;
    }

    @Override
    public ICPPTemplateArgument getDefaultValue() {
        return null;
    }

    @Override
    public boolean isParameterPack() {
        return this.fIsParameterPack;
    }

    @Override
    public IType getDefault() throws DOMException {
        return null;
    }

    @Override
    public boolean isSameType(IType type) {
        if (type == this) {
            return true;
        }
        if (type instanceof ITypedef) {
            return type.isSameType(this);
        }
        if (!(type instanceof ICPPTemplateTypeParameter)) {
            return false;
        }
        return this.getParameterID() == ((ICPPTemplateParameter)((Object)type)).getParameterID();
    }

    @Override
    public Object clone() {
        return new CPPImplicitTemplateTypeParameter(this.fNode, this.getParameterPosition(), this.fIsParameterPack);
    }

    @Override
    public ICPPScope asScope() throws DOMException {
        if (this.fUnknownScope == null) {
            this.fUnknownScope = new CPPUnknownTypeScope(this, null);
        }
        return this.fUnknownScope;
    }
}

