/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.time.Clock;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.temporal.Temporal;
import java.util.Arrays;
import org.assertj.core.annotation.CheckReturnValue;
import org.assertj.core.api.AbstractTemporalAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.data.TemporalOffset;
import org.assertj.core.data.TemporalUnitOffset;
import org.assertj.core.error.ShouldBeEqualIgnoringHours;
import org.assertj.core.error.ShouldBeEqualIgnoringMinutes;
import org.assertj.core.error.ShouldBeEqualIgnoringNanos;
import org.assertj.core.error.ShouldBeEqualIgnoringSeconds;
import org.assertj.core.error.ShouldBeInTheFuture;
import org.assertj.core.error.ShouldBeInThePast;
import org.assertj.core.error.ShouldHaveDateField;
import org.assertj.core.internal.ChronoLocalDateTimeComparator;
import org.assertj.core.internal.Comparables;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;
import org.assertj.core.util.Preconditions;

public abstract class AbstractLocalDateTimeAssert<SELF extends AbstractLocalDateTimeAssert<SELF>>
extends AbstractTemporalAssert<SELF, LocalDateTime> {
    public static final String NULL_LOCAL_DATE_TIME_PARAMETER_MESSAGE = "The LocalDateTime to compare actual with should not be null";

    protected AbstractLocalDateTimeAssert(LocalDateTime actual, Class<?> selfType) {
        super(actual, selfType);
        this.comparables = this.buildDefaultComparables();
    }

    public SELF isBefore(LocalDateTime other) {
        AbstractLocalDateTimeAssert.assertLocalDateTimeParameterIsNotNull(other);
        this.comparables.assertIsBefore(this.info, (Comparable)this.actual, other);
        return (SELF)((AbstractLocalDateTimeAssert)this.myself);
    }

    public SELF isBefore(String localDateTimeAsString) {
        AbstractLocalDateTimeAssert.assertLocalDateTimeAsStringParameterIsNotNull(localDateTimeAsString);
        return this.isBefore(this.parse(localDateTimeAsString));
    }

    public SELF isBeforeOrEqualTo(LocalDateTime other) {
        AbstractLocalDateTimeAssert.assertLocalDateTimeParameterIsNotNull(other);
        this.comparables.assertIsBeforeOrEqualTo(this.info, (Comparable)this.actual, other);
        return (SELF)((AbstractLocalDateTimeAssert)this.myself);
    }

    public SELF isBeforeOrEqualTo(String localDateTimeAsString) {
        AbstractLocalDateTimeAssert.assertLocalDateTimeAsStringParameterIsNotNull(localDateTimeAsString);
        return this.isBeforeOrEqualTo(this.parse(localDateTimeAsString));
    }

    public SELF isAfterOrEqualTo(LocalDateTime other) {
        AbstractLocalDateTimeAssert.assertLocalDateTimeParameterIsNotNull(other);
        this.comparables.assertIsAfterOrEqualTo(this.info, (Comparable)this.actual, other);
        return (SELF)((AbstractLocalDateTimeAssert)this.myself);
    }

    public SELF isAfterOrEqualTo(String localDateTimeAsString) {
        AbstractLocalDateTimeAssert.assertLocalDateTimeAsStringParameterIsNotNull(localDateTimeAsString);
        return this.isAfterOrEqualTo(this.parse(localDateTimeAsString));
    }

    public SELF isAfter(LocalDateTime other) {
        AbstractLocalDateTimeAssert.assertLocalDateTimeParameterIsNotNull(other);
        this.comparables.assertIsAfter(this.info, (Comparable)this.actual, other);
        return (SELF)((AbstractLocalDateTimeAssert)this.myself);
    }

    public SELF isAfter(String localDateTimeAsString) {
        AbstractLocalDateTimeAssert.assertLocalDateTimeAsStringParameterIsNotNull(localDateTimeAsString);
        return this.isAfter(this.parse(localDateTimeAsString));
    }

    @Override
    public SELF isEqualTo(Object other) {
        if (this.actual == null || other == null) {
            super.isEqualTo(other);
        } else {
            this.comparables.assertEqual(this.info, this.actual, other);
        }
        return (SELF)((AbstractLocalDateTimeAssert)this.myself);
    }

    public SELF isEqualTo(String dateTimeAsString) {
        AbstractLocalDateTimeAssert.assertLocalDateTimeAsStringParameterIsNotNull(dateTimeAsString);
        return (SELF)this.isEqualTo(this.parse(dateTimeAsString));
    }

    @Override
    public SELF isNotEqualTo(Object other) {
        if (this.actual == null || other == null) {
            super.isNotEqualTo(other);
        } else {
            this.comparables.assertNotEqual(this.info, this.actual, other);
        }
        return (SELF)((AbstractLocalDateTimeAssert)this.myself);
    }

    public SELF isNotEqualTo(String dateTimeAsString) {
        AbstractLocalDateTimeAssert.assertLocalDateTimeAsStringParameterIsNotNull(dateTimeAsString);
        return (SELF)this.isNotEqualTo(this.parse(dateTimeAsString));
    }

    public SELF isIn(String ... dateTimesAsString) {
        this.checkIsNotNullAndNotEmpty(dateTimesAsString);
        return (SELF)((AbstractLocalDateTimeAssert)this.isIn(AbstractLocalDateTimeAssert.convertToLocalDateTimeArray(dateTimesAsString)));
    }

    public SELF isNotIn(String ... dateTimesAsString) {
        this.checkIsNotNullAndNotEmpty(dateTimesAsString);
        return (SELF)((AbstractLocalDateTimeAssert)this.isNotIn(AbstractLocalDateTimeAssert.convertToLocalDateTimeArray(dateTimesAsString)));
    }

    public SELF isCloseToUtcNow(TemporalUnitOffset offset) {
        return this.isCloseTo(LocalDateTime.now(Clock.systemUTC()), (TemporalOffset<LocalDateTime>)offset);
    }

    @Override
    @CheckReturnValue
    public SELF usingDefaultComparator() {
        AbstractLocalDateTimeAssert self = (AbstractLocalDateTimeAssert)super.usingDefaultComparator();
        self.comparables = this.buildDefaultComparables();
        return (SELF)self;
    }

    private Comparables buildDefaultComparables() {
        ChronoLocalDateTimeComparator defaultComparator = ChronoLocalDateTimeComparator.getInstance();
        return new Comparables(new ComparatorBasedComparisonStrategy(defaultComparator, defaultComparator.description()));
    }

    private static Object[] convertToLocalDateTimeArray(String ... dateTimesAsString) {
        return Arrays.stream(dateTimesAsString).map(LocalDateTime::parse).toArray();
    }

    private void checkIsNotNullAndNotEmpty(Object[] values) {
        Preconditions.checkArgument(values != null, "The given LocalDateTime array should not be null", new Object[0]);
        Preconditions.checkArgument(values.length > 0, "The given LocalDateTime array should not be empty", new Object[0]);
    }

    private static void assertLocalDateTimeAsStringParameterIsNotNull(String localDateTimeAsString) {
        Preconditions.checkArgument(localDateTimeAsString != null, "The String representing the LocalDateTime to compare actual with should not be null", new Object[0]);
    }

    private static void assertLocalDateTimeParameterIsNotNull(LocalDateTime other) {
        Preconditions.checkArgument(other != null, NULL_LOCAL_DATE_TIME_PARAMETER_MESSAGE, new Object[0]);
    }

    public SELF isEqualToIgnoringNanos(LocalDateTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractLocalDateTimeAssert.assertLocalDateTimeParameterIsNotNull(other);
        if (!AbstractLocalDateTimeAssert.areEqualIgnoringNanos((LocalDateTime)this.actual, other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqualIgnoringNanos.shouldBeEqualIgnoringNanos(this.actual, other));
        }
        return (SELF)((AbstractLocalDateTimeAssert)this.myself);
    }

    @Deprecated
    public SELF isEqualToIgnoringSeconds(LocalDateTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractLocalDateTimeAssert.assertLocalDateTimeParameterIsNotNull(other);
        if (!AbstractLocalDateTimeAssert.areEqualIgnoringSeconds((LocalDateTime)this.actual, other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqualIgnoringSeconds.shouldBeEqualIgnoringSeconds(this.actual, other));
        }
        return (SELF)((AbstractLocalDateTimeAssert)this.myself);
    }

    @Deprecated
    public SELF isEqualToIgnoringMinutes(LocalDateTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractLocalDateTimeAssert.assertLocalDateTimeParameterIsNotNull(other);
        if (!AbstractLocalDateTimeAssert.areEqualIgnoringMinutes((LocalDateTime)this.actual, other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqualIgnoringMinutes.shouldBeEqualIgnoringMinutes(this.actual, other));
        }
        return (SELF)((AbstractLocalDateTimeAssert)this.myself);
    }

    @Deprecated
    public SELF isEqualToIgnoringHours(LocalDateTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractLocalDateTimeAssert.assertLocalDateTimeParameterIsNotNull(other);
        if (!AbstractLocalDateTimeAssert.haveSameYearMonthAndDayOfMonth((LocalDateTime)this.actual, other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqualIgnoringHours.shouldBeEqualIgnoringHours(this.actual, other));
        }
        return (SELF)((AbstractLocalDateTimeAssert)this.myself);
    }

    public SELF isInThePast() {
        Objects.instance().assertNotNull(this.info, this.actual);
        if (!((LocalDateTime)this.actual).isBefore(LocalDateTime.now())) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeInThePast.shouldBeInThePast((Temporal)this.actual));
        }
        return (SELF)((AbstractLocalDateTimeAssert)this.myself);
    }

    public SELF isInTheFuture() {
        Objects.instance().assertNotNull(this.info, this.actual);
        if (!((LocalDateTime)this.actual).isAfter(LocalDateTime.now())) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeInTheFuture.shouldBeInTheFuture((Temporal)this.actual));
        }
        return (SELF)((AbstractLocalDateTimeAssert)this.myself);
    }

    public SELF isBetween(LocalDateTime startInclusive, LocalDateTime endInclusive) {
        this.comparables.assertIsBetween(this.info, (Comparable)this.actual, startInclusive, endInclusive, true, true);
        return (SELF)((AbstractLocalDateTimeAssert)this.myself);
    }

    public SELF isBetween(String startInclusive, String endInclusive) {
        return this.isBetween(this.parse(startInclusive), this.parse(endInclusive));
    }

    public SELF isStrictlyBetween(LocalDateTime startExclusive, LocalDateTime endExclusive) {
        this.comparables.assertIsBetween(this.info, (Comparable)this.actual, startExclusive, endExclusive, false, false);
        return (SELF)((AbstractLocalDateTimeAssert)this.myself);
    }

    public SELF isStrictlyBetween(String startExclusive, String endExclusive) {
        return this.isStrictlyBetween(this.parse(startExclusive), this.parse(endExclusive));
    }

    public SELF hasYear(int year) {
        Objects.instance().assertNotNull(this.info, this.actual);
        if (((LocalDateTime)this.actual).getYear() != year) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldHaveDateField.shouldHaveDateField((Temporal)this.actual, "year", year));
        }
        return (SELF)((AbstractLocalDateTimeAssert)this.myself);
    }

    public SELF hasMonth(Month month) {
        Preconditions.checkArgument(month != null, "The given Month should not be null", new Object[0]);
        Objects.instance().assertNotNull(this.info, this.actual);
        if (!((LocalDateTime)this.actual).getMonth().equals(month)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldHaveDateField.shouldHaveMonth((Temporal)this.actual, month));
        }
        return (SELF)((AbstractLocalDateTimeAssert)this.myself);
    }

    public SELF hasMonthValue(int monthVal) {
        Objects.instance().assertNotNull(this.info, this.actual);
        if (((LocalDateTime)this.actual).getMonthValue() != monthVal) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldHaveDateField.shouldHaveDateField((Temporal)this.actual, "month", monthVal));
        }
        return (SELF)((AbstractLocalDateTimeAssert)this.myself);
    }

    public SELF hasDayOfMonth(int dayOfMonth) {
        Objects.instance().assertNotNull(this.info, this.actual);
        if (((LocalDateTime)this.actual).getDayOfMonth() != dayOfMonth) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldHaveDateField.shouldHaveDateField((Temporal)this.actual, "day of month", dayOfMonth));
        }
        return (SELF)((AbstractLocalDateTimeAssert)this.myself);
    }

    public SELF hasHour(int hour) {
        Objects.instance().assertNotNull(this.info, this.actual);
        if (((LocalDateTime)this.actual).getHour() != hour) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldHaveDateField.shouldHaveDateField((Temporal)this.actual, "hour", hour));
        }
        return (SELF)((AbstractLocalDateTimeAssert)this.myself);
    }

    public SELF hasMinute(int minute) {
        Objects.instance().assertNotNull(this.info, this.actual);
        if (((LocalDateTime)this.actual).getMinute() != minute) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldHaveDateField.shouldHaveDateField((Temporal)this.actual, "minute", minute));
        }
        return (SELF)((AbstractLocalDateTimeAssert)this.myself);
    }

    public SELF hasSecond(int second) {
        Objects.instance().assertNotNull(this.info, this.actual);
        if (((LocalDateTime)this.actual).getSecond() != second) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldHaveDateField.shouldHaveDateField((Temporal)this.actual, "second", second));
        }
        return (SELF)((AbstractLocalDateTimeAssert)this.myself);
    }

    public SELF hasNano(int nano) {
        Objects.instance().assertNotNull(this.info, this.actual);
        if (((LocalDateTime)this.actual).getNano() != nano) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldHaveDateField.shouldHaveDateField((Temporal)this.actual, "nanosecond", nano));
        }
        return (SELF)((AbstractLocalDateTimeAssert)this.myself);
    }

    @Override
    public SELF isCloseTo(LocalDateTime other, TemporalOffset<? super LocalDateTime> offset) {
        return (SELF)((AbstractLocalDateTimeAssert)super.isCloseTo(other, offset));
    }

    @Override
    protected LocalDateTime parse(String localDateTimeAsString) {
        return LocalDateTime.parse(localDateTimeAsString);
    }

    private static boolean areEqualIgnoringNanos(LocalDateTime actual, LocalDateTime other) {
        return AbstractLocalDateTimeAssert.areEqualIgnoringSeconds(actual, other) && actual.getSecond() == other.getSecond();
    }

    private static boolean areEqualIgnoringSeconds(LocalDateTime actual, LocalDateTime other) {
        return AbstractLocalDateTimeAssert.areEqualIgnoringMinutes(actual, other) && actual.getMinute() == other.getMinute();
    }

    private static boolean areEqualIgnoringMinutes(LocalDateTime actual, LocalDateTime other) {
        return AbstractLocalDateTimeAssert.haveSameYearMonthAndDayOfMonth(actual, other) && actual.getHour() == other.getHour();
    }

    private static boolean haveSameYearMonthAndDayOfMonth(LocalDateTime actual, LocalDateTime other) {
        return AbstractLocalDateTimeAssert.haveSameYearAndMonth(actual, other) && actual.getDayOfMonth() == other.getDayOfMonth();
    }

    private static boolean haveSameYearAndMonth(LocalDateTime actual, LocalDateTime other) {
        return AbstractLocalDateTimeAssert.haveSameYear(actual, other) && actual.getMonth() == other.getMonth();
    }

    private static boolean haveSameYear(LocalDateTime actual, LocalDateTime other) {
        return actual.getYear() == other.getYear();
    }
}

