/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.cloudio.util;

import org.eclipse.zest.cloudio.util.RectTree;
import org.eclipse.zest.cloudio.util.SmallRect;

public class CloudMatrix {
    private RectTree tree;
    private final int max;
    private final int minResolution;

    public int getMinResolution() {
        return this.minResolution;
    }

    public CloudMatrix(int maxSize, int minResolution) {
        this.max = maxSize;
        this.minResolution = minResolution;
        this.reset();
    }

    public short get(int x, int y) {
        return this.tree.getRoot().getWordId(x * this.minResolution, y * this.minResolution);
    }

    public boolean isEmpty(int x, int y) {
        short id = this.tree.getRoot().getWordId(x * this.minResolution, y * this.minResolution);
        return id == RectTree.EMPTY;
    }

    public void reset() {
        SmallRect root = new SmallRect(0, 0, this.max, this.max);
        this.tree = new RectTree(root, this.minResolution);
    }

    public void set(RectTree.RectNode node, short id, short xOffset, short yOffset, int minResolution) {
        int cleanX = (xOffset + node.rect.x) / minResolution * minResolution;
        int cleanY = (yOffset + node.rect.y) / minResolution * minResolution;
        SmallRect rect = new SmallRect(cleanX, cleanY, minResolution, minResolution);
        this.tree.insert(rect, id);
    }
}

