/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.handler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.persistence.interfaces.IURIPersistenceService;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.runtime.statushandler.StatusHandlerUtil;
import org.eclipse.tcf.te.runtime.utils.StatusHelper;
import org.eclipse.tcf.te.tcf.core.peers.Peer;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.IPeerModelRefreshService;
import org.eclipse.tcf.te.tcf.locator.model.ModelManager;
import org.eclipse.tcf.te.tcf.ui.help.IContextHelpIds;
import org.eclipse.tcf.te.tcf.ui.nls.Messages;
import org.eclipse.tcf.te.ui.dialogs.RenameDialog;
import org.eclipse.tcf.te.ui.views.ViewsUtil;
import org.eclipse.ui.handlers.HandlerUtil;

public class RenameHandler
extends AbstractHandler {
    private Shell shell = null;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        ISelection selection = this.getSelection(event);
        if (selection != null) {
            this.rename(selection, (ICallback)new Callback(){

                protected void internalDone(Object caller, IStatus status) {
                    ViewsUtil.refresh((String)"org.eclipse.tcf.te.ui.views.View");
                }
            });
        }
        this.shell = null;
        return null;
    }

    protected ISelection getSelection(ExecutionEvent event) {
        return HandlerUtil.getCurrentSelection((ExecutionEvent)event);
    }

    public void rename(final ISelection selection, final ICallback callback) {
        Assert.isNotNull((Object)selection);
        Assert.isNotNull((Object)callback);
        boolean invokeCallback = true;
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            for (Object element : (IStructuredSelection)selection) {
                Assert.isTrue((boolean)(element instanceof IPeerNode));
                final IPeerNode node = (IPeerNode)element;
                RenameDialog dialog = this.createRenameDialog(this.shell, node);
                int ok = dialog.open();
                if (ok != 0) continue;
                final String newName = dialog.getNewName();
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        if (newName != null && !"".equals(newName) && !newName.equals(node.getPeer().getName())) {
                            IPeer oldPeer = node.getPeer();
                            HashMap<String, String> attributes = new HashMap<String, String>(oldPeer.getAttributes());
                            attributes.put("Name", newName);
                            attributes.remove("URI.transient");
                            Peer newPeer = new Peer(attributes);
                            try {
                                IURIPersistenceService uRIPersistenceService = (IURIPersistenceService)ServiceManager.getInstance().getService(IURIPersistenceService.class);
                                if (uRIPersistenceService == null) {
                                    throw new IOException("Persistence service instance unavailable.");
                                }
                                boolean changed = node.setChangeEventsEnabled(false);
                                node.setProperty("PeerInstance", (Object)newPeer);
                                if (changed) {
                                    node.setChangeEventsEnabled(true);
                                }
                                uRIPersistenceService.delete((Object)oldPeer, null);
                                uRIPersistenceService.write((Object)newPeer, null);
                                Protocol.invokeLater((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        node.fireChangeEvent("properties", null, (Object)node.getProperties());
                                    }
                                });
                            }
                            catch (IOException e) {
                                IURIPersistenceService uRIPersistenceService = (IURIPersistenceService)ServiceManager.getInstance().getService(IURIPersistenceService.class);
                                if (uRIPersistenceService != null) {
                                    try {
                                        uRIPersistenceService.delete((Object)newPeer, null);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    try {
                                        boolean changed = node.setChangeEventsEnabled(false);
                                        node.setProperty("PeerInstance", (Object)oldPeer);
                                        if (changed) {
                                            node.setChangeEventsEnabled(true);
                                        }
                                        Protocol.invokeLater((Runnable)new Runnable(){

                                            @Override
                                            public void run() {
                                                node.fireChangeEvent("properties", null, (Object)node.getProperties());
                                            }
                                        });
                                        uRIPersistenceService.write((Object)oldPeer, null);
                                    }
                                    catch (Exception changed) {
                                        // empty catch block
                                    }
                                }
                                String template = NLS.bind((String)Messages.RenameHandler_error_renameFailed, (Object)Messages.PossibleCause);
                                StatusHandlerUtil.handleStatus((IStatus)StatusHelper.getStatus((Throwable)e), (Object)selection, (String)template, (String)Messages.RenameHandler_error_title, (String)IContextHelpIds.MESSAGE_RENAME_FAILED, (Object)this, null, (boolean)true);
                            }
                        }
                    }
                };
                if (Protocol.isDispatchThread()) {
                    runnable.run();
                } else {
                    Protocol.invokeAndWait((Runnable)runnable);
                }
                invokeCallback = false;
                Protocol.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        IPeerModelRefreshService service = (IPeerModelRefreshService)ModelManager.getPeerModel().getService(IPeerModelRefreshService.class);
                        if (service != null) {
                            service.refresh((ICallback)new Callback(){

                                protected void internalDone(Object caller, IStatus status) {
                                    callback.done((Object)RenameHandler.this, Status.OK_STATUS);
                                }
                            });
                        }
                    }
                });
            }
        }
        if (invokeCallback) {
            callback.done((Object)this, Status.OK_STATUS);
        }
    }

    private RenameDialog createRenameDialog(Shell shell, final IPeerNode node) {
        Assert.isNotNull((Object)node);
        final AtomicReference name = new AtomicReference();
        final ArrayList usedNames = new ArrayList();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                IPeerNode[] peers;
                name.set(node.getPeer().getName());
                IPeerModel model = ModelManager.getPeerModel();
                Assert.isNotNull((Object)model);
                IPeerNode[] iPeerNodeArray = peers = model.getPeerNodes();
                int n = peers.length;
                int n2 = 0;
                while (n2 < n) {
                    IPeerNode peer = iPeerNodeArray[n2];
                    String name2 = peer.getPeer().getName();
                    Assert.isNotNull((Object)name2);
                    if (!"".equals(name2) && !usedNames.contains(name2)) {
                        usedNames.add(name2.trim().toUpperCase());
                    }
                    ++n2;
                }
            }
        };
        if (Protocol.isDispatchThread()) {
            runnable.run();
        } else {
            Protocol.invokeAndWait((Runnable)runnable);
        }
        String title = NLS.bind((String)Messages.RenameHandler_dialog_title, name.get());
        String prompt = Messages.RenameHandler_dialog_message;
        String usedError = Messages.RenameHandler_dialog_error_nameExist;
        String formatError = Messages.RenameHandler_dialog_error_nameFormat;
        String label = Messages.RenameHandler_dialog_promptNewName;
        return new RenameDialog(shell, null, title, prompt, usedError, formatError, label, (String)name.get(), "[0-9a-zA-Z. _()-]+", usedNames.toArray(new String[usedNames.size()]), null);
    }

    public boolean canRename(ISelection selection) {
        TreePath treePath;
        Object element;
        Assert.isNotNull((Object)selection);
        boolean canRename = false;
        if (!(selection instanceof ITreeSelection) && selection instanceof IStructuredSelection && !selection.isEmpty()) {
            Iterator it = ((IStructuredSelection)selection).iterator();
            ArrayList<TreePath> treePathes = new ArrayList<TreePath>();
            while (it.hasNext()) {
                Object sel = it.next();
                treePathes.add(new TreePath(new Object[]{sel}));
            }
            selection = new TreeSelection(treePathes.toArray(new TreePath[treePathes.size()]));
        }
        if (selection instanceof ITreeSelection && !selection.isEmpty() && ((ITreeSelection)selection).size() == 1 && (element = (treePath = ((ITreeSelection)selection).getPaths()[0]).getLastSegment()) instanceof IPeerNode) {
            IPeerNode node = (IPeerNode)element;
            canRename = 1 == node.getConnectState();
        }
        return canRename;
    }
}

