/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.operations;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.te.runtime.utils.StatusHelper;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.IOperation;
import org.eclipse.tcf.te.tcf.filesystem.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.filesystem.ui.nls.Messages;
import org.eclipse.ui.PlatformUI;

public class UiExecutor {
    public static IStatus execute(final IOperation operation) {
        final Display display = Display.getCurrent();
        Assert.isNotNull((Object)display);
        final Shell parent = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        final ProgressMonitorDialog dlg = new ProgressMonitorDialog(parent);
        dlg.setOpenOnRun(false);
        display.timerExec(500, new Runnable(){

            @Override
            public void run() {
                Shell shell = dlg.getShell();
                if (shell != null && !shell.isDisposed()) {
                    Shell activeShell = display.getActiveShell();
                    if (activeShell == null || activeShell == parent) {
                        dlg.open();
                    } else {
                        display.timerExec(500, (Runnable)this);
                    }
                }
            }
        });
        final AtomicReference<IStatus> ref = new AtomicReference<IStatus>();
        try {
            dlg.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    ref.set(operation.run(monitor));
                }
            });
        }
        catch (InvocationTargetException e) {
            ref.set(StatusHelper.getStatus((Throwable)e.getTargetException()));
        }
        catch (InterruptedException e) {
            return Status.CANCEL_STATUS;
        }
        IStatus status = (IStatus)ref.get();
        if (!status.isOK() && status.getMessage().length() > 0) {
            ErrorDialog.openError((Shell)parent, (String)operation.getName(), (String)Messages.UiExecutor_errorRunningOperation, (IStatus)status);
            UIPlugin.getDefault().getLog().log(status);
        }
        return status;
    }
}

