/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.validator;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractNodeEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.EndOfLife;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Gate;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElement;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.InstanceRole;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.InteractionUse;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Lifeline;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Message;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Operand;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.SequenceDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.State;
import org.eclipse.sirius.diagram.sequence.business.internal.query.SequenceDiagramQuery;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.validator.AbstractMessageCreationValidator;
import org.eclipse.sirius.ext.base.Option;

public class DefaultMessageCreationValidator
extends AbstractMessageCreationValidator {
    @Override
    public boolean isValid(CreateConnectionRequest request) {
        boolean valid = super.isValid(request);
        if (!(this.sequenceElementTarget instanceof Gate)) {
            valid = valid && this.validateNotCreatingMessageOnState() && this.validateNotCreatingMessageInInteractionUse();
            valid = valid && this.checkTargetLifelineNotExplicitlyCreatedAtUpperTime() && this.checkTargetLifelineNotExplicitlyDestroyedAtLowerTime();
        }
        valid = valid && this.validateNotCreatingMessageInDifferentOperands();
        return valid;
    }

    private boolean checkTargetLifelineNotExplicitlyCreatedAtUpperTime() {
        boolean valid = true;
        SequenceDiagram sequenceDiagram = this.sequenceElementSource.getDiagram();
        SequenceDiagramQuery sequenceDiagramQuery = new SequenceDiagramQuery(sequenceDiagram);
        for (ISequenceEvent sequenceEvent : Iterables.filter((Iterable)sequenceDiagramQuery.getAllSequenceEventsUpperThan(this.firstClickLocation.y), (Predicate)Predicates.not((Predicate)Predicates.instanceOf(Lifeline.class)))) {
            if (!this.isCreateMessageFor(sequenceEvent, ((Lifeline)this.sequenceElementTarget.getLifeline().get()).getInstanceRole())) continue;
            valid = false;
            break;
        }
        return valid;
    }

    private boolean checkTargetLifelineNotExplicitlyDestroyedAtLowerTime() {
        boolean valid = true;
        SequenceDiagram sequenceDiagram = this.sequenceElementSource.getDiagram();
        SequenceDiagramQuery sequenceDiagramQuery = new SequenceDiagramQuery(sequenceDiagram);
        for (ISequenceEvent sequenceEvent : Iterables.filter((Iterable)sequenceDiagramQuery.getAllSequenceEventsLowerThan(this.firstClickLocation.y), (Predicate)Predicates.not((Predicate)Predicates.instanceOf(Lifeline.class)))) {
            if (!this.isDestroyMessageFor(sequenceEvent, ((Lifeline)this.sequenceElementTarget.getLifeline().get()).getInstanceRole())) continue;
            valid = false;
            break;
        }
        return valid;
    }

    protected boolean isSequenceEventOfLifeline(ISequenceEvent sequenceEvent, Option<Lifeline> lifelineTarget) {
        Option lifeline = sequenceEvent.getLifeline();
        if (sequenceEvent instanceof Message) {
            lifeline = ((Message)sequenceEvent).getSourceElement().getLifeline();
        }
        return lifeline.equals(lifelineTarget);
    }

    protected boolean isMessageTargeting(ISequenceEvent sequenceEvent, Option<Lifeline> lifelineTarget) {
        boolean result = false;
        if (sequenceEvent instanceof Message) {
            Message message = (Message)sequenceEvent;
            result = message.getTargetElement().getLifeline().equals(lifelineTarget);
        }
        return result;
    }

    private boolean validateNotCreatingMessageInDifferentOperands() {
        boolean result = true;
        Option sourceParentOperand = null;
        Option sourceGateSiblingOperand = null;
        ISequenceElement iSequenceElement = this.sequenceElementSource;
        if (iSequenceElement instanceof Lifeline) {
            Lifeline l = (Lifeline)iSequenceElement;
            sourceParentOperand = l.getParentOperand(this.secondClickLocation.y);
        } else {
            ISequenceElement iSequenceElement2 = this.sequenceElementSource;
            if (iSequenceElement2 instanceof AbstractNodeEvent) {
                AbstractNodeEvent ane = (AbstractNodeEvent)iSequenceElement2;
                sourceParentOperand = ane.getParentOperand(this.secondClickLocation.y);
            } else {
                ISequenceElement iSequenceElement3 = this.sequenceElementSource;
                if (iSequenceElement3 instanceof ISequenceEvent) {
                    ISequenceEvent ise = (ISequenceEvent)iSequenceElement3;
                    sourceParentOperand = ise.getParentOperand();
                } else {
                    ISequenceElement iSequenceElement4 = this.sequenceElementSource;
                    if (iSequenceElement4 instanceof InstanceRole) {
                        InstanceRole ir = (InstanceRole)iSequenceElement4;
                        sourceParentOperand = ((Lifeline)ir.getLifeline().get()).getParentOperand(this.secondClickLocation.y);
                    } else {
                        ISequenceElement iSequenceElement5 = this.sequenceElementSource;
                        if (iSequenceElement5 instanceof Gate) {
                            Gate g = (Gate)iSequenceElement5;
                            sourceParentOperand = g.getParentOperand();
                            sourceGateSiblingOperand = g.getSiblingOperand();
                        }
                    }
                }
            }
        }
        Option targetParentOperand = null;
        Option targetGateSiblingOperand = null;
        ISequenceElement iSequenceElement6 = this.sequenceElementTarget;
        if (iSequenceElement6 instanceof Lifeline) {
            Lifeline l = (Lifeline)iSequenceElement6;
            targetParentOperand = l.getParentOperand(this.secondClickLocation.y);
        } else {
            ISequenceElement iSequenceElement7 = this.sequenceElementTarget;
            if (iSequenceElement7 instanceof AbstractNodeEvent) {
                AbstractNodeEvent ane = (AbstractNodeEvent)iSequenceElement7;
                targetParentOperand = ane.getParentOperand(this.secondClickLocation.y);
            } else {
                ISequenceElement iSequenceElement8 = this.sequenceElementTarget;
                if (iSequenceElement8 instanceof ISequenceEvent) {
                    ISequenceEvent ise = (ISequenceEvent)iSequenceElement8;
                    targetParentOperand = ise.getParentOperand();
                } else {
                    ISequenceElement iSequenceElement9 = this.sequenceElementTarget;
                    if (iSequenceElement9 instanceof InstanceRole) {
                        InstanceRole ir = (InstanceRole)iSequenceElement9;
                        targetParentOperand = ((Lifeline)ir.getLifeline().get()).getParentOperand(this.secondClickLocation.y);
                    } else {
                        ISequenceElement iSequenceElement10 = this.sequenceElementTarget;
                        if (iSequenceElement10 instanceof Gate) {
                            Gate g = (Gate)iSequenceElement10;
                            targetParentOperand = g.getParentOperand();
                            targetGateSiblingOperand = g.getSiblingOperand();
                        }
                    }
                }
            }
        }
        if (targetParentOperand != null && sourceParentOperand != null) {
            result = targetParentOperand.equals((Object)sourceParentOperand);
            if (sourceGateSiblingOperand != null && sourceGateSiblingOperand.some() && targetParentOperand.some()) {
                boolean bl = result = result || ((Operand)sourceGateSiblingOperand.get()).getCombinedFragment().equals((Object)((Operand)targetParentOperand.get()).getCombinedFragment());
            }
            if (targetGateSiblingOperand != null && targetGateSiblingOperand.some() && sourceParentOperand.some()) {
                result = result || ((Operand)targetGateSiblingOperand.get()).getCombinedFragment().equals((Object)((Operand)sourceParentOperand.get()).getCombinedFragment());
            }
        }
        return result;
    }

    private boolean validateNotCreatingMessageOnState() {
        boolean result = true;
        Option lifelineOption = this.sequenceElementTarget.getLifeline();
        if (this.sequenceElementTarget instanceof Gate) {
            result = true;
        } else if (!lifelineOption.some()) {
            result = false;
        } else {
            Lifeline lifeline = (Lifeline)lifelineOption.get();
            for (State state : lifeline.getDiagram().getAllStates()) {
                if (!((Lifeline)state.getLifeline().get()).equals((Object)lifeline) || !state.getVerticalRange().includes(this.firstClickLocation.y)) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    private boolean validateNotCreatingMessageInInteractionUse() {
        Option lifeline = this.sequenceElementTarget.getLifeline();
        Predicate<InteractionUse> interactionUseOnRealTargetLocation = new Predicate<InteractionUse>(){

            public boolean apply(InteractionUse input) {
                return input.getVerticalRange().includes(DefaultMessageCreationValidator.this.firstClickLocation.y);
            }
        };
        return this.sequenceElementTarget instanceof Gate || lifeline.some() && !Iterables.any((Iterable)((Lifeline)lifeline.get()).getAllCoveringInteractionUses(), (Predicate)interactionUseOnRealTargetLocation);
    }

    protected boolean isCreateMessageFor(ISequenceEvent sequenceEvent, InstanceRole createdInstanceRole) {
        boolean result = false;
        if (sequenceEvent instanceof Message) {
            Message createMessage = (Message)sequenceEvent;
            result = createMessage.getKind() == Message.Kind.CREATION && createMessage.getTargetElement().equals(createdInstanceRole);
        }
        return result;
    }

    protected boolean isDestroyMessageFor(ISequenceEvent sequenceEvent, InstanceRole destroyedInstanceRole) {
        boolean result = false;
        if (sequenceEvent instanceof Message) {
            Message createMessage = (Message)sequenceEvent;
            boolean bl = result = createMessage.getKind() == Message.Kind.DESTRUCTION;
            if (createMessage.getTargetElement() instanceof EndOfLife) {
                EndOfLife endOfLife = (EndOfLife)createMessage.getTargetElement();
                result = ((Lifeline)endOfLife.getLifeline().get()).getInstanceRole().equals((Object)destroyedInstanceRole);
            } else {
                result = false;
            }
        }
        return result;
    }
}

