/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.jface.pshelfviewer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.nebula.jface.pshelfviewer.IShelfViewerFactory;
import org.eclipse.nebula.widgets.opal.commons.ReflectionUtils;
import org.eclipse.nebula.widgets.pshelf.PShelf;
import org.eclipse.nebula.widgets.pshelf.PShelfItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class PShelfViewer
extends StructuredViewer {
    private PShelf pshelf;
    private final IShelfViewerFactory viewerFactory;
    private Map<PShelfItem, Viewer> viewersMap = new HashMap<PShelfItem, Viewer>();
    private final ArrayList<?> EMPTY_SELECTION_LIST = new ArrayList(0);
    protected List<?> lastFiredSelection = this.EMPTY_SELECTION_LIST;
    private boolean transferSelection;
    private ISelection transferredSelection = StructuredSelection.EMPTY;
    private SelectionListener pshelfSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            if (PShelfViewer.this.transferSelection) {
                PShelfViewer.this.preservingSelection(() -> PShelfViewer.this.setSelection(PShelfViewer.this.transferredSelection));
            }
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)PShelfViewer.this, (ISelection)new StructuredSelection(PShelfViewer.this.getSelectionFromWidget()));
            PShelfViewer.this.fireSelectionChanged(event);
        }
    };
    private ISelectionChangedListener sharedViewersListener = event -> {
        SelectionChangedEvent newEvent = new SelectionChangedEvent((ISelectionProvider)this, event.getSelection());
        this.fireSelectionChanged(newEvent);
        this.transferredSelection = event.getSelection();
    };

    public PShelfViewer(Composite container, int style, IShelfViewerFactory viewerFactory) {
        this.viewerFactory = viewerFactory;
        this.pshelf = new PShelf(container, style);
        this.hookControl((Control)this.pshelf);
    }

    public Control getControl() {
        return this.getPShelf();
    }

    public PShelf getPShelf() {
        return this.pshelf;
    }

    public boolean isTransferSelection() {
        return this.transferSelection;
    }

    public void setTransferSelection(boolean transferSelection) {
        this.transferSelection = transferSelection;
    }

    protected void labelProviderChanged() {
        Assert.isNotNull((Object)this.getLabelProvider());
        if (!(this.getLabelProvider() instanceof ILabelProvider)) {
            throw new IllegalArgumentException("Label provider must implement ILabelProvider, got " + this.getLabelProvider() == null ? "null" : this.getLabelProvider().getClass().toString());
        }
        if (this.pshelf != null) {
            PShelfItem[] shelfItems = this.pshelf.getItems();
            int i = 0;
            while (i < shelfItems.length) {
                PShelfItem item = shelfItems[i];
                ILabelProvider lp = (ILabelProvider)this.getLabelProvider();
                item.setText(lp.getText(item.getData()));
                item.setImage(lp.getImage(item.getData()));
                Viewer viewer = this.getViewerForItem(item);
                ContentViewer contentViewer = (ContentViewer)viewer;
                if (contentViewer != null) {
                    contentViewer.setLabelProvider((IBaseLabelProvider)lp);
                }
                ++i;
            }
        }
        super.labelProviderChanged();
    }

    public Viewer getViewerForItem(PShelfItem item) {
        return this.viewersMap.get((Object)item);
    }

    protected void inputChanged(Object input, Object oldInput) {
        this.preservingSelection(() -> {
            this.pshelf.setRedraw(false);
            this.removeAll();
            this.pshelf.setData(this.getRoot());
            this.internalInitializeWidget();
            this.pshelf.setRedraw(true);
        });
    }

    protected void internalInitializeWidget() {
        if (this.pshelf.getItems().length > 0) {
            throw new IllegalStateException("Cannot initialize nonempty pshelf widget.");
        }
        ITreeContentProvider cp = (ITreeContentProvider)this.getContentProvider();
        Object[] elements = cp.getElements(this.getInput());
        int i = 0;
        while (i < elements.length) {
            Object modelNode = elements[i];
            PShelfItem item = new PShelfItem(this.pshelf, 0);
            item.setData(modelNode);
            item.getBody().setLayout((Layout)new FillLayout());
            ILabelProvider lp = (ILabelProvider)this.getLabelProvider();
            item.setText(lp.getText(modelNode));
            Viewer contentViewer = this.viewerFactory.createViewerForContent(item.getBody(), modelNode);
            item.setImage(lp.getImage(modelNode));
            if (contentViewer != null) {
                this.viewersMap.put(item, contentViewer);
                contentViewer.setInput((Object)cp.getChildren(modelNode));
                contentViewer.addSelectionChangedListener(this.sharedViewersListener);
            }
            ++i;
        }
        this.pshelf.addSelectionListener(this.pshelfSelectionListener);
        this.pshelfSelectionListener.widgetSelected(null);
    }

    protected void fireSelectionChanged(SelectionChangedEvent event) {
        List selectionList = ((IStructuredSelection)event.getSelection()).toList();
        if (selectionList.equals(this.lastFiredSelection)) {
            return;
        }
        super.fireSelectionChanged(event);
        this.lastFiredSelection = selectionList;
    }

    protected void removeAll() {
        this.pshelf.removeAll();
        this.viewersMap.clear();
    }

    protected Widget doFindInputItem(Object element) {
        Viewer viewer = this.getViewerForItem(this.pshelf.getSelection());
        if (viewer instanceof StructuredViewer) {
            return (Widget)ReflectionUtils.callMethod((Object)viewer, (String)"doFindInputItem", (Object[])new Object[]{element});
        }
        return null;
    }

    protected Widget doFindItem(Object element) {
        Viewer viewer = this.getViewerForItem(this.pshelf.getSelection());
        if (viewer instanceof StructuredViewer) {
            return (Widget)ReflectionUtils.callMethod((Object)viewer, (String)"doFindItem", (Object[])new Object[]{element});
        }
        return null;
    }

    protected void doUpdateItem(Widget item, Object element, boolean fullMap) {
        Viewer viewer = this.getViewerForItem(this.pshelf.getSelection());
        if (viewer instanceof StructuredViewer) {
            ReflectionUtils.callMethod((Object)viewer, (String)"doUpdateItem", (Object[])new Object[]{item, element, fullMap});
        }
    }

    protected List getSelectionFromWidget() {
        PShelfItem item = this.pshelf.getSelection();
        List<Object> retList = this.EMPTY_SELECTION_LIST;
        Viewer viewer = this.getViewerForItem(item);
        if (viewer == null) {
            return retList;
        }
        IStructuredSelection selection = null;
        if (viewer.getSelection() instanceof IStructuredSelection) {
            selection = (IStructuredSelection)viewer.getSelection();
        }
        if (selection != null) {
            retList = selection.toList();
        }
        return retList;
    }

    protected void internalRefresh(Object element) {
        this.pshelf.redraw();
    }

    public void reveal(Object element) {
        Viewer viewer = this.getViewerForItem(this.pshelf.getSelection());
        if (viewer instanceof StructuredViewer) {
            ((StructuredViewer)viewer).reveal(element);
        }
    }

    protected void setSelectionToWidget(List l, boolean reveal) {
        if (l == null) {
            throw new NullPointerException();
        }
        Viewer viewer = this.getViewerForItem(this.pshelf.getSelection());
        if (viewer != null) {
            viewer.setSelection((ISelection)new StructuredSelection(l), reveal);
        }
    }

    protected void assertContentProviderType(IContentProvider provider) {
        if (!(provider instanceof ITreeContentProvider)) {
            throw new IllegalArgumentException("Content provider for PShelf must implement ITreeContentProvider!");
        }
        super.assertContentProviderType(provider);
    }
}

