/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.language.renaming;

import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gef.dot.internal.language.htmllabel.HtmlTag;
import org.eclipse.gef.dot.internal.language.htmllabel.HtmllabelPackage;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.ui.refactoring.IRefactoringUpdateAcceptor;
import org.eclipse.xtext.ui.refactoring.impl.DefaultRenameStrategy;
import org.eclipse.xtext.ui.refactoring.ui.IRenameElementContext;

public class DotHtmlLabelRenameStrategy
extends DefaultRenameStrategy {
    private EObject targetElement;

    public boolean initialize(EObject targetElement, IRenameElementContext context) {
        if (super.initialize(targetElement, context)) {
            this.targetElement = targetElement;
            return true;
        }
        return false;
    }

    protected String getNameAsText(String nameAsValue, String nameRuleName) {
        return nameAsValue;
    }

    public void createDeclarationUpdates(String newName, ResourceSet resourceSet, IRefactoringUpdateAcceptor updateAcceptor) {
        HtmlTag htmlTag;
        super.createDeclarationUpdates(newName, resourceSet, updateAcceptor);
        URI resourceURI = this.getTargetElementOriginalURI().trimFragment();
        if (this.targetElement instanceof HtmlTag && !(htmlTag = (HtmlTag)this.targetElement).isSelfClosing()) {
            List nodes = NodeModelUtils.findNodesForFeature((EObject)htmlTag, (EStructuralFeature)HtmllabelPackage.Literals.HTML_TAG__CLOSE_NAME);
            if (nodes.size() == 1) {
                INode node = (INode)nodes.get(0);
                ReplaceEdit referenceEdit = new ReplaceEdit(node.getOffset(), node.getLength(), newName);
                updateAcceptor.accept(resourceURI, (TextEdit)referenceEdit);
            } else {
                System.err.println("Exact 1 node is expected for the name of the html closing tag, but got " + nodes.size());
            }
        }
    }
}

