/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class DiffImageDescriptor
extends CompositeImageDescriptor {
    static final int HEIGHT = 16;
    private final ImageData fBaseImageData;
    private final ImageDescriptor fOverlayImage;
    private final int fWidth;
    private final boolean fLeft;
    private final int hashCode;

    public DiffImageDescriptor(Image base, ImageDescriptor overlay, int w, boolean onLeft) {
        ImageData data = null;
        if (base != null && (data = base.getImageData()) == null) {
            data = DEFAULT_IMAGE_DATA;
        }
        this.fBaseImageData = data;
        this.fOverlayImage = overlay;
        this.fWidth = w;
        this.fLeft = onLeft;
        this.hashCode = this.calculateHashCode();
    }

    private int calculateHashCode() {
        int h1 = 0;
        int h2 = 0;
        if (this.fBaseImageData != null) {
            h1 = this.calculateHash(this.fBaseImageData);
        }
        if (this.fOverlayImage != null) {
            h2 = this.fOverlayImage.hashCode();
        }
        return h1 + h2 + this.fWidth;
    }

    private int calculateHash(ImageData baseImageData) {
        int hash = baseImageData.width + baseImageData.height;
        byte[] byArray = baseImageData.data;
        int n = baseImageData.data.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            hash >>>= 1;
            hash ^= b;
            ++n2;
        }
        return hash;
    }

    protected Point getSize() {
        return new Point(this.fWidth, 16);
    }

    protected void drawCompositeImage(int width, int height) {
        if (this.fLeft) {
            if (this.fBaseImageData != null) {
                this.drawImage(this.fBaseImageData, this.fWidth - this.fBaseImageData.width, 0);
            }
            if (this.fOverlayImage != null) {
                ImageData overlay = this.fOverlayImage.getImageData();
                if (overlay == null) {
                    overlay = DEFAULT_IMAGE_DATA;
                }
                this.drawImage(overlay, 0, (16 - overlay.height) / 2);
            }
        } else {
            if (this.fBaseImageData != null) {
                this.drawImage(this.fBaseImageData, 0, 0);
            }
            if (this.fOverlayImage != null) {
                ImageData overlay = this.fOverlayImage.getImageData();
                if (overlay == null) {
                    overlay = DEFAULT_IMAGE_DATA;
                }
                this.drawImage(overlay, this.fWidth - overlay.width, (16 - overlay.height) / 2);
            }
        }
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DiffImageDescriptor) {
            DiffImageDescriptor other = (DiffImageDescriptor)((Object)obj);
            return other.hashCode == this.hashCode && this.isEqual(other.fOverlayImage, this.fOverlayImage) && other.fWidth == this.fWidth && other.fLeft == this.fLeft && this.isEqual(other.fBaseImageData, this.fBaseImageData);
        }
        return false;
    }

    private boolean isEqual(ImageData i1, ImageData i2) {
        if (this.isEqual((Object)i1, (Object)i2)) {
            return true;
        }
        if (i1 == null || i2 == null) {
            return false;
        }
        return i1.width == i2.width && i1.height == i2.height && i1.depth == i2.depth && i1.scanlinePad == i2.scanlinePad && i1.bytesPerLine == i2.bytesPerLine && i1.transparentPixel == i2.transparentPixel && i1.maskPad == i2.maskPad && i1.alpha == i2.alpha && i1.type == i2.type && i1.x == i2.x && i1.y == i2.y && i1.disposalMethod == i2.disposalMethod && i1.delayTime == i2.delayTime && this.equals(i1.data, i2.data) && this.equals(i1.maskData, i2.maskData) && this.equals(i1.alphaData, i2.alphaData);
    }

    private boolean equals(byte[] data, byte[] data2) {
        if (this.isEqual(data, data2)) {
            return true;
        }
        if (data == null || data2 == null) {
            return false;
        }
        if (data.length != data2.length) {
            return false;
        }
        int i = 0;
        while (i < data2.length) {
            if (data[i] != data2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isEqual(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }
}

